﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.TourSample.Client.A01.ViewData;
using Terasoluna.TourSample.Client.Common.View;

namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// ファイルチェック処理画面
    /// </summary>
    [ScreenId("SC_A01_04_01")]
    public partial class SC_A01_04_01View : SC_Z99_01View
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_A01_04_01ViewData ViewData { get; set; }

        public SC_A01_04_01View()
        {
            InitializeComponent();
            ViewData = ValidatableViewDataManager.CreateViewData<SC_A01_04_01ViewData>();
        }

        private void SC_A01_04_01View_Load(object sender, EventArgs e)
        {
            sC_A01_04_01ViewDataBindingSource.DataSource = ViewData;
            toolStripProgressBar1.Visible = true;
        }

        /// <summary>
        /// 参照ボタン押下
        /// </summary>
        private void referButton_Click(object sender, EventArgs e)
        {
            DialogResult result = openFileDialog1.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                ViewData.FilePath = openFileDialog1.FileName;
            }
        }
        
        /// <summary>
        /// チェック開始ボタン押下
        /// </summary>
        private void startCheckButton_Click(object sender, EventArgs e)
        {
            ResetStatus();
            ///イベント処理開始
            a01_04_01EventProcessWorker.RunWorkerAsync();
            cancelButton.Enabled = true;
        }
        /// <summary>
        /// チェック中断ボタン押下
        /// </summary>
        private void cancelButton_Click(object sender, EventArgs e)
        {
            ///キャンセル処理
            a01_04_01EventProcessWorker.CancelAsync();
            cancelButton.Enabled = false;
        }

        /// <summary>
        /// チェック開始ボタン押下完了時
        /// </summary>
        private void a01_04_01EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            cancelButton.Enabled = false;
        }

        /// <summary>
        /// リセット処理
        /// </summary>
        private void ResetStatus()
        {
            virusCheckResultLabel.Text = "未実施";
            virusCheckProgressBar.Value = 0;
            formatCheckResultLabel.Text = "未実施";
            formatCheckProgressBar.Value = 0;
            bizCheckResultLabel.Text = "未実施";
            bizCheckProgressBar.Value = 0;
        }

        /// <summary>
        /// ウィルスチェック進捗状況の変更処理
        /// </summary>
        public void VirusCheckProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            virusCheckProgressBar.Value = e.ProgressPercentage;
            virusCheckResultLabel.Text = e.UserState as string;
        }

        /// <summary>
        /// ファイル形式チェック進捗状況の変更処理
        /// </summary>
        public void FormatCheckProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            formatCheckProgressBar.Value = e.ProgressPercentage;
            formatCheckResultLabel.Text = e.UserState as string;
        }

        /// <summary>
        /// ファイル内容チェック進捗状況の変更処理
        /// </summary>
        public void BizCheckProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            bizCheckProgressBar.Value = e.ProgressPercentage;
            bizCheckResultLabel.Text = e.UserState as string;            
        }

        /// <summary>
        /// EventProcessWorkerの進捗通知
        /// </summary>
        private void a01_04_01EventProcessWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            ///イベント処理実行機能が持つ進捗通知機能によりプログレスバーを表示
            toolStripProgressBar1.Value = e.ProgressPercentage;
        }

    }
}
