﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.A01.ViewData;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.TourSample.Client.Common.ViewData;
using Terasoluna.TourSample.Client.Common.TourServiceReference;
using Terasoluna.DataCopy;
using Terasoluna.Windows.Forms.MessageNotification;
using Terasoluna.Windows.ViewModel;
using Terasoluna.TourSample.Client.Properties;


namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// ツアー情報登録画面
    /// </summary>
    [ScreenId("SC_A01_01_01")]
    public partial class SC_A01_01_01View : SC_Z99_01View
    {        
        /// ViewDataという名前の画面データのプロパティで定義すること        
        public SC_A01_01_01ViewData ViewData { get; set; }

        public SC_A01_01_01View()
        {
            InitializeComponent();
            ///画面遷移機能で画面データの引き継ぎをするためには
            ///コンストラクタで画面データのインスタンスを生成する必要がある
            ViewData = ValidatableViewDataManager.CreateViewData<SC_A01_01_01ViewData>();
        }

        private void SC_A01_01_01View_Load(object sender, EventArgs e)
        {
            ///BindingSourceへの設定
            sC_A01_01_01ViewDataBindingSource.DataSource = ViewData;
        }

        private void registTourButton_Click(object sender, EventArgs e)
        {
            ///イベント非同期実行
            a01_01_01_C01EventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// 追加ボタン押下
        /// </summary>
        private void addChargeButton_Click(object sender, EventArgs e)
        {    
            //担当者登録画面へ遷移
            formForwarderToSC_A01_01_02.Forward();
        }

        /// <summary>
        /// 担当者登録画面がOKボタン押下で閉じられた時に(SC_A01_01_02)担当者テーブルに追加する
        /// </summary>
        private void formForwarderToSC_A01_01_02_ForwardedFormClosed(object sender, ForwardFormClosedEventArgs e)
        {
            if (e.DialogResult == DialogResult.OK)
            {
                ///新しいデータの追加はAddNewメソッドで追加すること
                ///new演算子だとAOP設定されないので使わないこと
                Conductor newConductor = ViewData.Tour.ConductorList.AddNew();
                ///データ変換機能を直接使って遷移先画面データの値からデータコピー
                SC_A01_01_02ViewData nextFormViewData = e.ViewData as SC_A01_01_02ViewData;
                DataCopyManager.Copy(nextFormViewData.Conductor, newConductor);
            }
        }

        /// <summary>
        /// 要求データ生成完了時
        /// </summary>
        private void a01_01_01_C01EventProcessWorker_BuiltRequest(object sender, Terasoluna.Windows.Forms.Events.RequestDataBuiltEventArgs e)
        {
            ///階層ずれのデータのコピー処理
            SC_A01_01_01ViewData viewData = e.ViewData as SC_A01_01_01ViewData;
            TourDto dest = e.RequestData as TourDto;
            DataCopyManager.Copy(viewData.Tour, dest);            
        }

        /// <summary>
        /// ビジネスロジック実行直前
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void a01_01_01_C01EventProcessWorker_Executing(object sender, Terasoluna.Windows.Forms.Events.BizLogicExecutingEventArgs e)
        {
            ///確認ダイアログの表示
            bool result = MessageNotifier.ShowConfirmMessage(this, Resources.INFO_A01_01_0001);
            ///キャンセルの場合はイベントを中断する
            e.Cancel = !result;
        }

        /// <summary>
        /// 登録ボタン押下時のイベント処理完了時
        /// </summary>
        private void a01_01_01_C01EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {
                ///情報ダイアログの表示
                MessageNotifier.ShowInformationMessage(this, Terasoluna.TourSample.Client.Common.Properties.Resources.INFO_COMMON_0001);
            }
        }

        /// <summary>
        /// クリアボタン押下時
        /// </summary>
        private void clearButton_Click(object sender, EventArgs e)
        {
            ///画面データを再生成し、BindingSourceのデータソースを再設定
            ViewData = ValidatableViewDataManager.CreateViewData<SC_A01_01_01ViewData>();
            sC_A01_01_01ViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// 入力値検証処理実行直前
        /// </summary>
        private void a01_01_01_C01EventProcessWorker_Validating(object sender, Terasoluna.Windows.Forms.Events.ViewDataValidatingEventArgs e)
        {
            ///出発地の複数選択可能なリストボックスのエラーをクリア
            cmdC01UserControl1.ClearErrorProviderForDeptPlaceListBox();
        }
        /// <summary>
        /// 入力値検証エラー時
        /// </summary>
        private void a01_01_01_C01EventProcessWorker_DisplayedValidationResults(object sender, Terasoluna.Windows.Forms.Events.ViewDataValidationEventArgs e)
        {
            ///例外的に出発地の複数選択可能なリストボックスのエラーをErrorProviderで個別で表示
            ValidationErrorInfo errorInfo = ViewData.Tour.GetValidationError("DeptPlaceList");
            if (errorInfo != null)
            {
                cmdC01UserControl1.SetMessageToErrorProviderForDeptPlaceListBox(errorInfo.Message);
            }
        }

    }
}
