﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Terasoluna.Windows.Forms.Threading;
using System.Windows.Forms;
using Terasoluna.Unity;
using Microsoft.Practices.Unity;
using Terasoluna.TourSample.Client.Common.TourMtomServiceReference;
using System.ServiceModel;
using Terasoluna.Threading;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.ServiceModel;
using Terasoluna.DataCopy;
using Terasoluna.TourSample.Client.Common.Dto;


namespace Terasoluna.TourSample.Client.A01.BizLogic
{
    /// <summary>
    /// Mtomストリーミング転送モードでファイルダウンロードするビジネスロジック
    /// </summary>
    public class A01_02_01_C02BizLogic
    {
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "TourMtomServicePort_Stream";
        
        /// <summary>
        /// ストリームを読み取るためのバッファサイズ
        /// </summary>
        private const int BUFFER_SIZE = 1024;

        /// <summary>
        /// WCF接続先変更機能を利用するため設定
        /// インスタンス管理コンテナを取得・設定する。
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// Streamでダウンロードするサンプル
        /// Streamの場合、WCFクライアントとStreamオブジェクトを維持するため
        /// 例外的にビジネスロジック内で、UIスレッドにSaveFileDialogの表示を指示
        /// </summary>        
        public FileInfoDto Download(TourSearchKeyDto inputDto)
        {            
            TourMtomServiceClient client = null;
            string fileName = "";
            try
            {
                ///エンドポイントアドレスの取得
                ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
                EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
                client = new TourMtomServiceClient(EndpointName, address);

                ///一時ファイルに保存してビジネスロジックを終了し、
                ///イベント完了時にSaveFileDialogを表示し指定した場所に一時ファイルの内容をコピーする
                using (Stream stream = client.DownloadTourListFileWithStream(inputDto))
                {
                    if (InvocationScope.Current.GetContext<EventProcessContext>().CancellationPending)
                    {
                        ///ユーザにキャンセルされた場合に処理を中断する
                        return new FileInfoDto();
                    }
                    ///一時ファイルへ書き込み
                    fileName = Path.GetTempFileName();
                    using (FileStream outputFile = File.Create(fileName))
                    {
                        byte[] buf = new byte[BUFFER_SIZE];
                        int len = 0;
                        while ((len = stream.Read(buf, 0, buf.Length)) != 0)
                        {
                            outputFile.Write(buf, 0, len);
                        }
                    }
                    if (InvocationScope.Current.GetContext<EventProcessContext>().CancellationPending)
                    {
                        ///ユーザにキャンセルされた場合に、一時ファイルを削除
                        File.Delete(fileName);
                        return new FileInfoDto();
                    }                       
                }

                client.Close();
                return new FileInfoDto(fileName);
            }
            catch (System.Exception)
            {
                if (client != null)
                {
                    client.Abort();
                }
                ///一時ファイルの削除
                if (!string.IsNullOrEmpty(fileName) && File.Exists(fileName))
                {
                    File.Delete(fileName);
                }
                throw;
            }          
        }

     }
}
