package jp.terasoluna.toursample.server.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.toursample.server.domain.model.DeptPlace;
import jp.terasoluna.toursample.server.domain.model.TourCategory;
import jp.terasoluna.toursample.server.domain.model.User;

/**
 *  QueryDAOのモッククラス
 *
 */
public class MockQueryDAO implements QueryDAO {

    public Map<String, Object> executeForMap(String arg0, Object arg1) {

        return null;
    }

    public Map<String, Object>[] executeForMapArray(String arg0, Object arg1) {

        return null;
    }

    public Map<String, Object>[] executeForMapArray(String arg0, Object arg1,
            int arg2, int arg3) {

        return null;
    }

    public List<Map<String, Object>> executeForMapList(String arg0, Object arg1) {

        return null;
    }

    public List<Map<String, Object>> executeForMapList(String arg0,
            Object arg1, int arg2, int arg3) {

        return null;
    }

    public <E> E executeForObject(String sqlId, Object obj, Class clazz) {
        if ("usermanage.selectUserByIdAndPass".equals(sqlId) && obj != null
                && obj instanceof User) {
            User input = (User) obj;
            if ("terasoluna".equals(input.getId())
                    && "password".equals(input.getPassword())) {
                // ユーザID = "terasoluna" パスワード = "password"なら管理者ユーザでログイン
                User output = new User();
                output.setId(input.getId());
                output
                        .setRole(jp.terasoluna.toursample.server.domain.code.RoleEnum.Admin);
                output.setName("テラソルナ");
                return (E) output;
            } else if ("user01".equals(input.getId())
                    && "password".equals(input.getPassword())) {
                // ユーザID = "guest" パスワード = "password"なら一般ユーザでログイン
                User output = new User();
                output.setId(input.getId());
                output
                        .setRole(jp.terasoluna.toursample.server.domain.code.RoleEnum.User);
                output.setName("ユーザ01");
                return (E) output;
            }
        }
        return null;
    }

    public <E> E[] executeForObjectArray(String arg0, Object arg1, Class arg2) {

        return null;
    }

    public <E> E[] executeForObjectArray(String arg0, Object arg1, Class arg2,
            int arg3, int arg4) {

        return null;
    }

    public <E> List<E> executeForObjectList(String sqlId, Object obj) {
        if ("tour.selectTourByTourName".equals(sqlId) && obj != null
                && obj instanceof String) {
            return (List<E>) TourDataStore.getInstance().findByName(
                    (String) obj);
        } else if ("tour.selectDeptPlaces".equals(sqlId)) {
            ArrayList<DeptPlace> codeList = new ArrayList<DeptPlace>();
            codeList.add(new DeptPlace("Tokyo", "東京", null));
            codeList.add(new DeptPlace("Osaka", "大阪", null));
            codeList.add(new DeptPlace("Nagoya", "名古屋", null));
            codeList.add(new DeptPlace("Fukuoka", "福岡", null));
            codeList.add(new DeptPlace("Sapporo", "札幌", null));
            return (List<E>) codeList;
        } else if ("tour.selectTourCategories".equals(sqlId)) {
            ArrayList<TourCategory> codeList = new ArrayList<TourCategory>();
            codeList.add(new TourCategory("AmusementPark","遊園地・テーマパーク",  null));
            codeList.add(new TourCategory("Gourmet","グルメ", null));
            codeList.add(new TourCategory("HotSpring", "温泉", null));
            codeList.add(new TourCategory("Ski", "スキー・スノボード", null));
            codeList.add(new TourCategory("Beach", "ビーチ・海水浴", null));
            codeList.add(new TourCategory("Diving","ダイビング", null));
            codeList.add(new TourCategory("Golf","ゴルフ", null));
            return (List<E>) codeList;
        }
        return null;
    }

    public <E> List<E> executeForObjectList(String arg0, Object arg1, int arg2,
            int arg3) {

        return null;
    }

}
