package jp.terasoluna.toursample.server.interfaces.ws.exception;

import javax.xml.ws.WebFault;

/**
 * Terasoluna Client FW for .NET 3.0によるクライアントでの例外ハンドリングを考慮した
 * WebFaultのサンプル実装
 */
@WebFault(name = "SampleSoapFault", targetNamespace = "http://jp.terasoluna.toursample", faultBean = "jp.terasoluna.toursample.server.common.exception.SampleFaultBean")
public class SampleSoapFaultException extends Exception {

    private static final long serialVersionUID = -9174594089171472166L;

    private SampleFaultBean faultBean;

    public SampleSoapFaultException(String message) {
        super(message);
        this.faultBean = new SampleFaultBean();
    }

    public SampleSoapFaultException(String message, SampleFaultBean faultInfo) {
        super(message);
        this.faultBean = faultInfo;
    }

    public SampleSoapFaultException(String message, SampleFaultBean faultInfo,
            Throwable cause) {
        super(message, cause);
        this.faultBean = faultInfo;
    }

    public SampleFaultBean getFaultInfo() {
        return faultBean;
    }
}
