package jp.terasoluna.toursample.server.interfaces.tour.assembler;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.toursample.server.domain.model.TourCategory;
import jp.terasoluna.toursample.server.interfaces.tour.dto.TourCategoryDto;

public class TourCategoryAssembler {
    public TourCategory fromDto(TourCategoryDto dto)
    {
        return new TourCategory(dto.getId(), dto.getName(), dto.getTourCode());
    }

    public TourCategoryDto toDto(TourCategory category)
    {
        return new TourCategoryDto(category.getId(), category.getName(), category.getTourCode());
    }


    public List<TourCategory> fromDtoList(List<TourCategoryDto> dtoList)
    {
        if (dtoList == null)
        {
            return null;
        }
        List<TourCategory> result = new ArrayList<TourCategory>();
        for (TourCategoryDto dto : dtoList)
        {
            result.add(fromDto(dto));
        }
        return result;
    }


    public List<TourCategoryDto> toDtoList(List<TourCategory> categoryList)
    {
        if (categoryList == null)
        {
            return null;
        }
        List<TourCategoryDto> result = new ArrayList<TourCategoryDto>();
        for (TourCategory category : categoryList)
        {
            result.add(toDto(category));
        }
        return result;
    }
}
