package jp.terasoluna.toursample.server.interfaces.tour.assembler;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.toursample.server.domain.model.DeptPlace;
import jp.terasoluna.toursample.server.interfaces.tour.dto.DeptPlaceDto;

/**
 * DeptPlaceクラスのAssembler
 *
 *
 */
public class DeptPlaceAssembler {
    public DeptPlace fromDto(DeptPlaceDto dto)
    {
        return new DeptPlace(dto.getId(), dto.getName(), dto.getTourCode());
    }

    public DeptPlaceDto toDto(DeptPlace deptPlace)
    {
        return new DeptPlaceDto(deptPlace.getId(), deptPlace.getName(), deptPlace.getTourCode());
    }

    public List<DeptPlace> fromDtoList(List<DeptPlaceDto> dtoList)
    {
        if (dtoList == null)
        {
            return null;
        }
        List<DeptPlace> result = new ArrayList<DeptPlace>();
        for (DeptPlaceDto dto : dtoList)
        {
            result.add(fromDto(dto));
        }
        return result;
    }

    public List<DeptPlaceDto> toDtoList(List<DeptPlace> deptPlaceList)
    {
        if (deptPlaceList == null)
        {
            return null;
        }
        List<DeptPlaceDto> result = new ArrayList<DeptPlaceDto>();
        for (DeptPlace deptPlace : deptPlaceList)
        {
            result.add(toDto(deptPlace));
        }
        return result;
    }
}
