﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.Windows.ViewModel.Validation;
using System.ComponentModel;
using Terasoluna.Validation.Validators;

namespace Terasoluna.TourSample.Client.B01.ViewData
{
    /// <summary>
    /// ログイン画面の画面データクラス（ルート）
    /// </summary>
    [DefaultRuleset("RS01")]
    public class SC_B01_01_01ViewData : ValidatableRootViewData
    {
        [DisplayName("ユーザID")]
        [RequiredValidator(Tag="ユーザID", Ruleset="RS01")]
        public virtual string UserId { get; set; }

        [DisplayName("パスワード")]
        [RequiredValidator(Tag = "パスワード", Ruleset = "RS01")]
        public virtual string Password { get; set; }

        /// <summary>
        /// 遷移先画面へ引き継ぐための隠しフィールドの例
        /// </summary>
        public virtual string UserName { get; set; }

    }
}
