﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.Controls;
using Terasoluna.Windows.Forms.MessageNotification;

using Terasoluna.DataCopy;

namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ユーザ管理業務メニューパネル
    /// </summary>
    public partial class SC_B01_03_00Control : UserControl, ISC_B01_03_01MainContent, IContentControl
    {
        /// <summary>
        /// 画面データ        
        /// </summary>
        private SC_B01_03_00ViewData _viewData;
        public SC_B01_03_00ViewData ViewData
        {
            get
            {
                ///パネル切り替えの場合は、デザイナでの貼り付け時に
                ///画面データのインスタンス生成処理が実行されないように、
                ///ViewDataプロパティへの初回アクセス時に画面データのインスタンスを作成
                if (_viewData == null)
                {
                    _viewData = CreateViewData();
                }
                return _viewData;
            }
        }

        /// <summary>
        /// 画面データの生成
        /// </summary>
        protected virtual SC_B01_03_00ViewData CreateViewData()
        {
            return ValidatableViewDataManager.CreateViewData<SC_B01_03_00ViewData>();
        }

        public SC_B01_03_00Control()
        {
            InitializeComponent();
        }

        private void SC_B01_03_00Control_Load(object sender, EventArgs e)
        {
        }

        #region ISC_B01_03_01MainContent メンバ

        object ISC_B01_03_01MainContent.ViewData
        {
            get { return this.ViewData; }
        }
        
        public SC_B01_03LoginUser LoginUser
        {
            get { return this.ViewData.LoginUser; }
        }

        public string Title
        {
            get { return "ユーザ管理業務メニュー"; }
        }

        public string ExecuteButtonCaption
        {
            get { return null; }
        }

        public bool ExecutionEnabled
        {
            get { return false; }
        }

        public bool BackEnabled
        {
            get { return false; }
        }

        public bool HelpEnabled
        {
            get { return true; }
        }

        public string HelpUrl
        {
            get
            {
                return "sample.chm";
            }
        }

        public void Execute()
        {
            throw new NotSupportedException();
        }

        public void Back()
        {
            throw new NotSupportedException();
        }        
        
        #endregion


        #region IContentControl メンバ
        
        //デザイナがContentPlaceHolderにnullをセットするコードを生成しないよう
        //DefaultValue(null)を付与する
        [DefaultValue(null)]
        public ContentPlaceHolder ContentPlaceHolder { get; set; }

        public void HandleShowing(object sender, ControlEventArgs e)
        {
            ///遷移元遷移先パネル間で画面データをコピーして引き継ぐ例
            ISC_B01_03_01MainContent lastContentControl =
                ContentPlaceHolder.LastContentControl as ISC_B01_03_01MainContent;
            if (lastContentControl == null)
            {
                ///メニュー画面からの遷移時は、遷移元パネルが存在しない
                return;
            }
            ISC_B01_03_01MainContent currentContentControl =
                ContentPlaceHolder.CurrentContentControl as ISC_B01_03_01MainContent;
            DataCopyManager.Copy(lastContentControl.LoginUser, currentContentControl.LoginUser);         
        }

        public void HandleHidden(object sender, ControlEventArgs e)
        {
        }

        #endregion

        /// <summary>
        /// ユーザ登録ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void registerButton_Click(object sender, EventArgs e)
        {
            ContentPlaceHolder.ShowAndCloseContent(typeof(SC_B01_03_01Control));
        }

    }

}
