﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.TourSample.Client.Common.Code;

namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// 国内旅行・海外旅行を選択するラジオボタン
    /// </summary>
    [DefaultBindingProperty("TourType")]
    public partial class SC_A01_01_01_01UserControl : UserControl
    {
        private TourTypeEnum tourType = TourTypeEnum.Unknown;

        public SC_A01_01_01_01UserControl()
        {
            InitializeComponent();
        }

        /// <summary>
        /// バインド対象のプロパティ
        /// </summary>
        [Bindable(true)]
        public TourTypeEnum TourType {
            get
            {
                return tourType;
            }

            set
            {
                if (tourType != value)
                {
                    switch (value)
                    {
                        case TourTypeEnum.Domestic:
                            tourType = value;
                            domesticRadioButton.Checked = true;
                            OnTourTypeChanged(EventArgs.Empty);
                            break;
                        case TourTypeEnum.Abroad:
                            tourType = value;
                            abroadRadioButton.Checked = true;
                            OnTourTypeChanged(EventArgs.Empty);
                            break;
                        default:
                            tourType = value;
                            domesticRadioButton.Checked = false;
                            abroadRadioButton.Checked = false;
                            OnTourTypeChanged(EventArgs.Empty);
                            break;
                    }
                }
            }        
        }

        /// <summary>
        /// PropertyNamedChangeパターン
        /// </summary>
        public event EventHandler TourTypeChanged;

        /// <summary>
        /// TourTypeChangedイベントの発火
        /// </summary>
        protected virtual void OnTourTypeChanged(EventArgs e)
        {
            EventHandler handler = TourTypeChanged;
            if (handler != null)
            {
                handler(this, e);
            }
        }

        /// <summary>
        /// 国内旅行ラジオボタンのチェック時
        /// </summary>
        private void domesticRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (domesticRadioButton.Checked)
            {
                tourType = TourTypeEnum.Domestic;
                OnTourTypeChanged(EventArgs.Empty);
            }
        }

        /// <summary>
        /// 海外旅行ラジオボタンのチェック時
        /// </summary>
        private void abroadRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (abroadRadioButton.Checked)
            {
                tourType = TourTypeEnum.Abroad;
                OnTourTypeChanged(EventArgs.Empty);
            }
        }


        /// ラジオボタンが未選択状態（TourTypeEnum.Unknown）の場合にも、
        /// ラジオボタンにフォーカスが当たるようにEnterイベントを実装
        private void SC_A01_01_01_01UserControl_Enter(object sender, EventArgs e)
        {
            if (abroadRadioButton.Checked)
            {
                abroadRadioButton.Focus();
            }
            else
            {
                domesticRadioButton.Focus();
            }
        }
          
    }
}
