/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * ChangeStyleClassTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class ChangeStyleClassTagTest extends TestCase {

    //eXgΏ
    ChangeStyleClassTag tag = null;

    /**
     * Constructor for ClassTagTest.
     * @param arg0
     */
    public ChangeStyleClassTagTest(String arg0) {
        super(arg0);
    }

    /**
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (ChangeStyleClassTag) TagUTUtil.create(ChangeStyleClassTag.class);
    }

    /**
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * req=null<br>
     * name=null<br>
     * defaultValue=null<br>
     * errorValue=null<br>
     * <br>
     * Ғl<br>
     * ߂l:int=SKIP_BODY<br>
     * o͓e=-<br>
     * <br>
     * NGXgNull̏ꍇ̃eXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoStartTag01() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(pc, "request", null);
        tag.setPageContext(pc);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    } /* testDoStartTag01 End */

    /**
     * testDoStartTag02B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * req=Not Null<br>
     * name="name"<br>
     * defaultValue="defaultValue"<br>
     * errorValue="errorValue"<br>
     * errors=Not Null(G[Ȃ)
     * <br>
     * Ғl<br>
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e="defaultValue"<br>
     * <br>
     * name,defaultValue,errorValue,errorŝׂNotNull
     * ̏ꍇ̃eXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoStartTag02() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        ServletRequest rq = pc.getRequest();

        // eXgΏۃNXϐփZbgl
        String obj1 = "name";
        String obj2 = "defaultValue";
        String obj3 = "errorValue";

        // eXgΏۂ̃NXϐփZbg
        UTUtil.setPrivateField(tag, "name", obj1);
        UTUtil.setPrivateField(tag, "defaultValue", obj2);
        UTUtil.setPrivateField(tag, "errorValue", obj3);

        // G[𐶐ANGXgɃZbgB
        ActionMessages errors = new ActionMessages();
        rq.setAttribute(Globals.ERROR_KEY, errors);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals(obj2, reader);

    } /* testDoStartTag02 End */

    /**
     * testDoStartTag03B<br>
     * <br>
     * (ُn)<br>
     * ϓ_FG<br>
     * <br>
     * ͒l<br>
     * req=Not Null<br>
     * name="name"<br>
     * defaultValue="defaultValue"<br>
     * errorValue="errorValue"<br>
     * errors=Not Null(G[Ȃ)
     * <br>
     * Ғl<br>
     * ߂l:int=JspException<br>
     * o͓e=-<br>
     * <br>
     * o͎ɁAIOExceptionꍇ̃eXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoStartTag03() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        ServletRequest rq = pc.getRequest();

        // eXgΏۃNXϐփZbgl
        String obj1 = "name";
        String obj2 = "defaultValue";
        String obj3 = "errorValue";

        // eXgΏۂ̃NXϐփZbg
        UTUtil.setPrivateField(tag, "name", obj1);
        UTUtil.setPrivateField(tag, "defaultValue", obj2);
        UTUtil.setPrivateField(tag, "errorValue", obj3);

        // G[𐶐ANGXgɃZbgB
        ActionMessages errors = new ActionMessages();
        rq.setAttribute(Globals.ERROR_KEY, errors);

        // eXgpJspWriter̐
        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);

        // Eݒ肵eXgpJspWriterPageContextɃZbg
        UTUtil.setPrivateField(pc, "jspWriter", out);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (JspTagException ex) {

            // eXgʊmF
            assertEquals("javax.servlet.jsp.JspTagException:"
                    + " java.io.IOException", ex.toString());
            return;
        }
    } /* testDoStartTag03 End */

    /**
     * testChooseClass01B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * req=Not Null<br>
     * fieldname="fieldname"<br>
     * ifNormal="ifNormal"<br>
     * ifError="ifError"<br>
     * requestErrors=Null<br>
     * sessionErrors=Null<br>
     * <br>
     * Ғl<br>
     * ߂l:String="ifNormal"<br>
     * <br>
     * NGXgƃZbV擾G[bZ[W
     * Null̏ꍇ̃eXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testChooseClass01() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        ServletRequest rq = pc.getRequest();

        String obj1 = "fieldname";
        String obj2 = "ifNormal";
        String obj3 = "ifError";

        Class[] obj4 = { HttpServletRequest.class, String.class, String.class,
                String.class };
        Object[] obj5 = { rq, obj1, obj2, obj3 };

        // eXgs
        String result = (String) UTUtil.invokePrivate(tag, "chooseClass", obj4,
                obj5);

        // eXgʊmF
        assertEquals(obj2, result);

    } /* testChooseClass01 End */

    /**
     * testChooseClass02B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * req=Not Null<br>
     * fieldname="fieldname"<br>
     * ifNormal="ifNormal"<br>
     * ifError="ifError"<br>
     * requestErrors=Not Null(G[L)<br>
     * sessionErrors=Null<br>
     * Ғl<br>
     * ߂l:String="ifError"<br>
     * <br>
     * NGXgActionMessages擾A G[bZ[WꌏȏA܂A
     * ZbV擾ActionMessagesnull̏ꍇ̃eXgP[X<br>
     * 
     * @throws Exception
     *             O<br>
     */
    public void testChooseClass02() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        HttpServletRequest rq = (HttpServletRequest) pc.getRequest();

        String obj1 = "fieldname";
        String obj2 = "ifNormal";
        String obj3 = "ifError";

        // G[𐶐ANGXgɃZbgB
        ActionMessages errors = new ActionMessages();
        errors.add(obj1, new ActionMessage("errorstagtest1"));
        rq.setAttribute(Globals.ERROR_KEY, errors);
        HttpSession session = rq.getSession(true);
        session.setAttribute(Globals.ERROR_KEY, null);

        Class[] obj4 = { HttpServletRequest.class, String.class, String.class,
                String.class };
        Object[] obj5 = { rq, obj1, obj2, obj3 };

        // eXgs
        String result = (String) UTUtil.invokePrivate(tag, "chooseClass", obj4,
                obj5);

        // eXgʊmF
        assertEquals(obj3, result);

    } /* testChooseClass02 End */

    /**
     * testChooseClass03B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * req=Not Null<br>
     * fieldname="fieldname"<br>
     * ifNormal="ifNormal"<br>
     * ifError="ifError"<br>
     * requestErrors=Null<br>
     * sessionErrors=Not Null(G[L)<br>
     * Ғl<br>
     * ߂l:String="ifError"<br>
     * <br>
     * ZbVActionMessages擾A G[bZ[WꌏȏA܂A
     * NGXg擾ActionMessagesnull̏ꍇ̃eXgP[X<br>
     * 
     * @throws Exception
     *             O<br>
     */
    public void testChooseClass03() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        HttpServletRequest rq = (HttpServletRequest) pc.getRequest();

        String obj1 = "fieldname";
        String obj2 = "ifNormal";
        String obj3 = "ifError";

        // G[𐶐ANGXgɃZbgB
        ActionMessages errors = new ActionMessages();
        errors.add(obj1, new ActionMessage("errorstagtest1"));
        rq.setAttribute(Globals.ERROR_KEY, null);
        HttpSession session = rq.getSession(true);
        session.setAttribute(Globals.ERROR_KEY, errors);

        Class[] obj4 = { HttpServletRequest.class, String.class, String.class,
                String.class };
        Object[] obj5 = { rq, obj1, obj2, obj3 };

        // eXgs
        String result = (String) UTUtil.invokePrivate(tag, "chooseClass", obj4,
                obj5);

        // eXgʊmF
        assertEquals(obj3, result);

    } /* testChooseClass03 End */

    /**
     * testChooseClass04B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * req=Not Null<br>
     * fieldname="fieldname"<br>
     * ifNormal="ifNormal"<br>
     * ifError="ifError"<br>
     * requestErrors=Not Null(G[Ȃ)<br>
     * sessionErrors=Null<br>
     * <br>
     * Ғl<br>
     * ߂l:String="ifNormal"<br>
     * <br>
     * NGXgActionMessages擾A G[bZ[WꌏȂA܂A
     * ZbV擾G[pActionMessagesnull̏ꍇ̃eXgP[X<br>
     * 
     * @throws Exception
     *             O<br>
     */
    public void testchooseClass04() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        HttpServletRequest rq = (HttpServletRequest) pc.getRequest();

        String obj1 = "fieldname";
        String obj2 = "ifNormal";
        String obj3 = "ifError";

        // G[𐶐ANGXgɃZbgB
        ActionMessages errors = new ActionMessages();
        rq.setAttribute(Globals.ERROR_KEY, errors);
        HttpSession session = rq.getSession(true);
        session.setAttribute(Globals.ERROR_KEY, null);

        Class[] obj4 = { HttpServletRequest.class, String.class, String.class,
                String.class };
        Object[] obj5 = { rq, obj1, obj2, obj3 };

        // eXgs
        String result = (String) UTUtil.invokePrivate(tag, "chooseClass", obj4,
                obj5);

        // eXgʊmF
        assertNotNull(rq.getAttribute(Globals.ERROR_KEY));
        assertEquals(obj2, result);

    } /* testChooseClass04 End */

    /**
     * testChooseClass05B<br>
     * <br>
     * (n)<br>
     * ϓ_FF<br>
     * <br>
     * ͒l<br>
     * req=Not Null<br>
     * fieldname="fieldname"<br>
     * ifNormal="ifNormal"<br>
     * ifError="ifError"<br>
     * requestErrors=Null<br>
     * sessionErrors=Not Null(G[Ȃ)<br>
     * <br>
     * Ғl<br>
     * ߂l:String="ifNormal"<br>
     * <br>
     * ZbVActionMessages擾A G[bZ[WꌏȂA܂A
     * NGXg擾G[pActionMessagesnull̏ꍇ̃eXgP[X<br>
     * 
     * @throws Exception
     *             O<br>
     */
    public void testChooseClass05() throws Exception {

        // eXgݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        HttpServletRequest rq = (HttpServletRequest) pc.getRequest();

        String obj1 = "fieldname";
        String obj2 = "ifNormal";
        String obj3 = "ifError";

        // G[𐶐ANGXgɃZbgB
        ActionMessages errors = new ActionMessages();
        rq.setAttribute(Globals.ERROR_KEY, null);
        HttpSession session = rq.getSession(true);
        session.setAttribute(Globals.ERROR_KEY, errors);

        Class[] obj4 = { HttpServletRequest.class, String.class, String.class,
                String.class };
        Object[] obj5 = { rq, obj1, obj2, obj3 };

        // eXgs
        String result = (String) UTUtil.invokePrivate(tag, "chooseClass", obj4,
                obj5);

        // eXgʊmF
        assertEquals(obj2, result);

    } /* testChooseClass05 End */

    /**
     * testRelease01B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l name=*<br>
     * defaultValue=*<br>
     * errorValue=*<br>
     * 
     * Ғl ߂l:void<br>
     * name=Null<br>
     * defaultValue=Null<br>
     * errorValue=Null<br>
     * 
     * OƂĐݒ肵elAsɊel邱ƂmF<br>
     * 
     * @throws Exception
     *             O<br>
     */
    public void testRelease01() throws Exception {

        // eXgݒ
        UTUtil.setPrivateField(tag, "name", "name");
        UTUtil.setPrivateField(tag, "defaultValue", "defaultValue");
        UTUtil.setPrivateField(tag, "errorValue", "errorValue");

        // eXgs
        tag.release();

        // eXgʊmF
        assertNull(UTUtil.getPrivateField(tag, "name"));
        assertNull(UTUtil.getPrivateField(tag, "defaultValue"));
        assertNull(UTUtil.getPrivateField(tag, "errorValue"));

    } /* testRelease1 End */

    /**
     * testSetName01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * name="name"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * name="name"<br>
     * 
     * ZbglmFeXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testSetName01() throws Exception {
        // eXgs
        tag.setName("name");

        // eXgʊmF
        assertEquals("name", UTUtil.getPrivateField(tag, "name"));

    } /* testSetName End */

    /**
     * testSetDefault01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * default="default"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * default="default"<br>
     * 
     * ZbglmFeXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testSetDefault01() throws Exception {
        // eXgs
        tag.setDefault("default");

        // eXgʊmF
        assertEquals("default", UTUtil.getPrivateField(tag, "defaultValue"));

    } /* testSetDefault End */

    /**
     * testSetError01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * error="error"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * error="error"<br>
     * 
     * ZbglmFeXgP[X<br>
     * 
     * @throws Exception O<br>
     */
    public void testSetError01() throws Exception {
        // eXgs
        tag.setError("error");

        // eXgʊmF
        assertEquals("error", UTUtil.getPrivateField(tag, "errorValue"));

    } /* testSetError01 End */

    /**
     * testDoEndTag01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     *   
     * ͒l:Ȃ<br>
     * 
     * Ғl
     * ߂l:int=EVAL_PAGE<br>
     * 
     * EVAL_PAGEԋpB<br>
     * 
     * @throws Exception O<br>
     */
    public void testDoEndTag01() throws Exception {

        int result = 0;
        // eXgs
        result = tag.doEndTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
    } /* testDoEndTag01 End */

} /* ClassTagTest Class End */
