/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * beanƂĎꂽRg[păANZXsۃNXB
 * 
 * <p>
 * ̃NX́ADIRei擾beanpăANZXsNX
 * ʃNXłB<br>
 * </p>
 * 
 * <h5>gp@</h5>
 * <p>
 * ̃NX̎NXgpɂ fvCgfBXNv^iweb.xmlj
 * Bean`t@CɈȉ̂悤ɐݒ肷B
 * ̂ƂABean`t@Cɒ`idA
 * sampleXxxControllerł&lt;bean&gt;vf
 * classɂ́AetB^w肷C^tF[XiłxxxControllerj
 * NXiłSampleXxxControllerjݒ肷B<br>
 * Xxx͊e@\񋟂FilterɂĕςB<br>
 *</p>
 * fvCgfBXNv^iweb.xmlj<pre><code>
 * &lt;filter&gt;
 *   &lt;filter-name&gt;
 *     xxxControlFilter
 *   &lt;/filter-name&gt;
 *   &lt;filter-class&gt;
 *     jp.terasoluna.sample.XxxControlFilter
 *   &lt;/filter-class&gt;
 *   &lt;init-param&gt;
 *     &lt;param-name&gt;controller&lt;/param-name&gt;
 *     &lt;param-value&gt;
 *       "sampleXxxController"
 *     &lt;/param-value&gt;
 *   &lt;/init-param&gt;
 * &lt;/filter&gt;
 *
 * &lt;filter-mapping&gt;
 *   &lt;filter-name&gt;xxxControlFilter&lt;/filter-name&gt;
 *   &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 * 
 * &lt;error-page&gt;
 *   &lt;exception-type&gt;
 *     jp.terasoluna.sample.XxxException
 *   &lt;/exception-type&gt;
 *   &lt;location&gt;/XxxError.jsp&lt;/location&gt;
 * &lt;/error-page&gt;
 * </pre></code>
 * 
 * Bean`t@C
 * <pre><code>
 * &lt;bean id=&quot;sampleXxxController&quot;
 *       class=&quot;jp.terasolunacSampleXxxController&quot; /&gt;
 * </code></pre>
 * 
 * <p>
 * ȂAtB^ɂẮABean`t@Cɒ`&lt;bean&gt;vf
 * idɃftHglpӂĂB
 * ̏ꍇ́AfvCgfBXNv^iweb.xmlj&lt;filter&gt;vf
 * &lt;init-param&gt;vfȗ邱ƂłB
 * </p>
 * 
 * @param <E> Rg[NXw肷B
 * 
 */
public abstract class AbstractControlFilter<E> implements Filter {
   
  
    /**
     * ONXB
     */
    private static Log log 
        = LogFactory.getLog(AbstractControlFilter.class);

    /**
     * tB^ݒB
     */
    protected FilterConfig config = null;
   
    /**
     * tB^T[rXJnԂɂȂۂɁAReiɂČĂяoB 
     * 
     * ReíAFilterCX^XɁAinit\bh
     * 1 񂾂ĂяoB<br>
     * FilterɃtB^Ƃs悤ɗvɂ́A
     * init \bh IĂȂ΂ȂȂB
     * init\bh ̂ꂩ̏Ԃ̏ꍇARei
     * FilterT[rXԂɂłȂB<br>
     * <ul>
     *  <li>ServletException X[B</li>
     *  <li>ReiɂĒ`ꂽԓɁAAȂB</li>
     *  <li>ݒ肳ꂽRg[̎NX݂ȂA 
     *      ܂͐ݒُ펞B</li>
     * </ul>
     * 
     * @param config FilterConfigCX^XB
     * 
     * @throws javax.servlet.ServletException ُ펞ɃX[OB
     *             
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    public void init(FilterConfig config) throws ServletException {
        this.setConfig(config);
    }
    
    /**
     * tB^ݒݒ肷B
     * 
     * @param config tB^ݒ
     */
    protected void setConfig(FilterConfig config) {
        if (log.isDebugEnabled()) {
            log.debug("setConfig() called.");
        }
        this.config = config;
    }
    
    /**
     * DIReiRg[CX^X擾ĂB
     * 
     * @return E 擾Rg[CX^X
     */
    @SuppressWarnings("unchecked")
    protected E getController() {

        if (log.isDebugEnabled()) {
            log.debug("setController() called.");
        }
        
        // WebApplicationContext擾
        WebApplicationContext wac 
            = WebApplicationContextUtils
                .getWebApplicationContext(config.getServletContext());


        // tB^̏p[^ƂBean`t@C
        // idnĂ邩
        String controllerId = config.getInitParameter("controller");
        if (controllerId == null || "".equals(controllerId)) {
            if (log.isDebugEnabled()) {
                log.debug("init parameter 'controller' isn't defined or "
                          + "empty");
            }
            controllerId = getDefaultControllerBeanId();
        }
        
        // Rg[ƂĒ`ꂽbean id\
        if (log.isDebugEnabled()) {
            log.debug("controller bean id = \"" + controllerId + "\"");
        }
        
        // DIReiRg[CX^X擾
        E controller = null;
        try {    
            controller = (E) wac.getBean(controllerId, getControllerClass());
        } catch (NoSuchBeanDefinitionException e) {
            // Bean`t@CɎw肳ĂBean`ĂȂꍇ
            log.error("not found " + controllerId + ". "
                      + "controller bean not defined in Beans definition file.",
                      e);
            throw new SystemException(e, getErrorCode());
        } catch (BeanNotOfRequiredTypeException e) {
            // Bean`t@CɎw肳ĂBeanAw肳ĂNX
            // ̎qNXł͂Ȃꍇ
            log.error("controller not implemented " 
                      + getControllerClass().toString() + ".",
                      e);
            throw new SystemException(e, getErrorCode());
        } catch (BeansException e) {
            // CX^XɎsꍇ
            log.error("bean generation failed.", e);
            throw new SystemException(e, getErrorCode());
        }
        
        return controller;
    }
    
    /**
     * ANZXsNXׂC^tF[XԂB
     * 
     * @return ̃tB^ŎgpRg[̃NX
     */
    protected abstract Class getControllerClass();
    
    /**
     * Rg[̐sG[R[hԂB
     * 
     * @return G[R[h
     */
    protected abstract String getErrorCode();

    /**
     * DIReiRg[擾ۂ̃ftHgidԂB
     * 
     * @return ftHgidl
     */
    public abstract String getDefaultControllerBeanId();

    /**
     * ANZXsB
     * 
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain tB^`F[
     * 
     * @throws IOException I/OG[
     * @throws ServletException T[ubgO
     * 
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, 
     *                                    javax.servlet.ServletResponse,
     *                                    javax.servlet.FilterChain)
     */
    public abstract void doFilter(ServletRequest req, 
                         ServletResponse res,
                         FilterChain chain) 
            throws IOException, 
                   ServletException;


    /**
     * tB^ɌĂяoB<br>
     * ̃NXł͏͍sȂȂB
     * 
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy() {
        // ɂȂ
    }
}
