/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.restart;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

/**
 * WuX^[g̃WuOpNXB<BR>
 * WũX^[gł΃WuWuOXLbvB<BR>
 * Wu̐eWȗȌꍇ͐eWupX^[g|Cgo^B
 * 
 */
public class RestartPreProcessor implements SupportProcessor {

    /**
     * X^[ge[unh̃CX^X
     */
    private JobRestartTableHandler jobRestartTableHandler = null;

    /**
     * sWuO
     */
    private SupportProcessor preProcessor = null;
    
    /**
     * Root}lW[L
     */
    private boolean parentManager = false;

    /**
     * ThrowablenhB
     */
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler(); 

    /**
     * X^[g̃WuOsB
     * 
     * @param jobContext WuReLXg
     * @param jobStatus Wu󋵁@
     */
    public void process(JobContext jobContext, JobStatus jobStatus) {
        try {
            // X^[g̏ꍇɂ́AO͋NȂ
            if (jobStatus.getJobState() == JobStatus.STATE.RESTARTED) {
                return;
            }

            preProcessor.process(jobContext, jobStatus);
            if (!jobStatus.isContinue()) {
                return;
            }
            // Partition̏ꍇ̓X^[gpRooto^
            if (parentManager) {
                jobRestartTableHandler.registerRestartPoint(jobContext,
                        jobStatus);
            }
        } catch (Throwable throwable) {
            throwableHandler.handle(jobContext, throwable, jobStatus);
        }
    }
    
    /**
     * X^[ge[unh̃CX^Xݒ肷B
     * 
     * @param jobRestartTableHandler X^[ge[unh̃CX^X
     */
    public void setJobRestartTableHandler(
            JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    /**
     * OXLbv邩]B
     * 
     * @return ]
     */
    public boolean canSkip() {
        return false;
    }

    /**
     * sWuOݒ肷B
     * 
     * @param preProcessor sWuO
     */
    public void setPreProcessor(SupportProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    /**
     *  Root}lW[Lݒ肷B
     * 
     * @param parentManager Root}lW[L
     */
    public void setParentManager(boolean parentManager) {
        this.parentManager = parentManager;
    }

    /**
     * Throwablenhݒ肷B
     * 
     * @param throwableHandler Throwablenh
     */
    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

}
