/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.restart;

import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobWorker;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.restart.JobRestartTableHandler;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestartPointUpdater
implements Workable<Chunk> {
    private JobWorker jobWorker = null;
    private JobRestartTableHandler jobRestartTableHandler = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();

    @Override
    public void work(Chunk chunk, JobStatus jobStatus) {
        try {
            this.jobWorker.work(chunk, jobStatus);
            if (jobStatus.isNormallyState()) {
                this.jobRestartTableHandler.registerRestartPoint(chunk.getJobContext(), jobStatus);
            }
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(chunk.getJobContext(), throwable, jobStatus);
        }
    }

    public void setJobRestartTableHandler(JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    public void setJobWorker(JobWorker jobWorker) {
        this.jobWorker = jobWorker;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

