﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Reflection;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Validation.Validators;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Validation.Configuration
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Validation.Configuration.IntRangeValidatorData のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Validation.Configuration.IntRangeValidatorData 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class IntRangeValidatorDataTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void Pass_DoCreateValidatorTest01()
        {
            // 定義
            IntRangeValidatorData target = new IntRangeValidatorData();
            Type targetType = null;

            // 準備
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = "検証対象項目";
            target.LowerBound = -10;
            target.UpperBound = 10;
            target.LowerBoundType = RangeBoundaryType.Inclusive;
            target.UpperBoundType = RangeBoundaryType.Inclusive;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(IntRangeValidator), "型が不正です");
            IntRangeValidator irv = result as IntRangeValidator;
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_RANGE_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, irv.MessageTemplate);
            Assert.IsNull(irv.Tag, "Tagが不正です");
            Assert.IsFalse(irv.Negated, "Negatedが不正です.");

            // 追加確認.生成したIntRangeValidatorが正しいかどうか
            ValidationResults results = result.Validate(10);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(11);
            Assert.IsFalse(results.IsValid);

            results = result.Validate(-10);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(-11);
            Assert.IsFalse(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(IntRangeValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のTypeが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void Pass_DoCreateValidatorTest02()
        {
            // 定義
            IntRangeValidatorData target = new IntRangeValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);

            // 準備
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = "検証対象項目";
            target.LowerBound = -10;
            target.UpperBound = 10;
            target.LowerBoundType = RangeBoundaryType.Inclusive;
            target.UpperBoundType = RangeBoundaryType.Inclusive;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(IntRangeValidator), "型が不正です");
            IntRangeValidator irv = result as IntRangeValidator;
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_RANGE_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, irv.MessageTemplate);
            Assert.IsNull(irv.Tag, "Tagが不正です.");
            Assert.IsFalse(irv.Negated, "Negatedが不正です.");

            // 追加確認.生成したIntRangeValidatorが正しいかどうか
            ValidationResults results = result.Validate(10);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(11);
            Assert.IsFalse(results.IsValid);

            results = result.Validate(-10);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(-11);
            Assert.IsFalse(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(IntRangeValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのMessageTemplateが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void Pass_DoCreateValidatorTest08()
        {
            // 定義
            IntRangeValidatorData target = new IntRangeValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);

            // 準備
            target.MessageTemplate = "my message template";
            target.Negated = false;
            target.Tag = "検証対象項目";
            target.LowerBound = -10;
            target.UpperBound = 10;
            target.LowerBoundType = RangeBoundaryType.Inclusive;
            target.UpperBoundType = RangeBoundaryType.Inclusive;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(IntRangeValidator), "型が不正です");
            IntRangeValidator irv = result as IntRangeValidator;
            Assert.AreEqual<string>("my message template", irv.MessageTemplate, "メッセージテンプレートが不正です.");
            Assert.IsNull(irv.Tag, "Tagが不正です.");
            Assert.IsFalse(irv.Negated, "Negatedが不正です.");

            // 追加確認.生成したIntRangeValidatorが正しいかどうか
            ValidationResults results = result.Validate(10);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(11);
            Assert.IsFalse(results.IsValid);

            results = result.Validate(-10);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(-11);
            Assert.IsFalse(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(IntRangeValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのNegatedがtrueの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void Pass_DoCreateValidatorTest09()
        {
            // 定義
            IntRangeValidatorData target = new IntRangeValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);

            // 準備
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = "検証対象項目";
            target.LowerBound = -10;
            target.UpperBound = 10;
            target.LowerBoundType = RangeBoundaryType.Inclusive;
            target.UpperBoundType = RangeBoundaryType.Inclusive;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(IntRangeValidator), "型が不正です");
            IntRangeValidator irv = result as IntRangeValidator;
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_RANGE_VALIDATOR_NEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, irv.MessageTemplate);
            Assert.IsNull(irv.Tag, "Tagが不正です.");
            Assert.IsTrue(irv.Negated, "Negatedが不正です.");

            // 追加確認.生成したIntRangeValidatorが正しいかどうか
            ValidationResults results = result.Validate(10);
            Assert.IsFalse(results.IsValid);

            results = result.Validate(11);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(-10);
            Assert.IsFalse(results.IsValid);

            results = result.Validate(-11);
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(IntRangeValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのTagがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void Pass_DoCreateValidatorTest10()
        {
            // 定義
            IntRangeValidatorData target = new IntRangeValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);

            // 準備
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = null;
            target.LowerBound = -10;
            target.UpperBound = 10;
            target.LowerBoundType = RangeBoundaryType.Inclusive;
            target.UpperBoundType = RangeBoundaryType.Inclusive;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(result);
            Assert.IsInstanceOfType(result, typeof(IntRangeValidator), "型が不正です");
            IntRangeValidator irv = result as IntRangeValidator;
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_RANGE_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, irv.MessageTemplate);
            Assert.IsNull(irv.Tag, "Tagが不正です.");
            Assert.IsFalse(irv.Negated, "Negatedが不正です.");

            // 追加確認.生成したIntRangeValidatorが正しいかどうか
            ValidationResults results = result.Validate(10);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(11);
            Assert.IsFalse(results.IsValid);

            results = result.Validate(-10);
            Assert.IsTrue(results.IsValid);

            results = result.Validate(-11);
            Assert.IsFalse(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(IntRangeValidatorData), LogLevel.INFO));
        }

        /// <summary>
        /// DoCreateValidator(Type) のテスト
        /// </summary>
        /// <remarks>
        /// プロパティのLowerBoundTypeとUpperBoundTpeが共にIgnoreの場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void Pass_DoCreateValidatorTest11()
        {
            // 定義
            IntRangeValidatorData target = new IntRangeValidatorData();
            Type targetType = typeof(HankakuKanaStringValidator);

            // 準備
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = "検証対象項目";
            target.LowerBound = -10;
            target.UpperBound = 10;
            target.LowerBoundType = RangeBoundaryType.Ignore;
            target.UpperBoundType = RangeBoundaryType.Ignore;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_IntRangeValidatorDataAccessor(target);
            try
            {
                // 実施
                Validator actual = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException));
            }
            catch (Exception e)
            {
                Assert.Fail(e.Message);
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(IntRangeValidatorData), LogLevel.INFO));
        }
    }
}
