// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.Validation;
using System.Data;

namespace TERASOLUNA.Fw.ClientUT.CoordinatorTestData
{
    /// <summary>
    /// Coordinator 単体試験用の IValidator 実装クラスです。
    /// </summary>
    /// <remarks>
    /// 正常系テスト用。
    /// 入力値検証によるエラー数 0。
    /// </remarks>
    public class Coordinator_IValidatorImpl01 : IValidator
    {
        private string _validationFilePath = null;
        private string _ruleSet = null;
        private DataSet _validateDataSet = null;
        private bool _isCalledValidate = false;

        public string ValidationFilePath
        {
            get
            {
                return _validationFilePath;
            }
            set
            {
                _validationFilePath = value;
            }
        }

        public string RuleSet
        {
            get
            {
                return _ruleSet;
            }
            set
            {
                _ruleSet = value;
            }
        }
        
        public DataSet ValidateDataSet
        {
            get { return _validateDataSet; }
        }
        
        public bool IsCalledValidate
        {
            get { return _isCalledValidate; }
        }

        public ValidationResult Validate(DataSet dataSet)
        {
            _validateDataSet = dataSet;
            _isCalledValidate = true;

            return new ValidationResult();
        }
    }
}
