// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Text;
using System.Collections.Generic;
using System.Data;
using System.IO;
using TERASOLUNA.Fw.Web.Controller;

namespace TERASOLUNA.Fw.WebUT.Controller
{

    /// <summary>
    ///MultipartUpload のStubクラスです。
    ///</summary>

    public class HttpContextWrapperStub01 : HttpContextWrapper
    {

        public Stream _requestStream = null;
        public string _contentType = null;

        ///<summary>
        /// Executeメソッド。
        ///</summary>
        ///<remarks>
        /// 必ずnullを返却する。
        ///</remarks>
        ///
        public  HttpContextWrapperStub01()
        {
        }

        public override Stream RequestStream
        {
            get
            {
                return _requestStream;
            }
        }

        public override string ContentType
        {
            get
            {
                return _contentType;
            }
        }
    }
}
