﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using System.Configuration;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.CommonUT.Configuration.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Configuration.BLogicDbInfoCollection のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Configuration.BLogicDbInfoCollection 単体テストをここに含めます
    ///</summary>

    [TestClass()]
    public class BLogicDbInfoCollectionTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///BLogicDbInfoCollection () のテスト
        ///</summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();
            Assert.IsNotNull(target);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// Add (BLogicDbInfoElement) のテスト
        /// </summary>
        /// <TestTarget>Add (BLogicDbInfoElement) </TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        [TestMethod()]
        public void TestAdd01()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();
            BLogicDbInfoElement element = new BLogicDbInfoElement();
            target.Add(element);
            Assert.IsTrue(true);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// Add (BLogicDbInfoElement) のテスト
        /// </summary>
        /// <TestTarget>Add (BLogicDbInfoElement) </TestTarget>
        /// <TestCondition>引数にnullを指定すること</TestCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        [TestMethod()]
        public void TestAdd02()
        {
            try
            {
                BLogicDbInfoCollection target = new BLogicDbInfoCollection();
                target.Add(null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("element", e.ParamName);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateNewElement () のテスト
        /// </summary>
        /// <TestTarget>CreateNewElement () </TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>BLogicDbInfoElement型インスタンスが返却されること</TestAssertion>
        [TestMethod()]
        public void TestCreateNewElement01()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor(target);
            ConfigurationElement ce = accessor.CreateNewElement();
            Assert.IsInstanceOfType(ce, typeof(BLogicDbInfoElement));

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// GetElementKey (ConfigurationElement) のテスト
        /// </summary>
        /// <TestTarget>GetElementKey (ConfigurationElement)</TestTarget>
        /// <TestCondition>BLogicDbInfoElement型インスタンスを引数に指定すること</TestCondition>
        /// <TestAssertion>引数に指定したインスタンスのNameプロパティが返却されること</TestAssertion>
        [TestMethod()]
        public void TestGetElementKey01()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor(target);
            BLogicDbInfoElement be = new BLogicDbInfoElement("testName");
            object obj = accessor.GetElementKey(be);
            Assert.AreEqual("testName", obj.ToString());

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// GetElementKey (ConfigurationElement) のテスト
        /// </summary>
        /// <TestTarget>GetElementKey (ConfigurationElement)</TestTarget>
        /// <TestCondition>引数にnullを指定すること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestGetElementKey02()
        {
            try
            {
                BLogicDbInfoCollection target = new BLogicDbInfoCollection();
                TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor(target);
                object obj = accessor.GetElementKey(null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (Exception ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(ArgumentNullException));
                Assert.AreEqual("element", (ex.InnerException as ArgumentNullException).ParamName);
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// GetElementKey (ConfigurationElement) のテスト
        /// </summary>
        /// <TestTarget>GetElementKey (ConfigurationElement)</TestTarget>
        /// <TestCondition>BLogicDbInfoElement型でないインスタンスを引数に指定すること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestGetElementKey03()
        {
            BLogicCollection_ConfigurationElementStub se = null;
            try
            {
                BLogicDbInfoCollection target = new BLogicDbInfoCollection();
                TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor(target);
                se = new BLogicCollection_ConfigurationElementStub();
                object obj = accessor.GetElementKey(se);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (Exception e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CAST", se.GetType().FullName, typeof(BLogicDbInfoElement).FullName), e.InnerException.Message);
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// CollectionType のテスト
        /// </summary>
        /// <TestTarget>CollectionType()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion><see cref="System.Configuration.ConfigurationElementCollectionType.BasicMap" />が返却されること</TestAssertion>
        [TestMethod()]
        public void TestCollectionType01()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();
            Assert.AreEqual(ConfigurationElementCollectionType.BasicMap, target.CollectionType);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[int index] のテスト
        /// </summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>indexに指定した<see cref="TERASOLUNA.Common.Configuration.BLogicDbInfoElement"/>が返却されること</TestAssertion>
        [TestMethod()]
        public void TestItem01()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();

            BLogicDbInfoElement val1 = new BLogicDbInfoElement("Biz1");
            BLogicDbInfoElement val2 = new BLogicDbInfoElement("Biz2");
            target.Add(val1);
            target.Add(val2);

            Assert.AreEqual(val1, target[0]);
            Assert.AreEqual(val2, target[1]);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[string name] のテスト
        /// </summary>
        /// <TestTarget>[string name]</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>nameに指定した<see cref="TERASOLUNA.Common.Configuration.BLogicDbInfoElement"/>が返却されること</TestAssertion>
        [TestMethod()]
        public void TestItem02()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();

            BLogicDbInfoElement val1 = new BLogicDbInfoElement("Biz1");
            BLogicDbInfoElement val2 = new BLogicDbInfoElement("Biz2");
            target.Add(val1);
            target.Add(val2);

            Assert.AreEqual(val1, target["Biz1"]);
            Assert.AreEqual(val2, target["Biz2"]);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[int index] のテスト
        /// </summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition>indexに-1を指定すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestItem03()
        {
            try
            {
                BLogicDbInfoCollection target = new BLogicDbInfoCollection();

                BLogicDbInfoElement val1 = new BLogicDbInfoElement("Biz1");
                target.Add(val1);
                BLogicDbInfoElement be = target[-1];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException)
            {
                // 成功
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[int index] のテスト
        /// </summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition>indexに配列要素数+1を指定すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestItem04()
        {
            try
            {
                BLogicDbInfoCollection target = new BLogicDbInfoCollection();

                BLogicDbInfoElement val1 = new BLogicDbInfoElement("Biz1");
                BLogicDbInfoElement val2 = new BLogicDbInfoElement("Biz2");
                BLogicDbInfoElement val3 = new BLogicDbInfoElement("Biz3");
                target.Add(val1);
                target.Add(val2);
                target.Add(val3);
                BLogicDbInfoElement be = target[3];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException)
            {
                // 成功
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[string name] のテスト
        /// </summary>
        /// <TestTarget>[string name]</TestTarget>
        /// <TestCondition>空文字を指定すること</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestItem05()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();

            BLogicDbInfoElement val1 = new BLogicDbInfoElement("Biz1");
            BLogicDbInfoElement val2 = new BLogicDbInfoElement("Biz2");
            target.Add(val1);
            target.Add(val2);

            BLogicDbInfoElement be = target[""];
            Assert.IsNull(be);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[string name] のテスト
        /// </summary>
        /// <TestTarget>[string name]</TestTarget>
        /// <TestCondition>nullを指定すること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestItem06()
        {
            try
            {
                BLogicDbInfoCollection target = new BLogicDbInfoCollection();

                BLogicDbInfoElement val1 = new BLogicDbInfoElement("Biz1");
                BLogicDbInfoElement val2 = new BLogicDbInfoElement("Biz2");
                target.Add(val1);
                target.Add(val2);

                BLogicDbInfoElement be = target[null];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (NullReferenceException)
            {
                // 成功
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[string name] のテスト
        /// </summary>
        /// <TestTarget>[string name]</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestItem07()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();

            BLogicDbInfoElement val1 = new BLogicDbInfoElement("Biz1");
            BLogicDbInfoElement val2 = new BLogicDbInfoElement("Biz2");
            target.Add(val1);
            target.Add(val2);

            BLogicDbInfoElement be = target["invalid"];
            Assert.IsNull(be);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// Count のテスト
        /// </summary>
        /// <TestTarget>Count</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>保持している要素数が返却されること</TestAssertion>
        [TestMethod()]
        public void TestCount01()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();

            BLogicDbInfoElement val1 = new BLogicDbInfoElement("Biz1");
            BLogicDbInfoElement val2 = new BLogicDbInfoElement("Biz2");
            BLogicDbInfoElement val3 = new BLogicDbInfoElement("Biz3");
            target.Add(val1);
            target.Add(val2);
            target.Add(val3);

            Assert.AreEqual(3, target.Count);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// Count のテスト
        /// </summary>
        /// <TestTarget>Count</TestTarget>
        /// <TestCondition>Addで要素を追加しないこと</TestCondition>
        /// <TestAssertion>保持している要素数(0)が返却されること</TestAssertion>
        [TestMethod()]
        public void TestCount02()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();

            Assert.AreEqual(0, target.Count);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// IsReadOnly () のテスト
        /// </summary>
        /// <TestTarget>IsReadOnly()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>falseが返却されること</TestAssertion>
        [TestMethod()]
        public void TestIsReadOnly01()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();
            Assert.IsFalse(target.IsReadOnly());

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }

        /// <summary>
        /// ElementName のテスト
        /// </summary>
        /// <TestTarget>ElementName</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>"blogic"が返却されること</TestAssertion>
        [TestMethod()]
        public void TestIsElementName01()
        {
            BLogicDbInfoCollection target = new BLogicDbInfoCollection();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Configuration_BLogic_BLogicDbInfoCollectionAccessor(target);
            Assert.AreEqual("dbInfo", accessor.ElementName);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicDbInfoCollection), LogLevel.INFO));
        }
    }
}
