// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Globalization;
using System.Resources;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Common
{
    /// <summary>
    /// AZuɊi[̃bZ[W\[X𗘗p邽߂̃[eBeBNXłB
    /// </summary>
    public class MessageManager
    {
        /// <summary>
        /// AvP[V\t@C烊\[X̌^擾ۂ̃L[̃vtBbNXłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "MessageResources." łB
        /// </remarks>
        protected static readonly string RESOURCE_NAME_PREFIX = "MessageResource.";

        /// <summary>
        /// AvP[V\t@C <see cref="MessageManager"/> NX̌^擾ۂ̃L[łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "MessageManagerTypeName" łB
        /// </remarks>
        protected static readonly string MESSAGE_MANAGER_TYPE_NAME = "MessageManagerTypeName";

        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(MessageManager));

        /// <summary>
        /// bNp̃IuWFNgłB
        /// </summary>
        /// <remarks>
        /// {NX̃bNIuWFNgB
        /// </remarks>
        private static object _syncRoot = new Object();

        /// <summary>
        /// <see cref="MessageManager"/> ̃CX^X̃LbVłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private static volatile MessageManager _instance = null;

        /// <summary>
        /// bZ[WɓKpJ`łB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA <seealso cref="CultureInfo.CurrentCulture"/> łB
        /// </remarks>
        private CultureInfo _resourceCulture = CultureInfo.CurrentCulture;

        /// <summary>
        /// <see cref="ResourceManager"/> ̃XgłB
        /// </summary>
        private IList<ResourceManager> _resourceManagerList = new List<ResourceManager>();

        /// <summary>
        /// bZ[W擾ɗpJ`擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// J`B
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA <seealso cref="CultureInfo.CurrentCulture"/> łB
        /// </remarks>
        public static CultureInfo Culture
        {
            get
            {
                return Instance.ResourceCulture;
            }
            set
            {
                Instance.ResourceCulture = value;
            }
        }

        /// <summary>
        /// ŕێ <see cref="MessageManager"/> NX̃CX^X̃LbV擾܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̃vpeBɏ߂ăANZXƂA <see cref="MessageManager"/> ̓AvP[V
        /// \t@C <seealso cref="MESSAGE_MANAGER_TYPE_NAME"/> L[ƂGgTA݂ꍇA
        /// 擾l^Ƃ <see cref="MessageManager"/> ܂͂̃TuNX̃CX^X
        /// ݂܂BꍇÃCX^XLbVAԂ܂BAvP[V
        /// \t@CɊYGgȂꍇA<see cref="MessageManager"/> NX̃CX^X
        /// 𐶐ALbVĕԂ܂B̓̓XbhZ[tłB</para>
        /// </remarks>
        /// <exception cref="InvalidOperationException">
        /// AvP[V\t@C <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂ
        /// L[Gg݂܂B
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂL[Ƃ\t@C appSettings vf value l͋󕶎łB
        /// </item>
        /// <item>
        /// <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂL[Ƃ\t@C appSettings vf value ľ^擾ł܂B
        /// </item>
        /// <item>
        /// <see cref="MessageManager"/> hNX̃CX^X𐶐ł܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// AvP[Vݒf[^i[ NameValueCollection IuWFNg擾ł܂B
        /// </exception>
        protected static MessageManager Instance
        {
            get
            {
                if (_instance == null)
                {
                    lock (_syncRoot)
                    {
                        if (_instance == null)
                        {
                            _instance = ClassUtil.CreateInstanceFromAppSettings<MessageManager>(MESSAGE_MANAGER_TYPE_NAME, typeof(MessageManager));
                            _instance.Init();
                        }
                    }
                }
                return _instance;
            }
        }


        /// <summary>
        /// CX^Xێ郊\[X}l[W̃Xg擾܂B
        /// </summary>
        protected IList<ResourceManager> ResourceManagerList
        {
            get
            {
                return _resourceManagerList;
            }
        }

        /// <summary>
        /// bZ[W擾ɗpJ`擾܂͐ݒ肵܂B
        /// </summary>
        protected CultureInfo ResourceCulture
        {
            get
            {
                return _resourceCulture;
            }

            set
            {
                _resourceCulture = value;
            }
        }
        /// <summary>
        /// <see cref="MessageManager"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public MessageManager()
        {
        }

        /// <summary>
        /// w肵bZ[W ID 𗘗pă\[X當擾܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// ŕێ\[X^̃RNVAw肵L[ɍv郁bZ[W
        /// 擾܂BpJ` <seealso cref="MessageManager.ResourceCulture"/>
        /// Ŏw肵܂B
        /// </para>
        /// <para>
        /// 擾bZ[Wɏ񂪎w肳ĂꍇA
        ///  <paramref name="args"/> ɒu^邱ƂŃtH[}bgs
        /// Ƃł܂B̂ƂA擾bZ[WɎw肳ꂽ
        /// u̐vȂꍇAOX[܂B
        /// </para>
        /// </remarks>
        /// <param name="messageId">\[X烁bZ[W擾ۂɗp ID B</param>
        /// <param name="args">v[Xz_ɓKpϒB</param>
        /// <returns>\[X擾ꂽbZ[WB</returns>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="messageId"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="args"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="messageId"/> 󕶎łB
        /// </exception>
        /// <exception cref="InvalidOperationException">
        /// AvP[V\t@C <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂ
        /// L[Gg݂܂B
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂL[Ƃ\t@C appSettings vf value l͋󕶎łB
        /// </item>
        /// <item>
        /// <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂL[Ƃ\t@C appSettings vf value ľ^擾ł܂B
        /// </item>
        /// <item>
        /// <see cref="MessageManager"/> hNX̃CX^X𐶐ł܂B
        /// </item>
        /// <item>
        /// \t@C <seealso cref="RESOURCE_NAME_PREFIX"/> L[ƂĎ擾valuel琶ł郊\[X^ŁA
        /// gpł郊\[X̃Zbg邱Ƃł܂B
        /// </item>
        /// <item>
        /// \t@C <seealso cref="RESOURCE_NAME_PREFIX"/> L[ƂĎ擾valuel琶ł郊\[X^ɁA
        /// ȊÕ\[XۑĂ܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@CsłB
        /// </exception>
        /// <exception cref="FormatException">
        /// format łB܂͏ݒ肷 0 菬A
        /// ݒ肷w肳ꂽIuWFNg̐ȏłB 
        /// </exception>
        public static string GetMessage(string messageId, params object[] args)
        {
            if (messageId == null)
            {
                ArgumentNullException exception = new ArgumentNullException("messageId");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "messageId"), exception);
                }
                throw exception;
            }

            if (messageId.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "messageId");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            if (args == null)
            {
                ArgumentNullException exception = new ArgumentNullException("args");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "args"), exception);
                }
                throw exception;
            }

            return Instance.GetString(messageId, args);
        }

        /// <summary>
        /// <see cref="MessageManager"/> CX^X܂B
        /// </summary>
        /// <remarks>
        /// <para>AvP[V\t@CA<seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂ
        ///  AppSettings Gg擾A<see cref="ResourceManager"/>̃Xg܂B</para>
        /// <para><seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂGgɂ́AbZ[Wi[
        /// \[X̌^AZuCŋLqKvL܂B</para>
        /// <para>Xg̓L[Ń\[g܂BXg̕т́AbZ[W̌ɉe܂B</para>
        /// </remarks>
        /// <exception cref="InvalidOperationException">
        /// AvP[V\t@C <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂ
        /// L[Gg݂܂B
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂL[Ƃ\t@C appSettings vf value 
        /// l͋󕶎łB
        /// </item>
        /// <item>
        /// <seealso cref="RESOURCE_NAME_PREFIX"/> vtBbNXƂL[Ƃ\t@C appSettings vf value 
        /// ľ^擾ł܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@CsłB
        /// </exception>
        protected virtual void Init()
        {
            // AvP[V\t@CA
            // AZuA^擾
            string[] allKeys = ConfigurationManager.AppSettings.AllKeys;

            List<string> keys = new List<string>();
            foreach (string key in allKeys)
            {
                if (key != null && key.StartsWith(RESOURCE_NAME_PREFIX))
                {
                    keys.Add(key);
                }
            }

            if (keys.Count == 0)
            {
                InvalidOperationException exception = new InvalidOperationException(Properties.Resources.E_MESSAGE_RESOURCE_NOT_DEFINED);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            keys.Sort(); // Ń\[g

            for (int i = 0; i < keys.Count; i++)
            {
                string typeName = ConfigurationManager.AppSettings[keys[i]];
                if (string.IsNullOrEmpty(typeName))
                {
                    string message = string.Format(Properties.Resources.E_EMPTY_TYPE_NAME, keys[i]);
                    TerasolunaException exception = new TerasolunaException(message);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }
                Type t = ClassUtil.GetType(typeName);
                ICollection collection = (ICollection)_resourceManagerList;
                lock (collection.SyncRoot)
                {
                    _resourceManagerList.Add(new ResourceManager(t));
                }
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_LOAD_RESOURCE_TYPE, t.FullName));
                }
            }
        }

        /// <summary>
        /// w肵bZ[W ID 𗘗pă\[X當擾܂B
        /// </summary>
        /// <param name="messageId">\[X烁bZ[W擾ۂɗp ID B</param>
        /// <param name="args">v[Xz_ɓKpϒB</param>
        /// <returns>\[X擾ꂽbZ[WB</returns>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="messageId"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="args"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@C <seealso cref="RESOURCE_NAME_PREFIX"/> L[ƂĎ擾valuel琶ł郊\[X^ŁA
        /// gpł郊\[X̃Zbg邱Ƃł܂B
        /// </item>
        /// <item>
        /// \t@C <seealso cref="RESOURCE_NAME_PREFIX"/> L[ƂĎ擾valuel琶ł郊\[X^ɁA
        /// ȊÕ\[XۑĂ܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="FormatException">
        /// format łB܂͏ݒ肷 0 菬A
        /// ݒ肷w肳ꂽIuWFNg̐ȏłB 
        /// </exception>
        protected virtual string GetString(string messageId, params object[] args)
        {
            CultureInfo culInfo = ResourceCulture; // [vŕςȂ悤ɃLbV
            string result = null;

            foreach (ResourceManager man in ResourceManagerList)
            {
                try
                {
                    result = man.GetString(messageId, culInfo);
                }
                catch (InvalidOperationException ex)
                {
                    string message = string.Format(Properties.Resources.E_MESSAGE_NOT_STRING, messageId, culInfo);
                    TerasolunaException exception = new TerasolunaException(message, ex);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }
                catch (MissingManifestResourceException ex)
                {
                    string message = string.Format(Properties.Resources.E_MESSAGE_RESOURCE_NOT_FOUND, man.BaseName);
                    TerasolunaException exception = new TerasolunaException(message, ex);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }
                if (result != null)
                {
                    break;
                }
            }

            if (!string.IsNullOrEmpty(result) && args.Length != 0)
            {
                result = string.Format(culInfo, result, args);
            }

            return result;
        }
    }
}
