// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Client;
using System.Net;
using System.Configuration;
using System.IO;

namespace TERASOLUNA.Fw.ClientUT.Communication
{
    public class CommunicatorBase_IHttpSenderStub03 : IHttpSender<DataSet>
    {
       
        public HttpWebRequest _request = null;

        public DataSet _paramData = null;

        public IDictionary<string, string> _headerCollection = null;

        public IProgressChangeReporter _reporter = null;

        public CommunicatorBase_IHttpSenderStub03()
        {
        }

        public void Send(HttpWebRequest request, DataSet paramData, IDictionary<string, string> headerCollection, IProgressChangeReporter reporter)
        {
            _request = request;
            _paramData = paramData;
            _headerCollection = headerCollection;
            _reporter = reporter;

            // キャンセルの準備
            request.Method = "POST";
            request.Abort();

            // リクエストの実行(キャンセルしているため必ず例外発生
            request.GetRequestStream();
                      
        }
    }
}