// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Reflection;
using TERASOLUNA.Fw.Web;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Web.HttpModule;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.WebUT.HttpModules
{
    /// <summary>
    /// TERASOLUNA.Fw.Web.HttpModule.ExceptionTransitionListenerImpl のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Web.HttpModule.ExceptionTransitionListenerImpl 単体テストをここに含めます
    /// </summary>

    [TestClass()]
    public class ExceptionTransitionListenerImplTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// GetRedirectUrl (System.Exception) のテスト
        /// </summary>
        /// <TestTarget>GetRedirectUrl (System.Exception)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に設定ファイルに存在する例外が指定されていること
        /// </TestCondition>
        /// <TestAssertion>引数に対応する遷移先URLが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        public void TestGetRedirectUrl01()
        {
            System.Exception ex = new ApplicationException();
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();
            TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            string expected = "/Error3.aspx";
            string actual;

            actual = accessor.GetRedirectUrl(ex);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }

        /// <summary>
        /// GetRedirectUrl (System.Exception) のテスト
        /// </summary>
        /// <TestTarget>GetRedirectUrl (System.Exception)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に設定ファイルに存在しない例外が指定されていること
        /// </TestCondition>
        /// <TestAssertion>空文字列が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        public void TestGetRedirectUrl02()
        {
            System.Exception ex = new InvalidOperationException();
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();
            TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            string expected = "";
            string actual;

            actual = accessor.GetRedirectUrl(ex);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }

        /// <summary>
        /// GetRedirectUrl (System.Exception) のテスト
        /// </summary>
        /// <TestTarget>GetRedirectUrl (System.Exception)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に設定ファイルに存在する例外が指定されていること
        /// かつ、引数の例外のベースクラスが設定ファイルに存在すること
        /// </TestCondition>
        /// <TestAssertion>引数に対応する遷移先URLが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        public void TestGetRedirectUrl03()
        {
            System.Exception ex = new ArgumentNullException();
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();
            TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            string expected = "/Error2.aspx";
            string actual;

            actual = accessor.GetRedirectUrl(ex);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }

        /// <summary>
        /// GetRedirectUrl (System.Exception) のテスト
        /// </summary>
        /// <TestTarget>GetRedirectUrl (System.Exception)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に設定ファイルに存在する例外が指定されていること
        /// かつ、引数の例外のサブクラスが設定ファイルに存在すること
        /// </TestCondition>
        /// <TestAssertion>引数に対応する遷移先URLが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        public void TestGetRedirectUrl04()
        {
            System.Exception ex = new ArgumentException();
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();
            TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            string expected = "/Error1.aspx";
            string actual;

            actual = accessor.GetRedirectUrl(ex);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }

        /// <summary>
        /// GetRedirectUrl (System.Exception) のテスト
        /// </summary>
        /// <TestTarget>GetRedirectUrl (System.Exception)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数に設定ファイルに存在する例外のサブクラスが指定されていること
        /// </TestCondition>
        /// <TestAssertion>引数に対応する遷移先URLが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        public void TestGetRedirectUrl05()
        {
            System.Exception ex = new ArgumentOutOfRangeException();
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();
            TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            string expected = "/Error1.aspx";
            string actual;

            actual = accessor.GetRedirectUrl(ex);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }

        /// <summary>
        /// GetRedirectUrl (System.Exception) のテスト
        /// </summary>
        /// <TestTarget>GetRedirectUrl (System.Exception)</TestTarget>
        /// <TestCondition>
        /// 構成ファイル、外部設定ファイルが正常なこと
        /// 引数にnullが指定されていること
        /// </TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        public void TestGetRedirectUrl06()
        {
            System.Exception ex = null;
            string actual;
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();
            TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            try
            {
                actual = accessor.GetRedirectUrl(ex);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException exp)
            {
                //ArgumentNullException exception = exp.InnerException as ArgumentNullException;
                Assert.AreEqual("ex", exp.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ExceptionTransitionListenerImpl), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "ex"));
        }

        /// <summary>
        ///ExceptionLoggingEnabled のテスト
        ///</summary>
        /// <TestTarget>ExceptionLoggingEnabled</TestTarget>
        /// <TestCondition>
        /// falseを設定
        /// </TestCondition>
        /// <TestAssertion>正しい値が取得できること</TestAssertion>
        [TestMethod()]
        public void ExceptionLoggingEnabledTest01()
        {
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();

            bool val = false;

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            accessor.ExceptionLoggingEnabled = val;


            Assert.AreEqual(val, accessor.ExceptionLoggingEnabled);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }

        /// <summary>
        ///ExceptionLoggingEnabled のテスト
        ///</summary>
        /// <TestTarget>ExceptionLoggingEnabled</TestTarget>
        /// <TestCondition>
        /// trueを設定
        /// </TestCondition>
        /// <TestAssertion>正しい値が取得できること</TestAssertion>
        [TestMethod()]
        public void ExceptionLoggingEnabledTest02()
        {
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();

            bool val = true;

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            accessor.ExceptionLoggingEnabled = val;


            Assert.AreEqual(val, accessor.ExceptionLoggingEnabled);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }

        /// <summary>
        ///ExceptionTransitionEnabled のテスト
        ///</summary>
        /// <TestTarget>ExceptionTransitionEnabled</TestTarget>
        /// <TestCondition>
        /// falseを設定
        /// </TestCondition>
        /// <TestAssertion>正しい値が取得できること</TestAssertion>
        [TestMethod()]
        public void ExceptionTransitionEnabledTest01()
        {
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();

            bool val = false;

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            accessor.ExceptionTransitionEnabled = val;


            Assert.AreEqual(val, accessor.ExceptionTransitionEnabled);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }

        /// <summary>
        ///ExceptionTransitionEnabled のテスト
        ///</summary>
        /// <TestTarget>ExceptionTransitionEnabled</TestTarget>
        /// <TestCondition>
        /// trueを設定
        /// </TestCondition>
        /// <TestAssertion>正しい値が取得できること</TestAssertion>
        [TestMethod()]
        public void ExceptionTransitionEnabledTest02()
        {
            ExceptionTransitionListenerImpl target = new ExceptionTransitionListenerImpl();

            bool val = true;

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor accessor = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_HttpModule_ExceptionTransitionListenerImplAccessor(target);

            accessor.ExceptionTransitionEnabled = val;


            Assert.AreEqual(val, accessor.ExceptionTransitionEnabled);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionListenerImpl), LogLevel.INFO));
        }
    }
}
