// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.ClientUT.CoordinatorTestData
{
    public class Coordinator_IErrorHandlerImpl01 : IErrorHandler
    {
        // HandleError() の呼び出し確認用フィールド
        private string _handleErrorResultString = null;
        private IList<MessageInfo> _handleErrorMessages = null;
        private object _handleErrorView = null;
        private bool _isCalledHandleError = false;

        // ClearError() の呼び出し確認用フィールド
        private object _clearErrorView = null;
        private bool _isCalledClearError = false;

        public string HandleErrorResultString
        {
            get { return _handleErrorResultString; }
        }
        
        public IList<MessageInfo> HandleErrorMessages
        {
            get { return _handleErrorMessages; }
        }
        
        public object HandleErrorView
        {
            get { return _handleErrorView; }
        }

        public bool IsCalledHandleError
        {
            get { return _isCalledHandleError; }
        }
       
        public object ClearErrorView
        {
            get { return _clearErrorView; } 
        }
      
        public bool IsCalledClearError
        {
            get { return _isCalledClearError; }
        }

        public void HandleError(string resultString, IList<MessageInfo> messages, object view)
        {
            _handleErrorResultString = resultString;
            _handleErrorMessages = messages;
            _handleErrorView = view;
            _isCalledHandleError = true;
        }

        public void ClearError(object view)
        {
            _clearErrorView = view;
            _isCalledClearError = true;
        }
    }
}
