// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client;

namespace TERASOLUNA.Fw.ClientUT
{
    /// <summary>
    /// スタブ7: ExecuteAsyncCancel 異常系
    /// </summary>
    public class EventController_CoordinatorStub07 : Coordinator
    {
        private static bool _called = false;

        public EventController_CoordinatorStub07()
        {
            TERASOLUNA_Fw_Client_CoordinatorAccessor accessor = new TERASOLUNA_Fw_Client_CoordinatorAccessor(this);
            accessor._isBusy = false;
            _called = false;
        }

        public static bool IsCalled
        {
            get
            {
                return _called;
            }
        }

        public override void ExecuteAsync(EventController EventController)
        {
        }

        public override void ExecuteAsyncCancel()
        {
            _called = true;
        }
    }
}
