﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.Configuration.Conversion;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.ClientUT.Configuration.Conversion
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Configuration.Conversion.ConvertElement のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Configuration.Conversion.ConvertElement 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ConvertElementTest
    {
        private TestContext testContextInstance;

        ///<summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        ///<summary>
        /// ConvertElement () のテスト
        ///</summary>
        ///<remarks>
        /// 引数無しのコンストラクタを呼び出した場合、インスタンスが返却されることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            //実行
            ConvertElement target = new ConvertElement();

            //検証
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConvertElement), LogLevel.INFO));
        }

        ///<summary>
        /// ConvertElement (string, ParamElement, ResultElement) のテスト
        ///</summary>
        ///<remarks>
        /// 文字列、ParamElement、ResultElementを引数とするコンストラクタを呼び出した場合、
        /// 各引数が正常に設定されていることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorStringParamElementResultElementTest01()
        {
            //準備
            string expectedId = "id001";
            ParamElement expectedParam = new ParamElement();
            ResultElement expectedResult = new ResultElement();

            //実行
            ConvertElement target = new ConvertElement(expectedId, expectedParam, expectedResult);

            //検証
            Assert.AreEqual(expectedId, target.Id);
            Assert.AreSame(expectedParam, target.Param);
            Assert.AreSame(expectedResult, target.Result);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConvertElement), LogLevel.INFO));

        }

        ///<summary>
        /// Id のテスト
        ///</summary>
        ///<remarks>
        /// コンストラクタで文字列を設定し、その値を取得した場合、
        /// 一致することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void IdTest01()
        {
            //準備
            string expectedId = "id001";
            ParamElement expectedParam = new ParamElement();
            ResultElement expectedResult = new ResultElement();
            ConvertElement target = new ConvertElement(expectedId, expectedParam, expectedResult);

            //実行
            string actual = target.Id;

            //検証
            Assert.AreEqual(expectedId, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConvertElement), LogLevel.INFO));

        }

        ///<summary>
        /// Param のテスト
        ///</summary>
        ///<remarks>
        /// コンストラクタでParamElementを設定し、その値を取得した場合、
        /// 一致することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ParamTest01()
        {
            //準備
            string expectedId = "id001";
            ParamElement expectedParam = new ParamElement();
            ResultElement expectedResult = new ResultElement();
            ConvertElement target = new ConvertElement(expectedId, expectedParam, expectedResult);

            //実行
            ParamElement actual = target.Param;

            //検証
            Assert.AreSame(expectedParam, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConvertElement), LogLevel.INFO));

        }

        ///<summary>
        /// Result のテスト
        ///</summary>
        ///<remarks>
        /// コンストラクタでResultElementを設定し、その値を取得した場合、
        /// 一致することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ResultTest01()
        {
            //準備
            string expectedId = "id001";
            ParamElement expectedParam = new ParamElement();
            ResultElement expectedResult = new ResultElement();
            ConvertElement target = new ConvertElement(expectedId, expectedParam, expectedResult);

            //実行
            ResultElement actual = target.Result;

            //検証
            Assert.AreSame(expectedResult, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConvertElement), LogLevel.INFO));
        }
    }
}
