// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Data;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.BLogic
{
    /// <summary>
    /// }`p[gf[^̑MAXML̎MsrWlXWbNNXłB
    /// </summary>
    /// <remarks>
    /// <see cref="MultipartUploadCommunicator{TResult}"/> gpăT[oƒʐMs܂B
    /// </remarks>
    /// <typeparam name="TResult">
    /// MXMLf[^ <paramref name="TResult"/> ^̌^tf[^Zbgɓǂݍ݂܂B
    /// </typeparam>
    public class MultipartUploadBLogic<TResult> : CommunicateBLogicBase<IList<MultipartElement>>
        where TResult : DataSet , new()
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private ILog _log = LogFactory.GetLogger(typeof(MultipartUploadBLogic<TResult>));

        /// <summary>
        /// }`p[gMseLXgێĂ <see cref="DataSet"/> ̃e[ułB
        /// </summary>
        /// <remarks>̒萔̒l "Text" łB</remarks>
        public static readonly string TEXT_TABLE_NAME = "Text";

        /// <summary>
        /// }`p[gMst@CێĂ <see cref="DataSet"/> ̃e[ułB
        /// </summary>
        /// <remarks>̒萔̒l "File" łB</remarks>
        public static readonly string FILE_TABLE_NAME = "File";

        /// <summary>
        /// }`p[gMsGgvfێĂ <see cref="DataTable"/> ̃JłB
        /// </summary>
        /// <remarks>̒萔̒l "Name" łB</remarks>
        public static readonly string ELEMENT_NAME = "Name";

        /// <summary>
        /// }`p[gMst@CpXێĂ <see cref="DataTable"/> ̃JłB
        /// </summary>
        /// <remarks>̒萔̒l "FilePath" łB</remarks>
        public static readonly string FILE_PATH = "FilePath";

        /// <summary>
        /// }`p[gMseLXg̒lێĂ <see cref="DataTable"/> ̃JłB
        /// </summary>
        /// <remarks>̒萔̒l "Value" łB</remarks>
        public static readonly string TEXT_VALUE = "Value";

        /// <summary>
        /// <see cref="MultipartUploadBLogic{TResult}"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public MultipartUploadBLogic()
        {
        }

        /// <summary>
        /// }`p[gf[^̑MAXMLf[^̎Ms <see cref="ICommunicator{IList}"/> 𐶐܂B
        /// </summary>
        /// <remarks>
        /// ł <see cref="MultipartUploadCommunicator{TResult}"/> 𐶐܂B
        /// </remarks>
        /// <returns>
        /// }`p[gf[^̑MAXMLf[^̎Ms <see cref="ICommunicator{IList}"/>B
        /// </returns>
        protected override ICommunicator<IList<MultipartElement>> CreateCommunicator()
        {
            return new MultipartUploadCommunicator<TResult>();
        }

        /// <summary>
        /// }`p[gʐMs܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="communicateBlogicParam"/> Ɋi[ꂽf[^ZbgA
        /// }`p[g(}`p[g̗vfAt@CpXAeLXgl)擾܂B
        /// ݒ肵}`p[g񂩂 <see cref="MultipartElement"/> 쐬A
        /// }`p[gM܂BMXMLʐMōs܂B
        /// </para>
        /// <para>
        /// ȉ̕\ɁA<paramref name="communicateBlogicParam"/> Ɋi[ꂽf[^Zbg
        /// pӂĂׂe[uƃJ܂B
        /// </para>
        /// <table border="4" align="center">
        /// <caption>y<paramref name="paramData"/> ɕKvȃe[uƃJz</caption>
        /// <tr bgcolor="#cccccc">
        /// <th>e[u</th>
        /// <th>J</th>
        /// <th>ڍ</th>
        /// </tr>
        /// <tr align="center">
        /// <td rowspan="2">Text</td>
        /// <td>Name</td>
        /// <td>eLXgl̗vf</td>
        /// </tr>
        /// <tr align="center">
        /// <td>Value</td>
        /// <td>eLXgl</td>
        /// </tr>
        /// <tr align="center">
        /// <td rowspan="2">File</td>
        /// <td>Name</td>
        /// <td>t@C̗vf</td>
        /// </tr>
        /// <tr align="center">
        /// <td>FilePath</td>
        /// <td>t@C̃t@CpX</td>
        /// </tr>
        /// </table>
        /// </remarks>
        /// <param name="communicateBlogicParam">Mf[^i[ <see cref="BLogicParam"/>B</param>
        /// <param name="requestHeaders">
        /// NGXg̃wb_\閼Oƒl̃yAi[Ă <see cref="IDictionary{String, String}"/>B
        /// </param>
        /// <returns>
        /// ʐMʂi[ <see cref="CommunicationResult"/>B
        /// </returns>
        /// <exception cref="ArgumentException">
        /// ʐMŕKvȃf[^słB
        /// </exception>
        /// <exception cref="ServerException">
        /// T[oAvP[Vőz肵ȂO܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// f[^̑MɃG[܂B
        /// </exception>
        protected override CommunicationResult Communicate(BLogicParam communicateBlogicParam,
                                                           IDictionary<string, string> requestHeaders)
        {
            IList<MultipartElement> multipartElementList = CreateMultipartElementList(communicateBlogicParam.ParamData);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_BEGIN_COMMUNICATOR_FUNCTION, Communicator.GetType().FullName));
            }

            CommunicationResult result = Communicator.Communicate(multipartElementList, requestHeaders);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_END_COMMUNICATOR_FUNCTION, Communicator.GetType().FullName));
            }

            return result;
        }

        /// <summary>
        /// <paramref name="paramData"/> }`p[gf[^擾A
        /// <see cref="MultipartElement"/>  <see cref="IList{MultipartElement}"/> 쐬܂B
        /// </summary>
        /// <param name="paramData">
        /// Mf[^i[ <see cref="DataSet"/>B
        /// </param>
        /// <returns>
        /// <see cref="MultipartElement"/> i[ <see cref="IList{MultipartElement}"/>B
        /// </returns>
        /// <exception cref="ArgumentException">
        /// <list type="bullet">
        /// <item>
        /// e[uɕKvȃJ݂܂B
        /// </item>
        /// <item>
        /// e[usłBJɒlݒ肳Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual IList<MultipartElement> CreateMultipartElementList(DataSet paramData)
        {
            IList<MultipartElement> multipartElementList = new List<MultipartElement>();

            // eLXg}`p[gf[^̐
            if (paramData.Tables.Contains(TEXT_TABLE_NAME))
            {
                DataTable valueTable = paramData.Tables[TEXT_TABLE_NAME];

                if (!valueTable.Columns.Contains(ELEMENT_NAME))
                {
                    string message = string.Format(Properties.Resources.E_COLUMN_NOT_FOUND, TEXT_TABLE_NAME, ELEMENT_NAME);
                    throw new ArgumentException(message);
                }

                if (!valueTable.Columns.Contains(TEXT_VALUE))
                {
                    string message = string.Format(Properties.Resources.E_COLUMN_NOT_FOUND, TEXT_TABLE_NAME, TEXT_VALUE);
                    throw new ArgumentException(message);
                }

                if (0 < valueTable.Rows.Count)
                {
                    foreach (DataRow row in valueTable.Rows)
                    {
                        string elementName = row[ELEMENT_NAME] as string;
                        if (string.IsNullOrEmpty(elementName))
                        {
                            string message = string.Format(Properties.Resources.E_BLOGIC_INVALID_DTOTABLE, TEXT_TABLE_NAME, ELEMENT_NAME);
                            throw new ArgumentException(message);
                        }

                        string textValue = row[TEXT_VALUE] as string;
                        if (textValue == null)
                        {
                            string message = string.Format(Properties.Resources.E_BLOGIC_INVALID_DTOTABLE, TEXT_TABLE_NAME, TEXT_VALUE);
                            throw new ArgumentException(message);
                        }

                        MultipartValueElement element
                           = new MultipartValueElement(elementName);
                        element.Value = textValue;
                        multipartElementList.Add(element);
                    }
                }
            }

            // t@C}`p[gf[^̐
            if (paramData.Tables.Contains(FILE_TABLE_NAME))
            {
                DataTable fileTable = paramData.Tables[FILE_TABLE_NAME];

                if (!fileTable.Columns.Contains(ELEMENT_NAME))
                {
                    string message = string.Format(Properties.Resources.E_COLUMN_NOT_FOUND, FILE_TABLE_NAME, ELEMENT_NAME);
                    throw new ArgumentException(message);
                }

                if (!fileTable.Columns.Contains(FILE_PATH))
                {
                    string message = string.Format(Properties.Resources.E_COLUMN_NOT_FOUND, FILE_TABLE_NAME, FILE_PATH);
                    throw new ArgumentException(message);
                }

                if (0 < fileTable.Rows.Count)
                {
                    foreach (DataRow row in paramData.Tables[FILE_TABLE_NAME].Rows)
                    {
                        string elementName = row[ELEMENT_NAME] as string;
                        if (string.IsNullOrEmpty(elementName))
                        {
                            string message = string.Format(Properties.Resources.E_BLOGIC_INVALID_DTOTABLE, FILE_TABLE_NAME, ELEMENT_NAME);
                            throw new ArgumentException(message);
                        }

                        string filePath = row[FILE_PATH] as string;
                        if (string.IsNullOrEmpty(filePath))
                        {
                            string message = string.Format(Properties.Resources.E_BLOGIC_INVALID_DTOTABLE, FILE_TABLE_NAME, FILE_PATH);
                            throw new ArgumentException(message);
                        }

                        MultipartFileElement element
                            = new MultipartFileElement(elementName);
                        element.UploadFilePath = filePath;
                        multipartElementList.Add(element);
                    }
                }
            }

            return multipartElementList;
        }
    }
}
