// <쌠>
// Copyright (c) 2006-2007, NTT DATA Corporation.

using System;
using System.IO;
using System.Data;
using NTTDATA.TERASOLUNA.FW.Common;
using NTTDATA.TERASOLUNA.FW.Client.Communication;

namespace NTTDATA.TERASOLUNA.FW.Client.BLogic
{
    /// <summary>
    /// t@C_E[hs <see cref="BLogicBase"/> hNXłB
    /// </summary>
    /// <remarks>
    /// <see cref="FileCommunicator"/> gpăt@C_E[hs܂B
    /// </remarks>
    /// <author>
    /// V菲[
    /// </author>   
    public class DownloadBLogic : BLogicBase
    {
        /// <summary>
        /// t@C_E[h@\񋟂NXێtB[hłB
        /// </summary>
        private FileCommunicator _fileCommunicator = new FileCommunicator();

        /// <summary>
        /// <see cref="BLogicBase.Cancelled"/> ̐ݒ莞ɗp铯p̃IuWFNgłB
        /// </summary>
        private object _syncRoot = new object();

        /// <summary>
        /// <see cref="DownloadBLogic"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^B
        /// </remarks>
        public DownloadBLogic()
        {
            _fileCommunicator.ProgressChanged += new ExecuteProgressChangedEventHandler(DoFileCommunicateProgressChanged);
        }

        /// <summary>
        /// _E[hs܂B
        /// </summary>
        /// <remarks>
        /// T[ot@C_E[h܂B
        /// <para>_E[ȟʂ <see cref="BLogicResult"/> Ɋi[ԋp܂B</para>
        /// <para>_E[hɏIƁA<see cref="BLogicResult.ResultString">BLogicResult.ResultString</see> "success" ݒ肵܂B</para>
        /// <para>_E[ht@CpX擾łȂꍇA<see cref="BLogicResult.ResultString">BLogicResult.ResultString</see>"failure" ݒ肵܂B</para>
        /// <para>_E[h <see cref="Cancel"/> \bhsƁA<see cref="BLogicResult.ResultString">BLogicResult.ResultString</see> "failure" ݒ肵܂B</para>
        /// </remarks>
        /// <param name="dto">rWlXWbN <see cref="DataSet"/>B</param>
        /// <returns>_E[hʂێ <see cref="BLogicResult"/>B</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="dto"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// _E[hpXɖȕ܂܂Ă܂B
        /// </exception>
        /// <exception cref="IOException">
        /// <para>_E[hꎞt@C쐬ł܂łB</para>
        /// <para>_E[ht@CpXŎw肵t@CAǂݎp܂ overwrite  false ̂ߏ㏑ł܂B</para>
        /// </exception>
        /// <exception cref="System.Security.SecurityException">
        /// _E[hpXɕKvȃANZX܂B
        /// </exception>
        /// <exception cref="DirectoryNotFoundException">
        /// _E[hpXA蓖ĂĂȂhCułȂǁAw肳ꂽpXłB
        /// </exception>
        /// <exception cref="UnauthorizedAccessException">
        /// t@C܂̓fBNgǂݎpɐݒ肳ĂȂǁA_E[hpXɑ΂ access vIy[eBO VXeŋ܂B
        /// </exception>
        /// <exception cref="PathTooLongException">
        /// _E[hpXA_E[ht@CA܂̗͂VXe`̍ő咷𒴂Ă܂BƂ΁AWindows x[X̃vbgtH[̏ꍇApX̒ 248 At@C̒ 260 łKv܂B
        /// </exception>
        /// <exception cref="InvalidOperationException">
        /// <see cref="BLogicBase.RequestName"/>ݒ肳Ă܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// ʐMɃG[܂B
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>słB
        /// </exception>
        public override BLogicResult Execute(DataSet dto)
        {
            if (dto == null)
            {
                throw new ArgumentNullException("dto");
            }

            if (string.IsNullOrEmpty(RequestName))
            {
                throw new InvalidOperationException(
                        string.Format(Properties.Resources.E_NULL_OR_EMPTY_PROPERTY_STRING,
                        "EventContext", "RequestName"));
            }

            BLogicResult blogicResult = new BLogicResult();

            if (Cancelled)
            {
                blogicResult.ResultString = FAILURE;
                return blogicResult;
            } 
            
            try
            {
                CommunicationResult communicationResult = _fileCommunicator.Download(RequestName, dto);

                if (communicationResult.ErrorType == null)
                {
                    blogicResult.ResultString = SUCCESS;
                    blogicResult.ResultData = new DataSet();
                }
                else
                {
                    blogicResult.ResultString = FAILURE;
                    blogicResult.AddErrors(communicationResult.Errors);
                }
            }
            catch (CommunicationException)
            {
                lock (_syncRoot)
                {
                    if (!Cancelled)
                    {
                        throw;
                    }
                }

                blogicResult.ResultString = FAILURE;
            }

            return blogicResult;
        }

        /// <summary>
        /// ʐMLZ܂B
        /// </summary>
        public override void Cancel()
        {
            lock (_syncRoot)
            {
                _fileCommunicator.Cancel();
                Cancelled = true;
            }
        }

        /// <summary>
        /// <see cref="FileCommunicator"/> ̃Cxgʒm 
        /// <see cref="BLogicExecutor"/> ֈϏ܂B
        /// </summary>
        /// <param name="sender">CxgIuWFNgB</param>
        /// <param name="e">Cxgf[^i[Ă <see cref="ExecuteProgressChangedEventArgs"/>B</param>
        protected virtual void DoFileCommunicateProgressChanged(object sender, ExecuteProgressChangedEventArgs e)
        {
            OnProgressChanged(e);
        }

    }
}
