/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.message;

import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockDataSource;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import com.mockrunner.mock.jdbc.MockResultSet;

/**
 * {@link jp.terasoluna.fw.message.DBMessageQuery} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * bZ[W\[X擾RDBMSIy[VNX
 * <p>
 * 
 * @see jp.terasoluna.fw.message.DBMessageQuery
 */
public class DBMessageQueryTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBMessageQueryTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBMessageQueryTest(String name) {
        super(name);
    }

    /**
     * testDBMessageDataSource01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ds:not null<br>
     *         () sql:"SELECT CODE,MESSAGE FROM MESSAGES"<br>
     *         () codeColumn:"CODE"<br>
     *         () languageColumn:"LANGUAGE"<br>
     *         () countryColumn:"COUNTRY"<br>
     *         () variantColumn:"VARIANT"<br>
     *         () messageColumn:"MESSAGE"<br>
     *         
     * <br>
     * ҒlF(ԕω) rsCodeColumn:"CODE"<br>
     *         (ԕω) rsLanguageColumn:"LANGUAGE"<br>
     *         (ԕω) rsCountryColumn:"COUNTRY"<br>
     *         (ԕω) rsVariantColumn:"VARIANT"<br>
     *         (ԕω) message:"MESSAGE"<br>
     *         (ԕω) compile():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * StringꍇAnꂽlωȂi[邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageDataSource01()
            throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBMessageQuery db = new DBMessageQuery(ds,
                "SELECT CODE,MESSAGE FROM MESSAGES", "CODE", "LANGUAGE",
                "COUNTRY", "VARIANT", "MESSAGE");

        // eXg{

        // 
        assertEquals("CODE", UTUtil.getPrivateField(db, "rsCodeColumn"));
        assertEquals("LANGUAGE",
                UTUtil.getPrivateField(db, "rsLanguageColumn"));
        assertEquals("COUNTRY", UTUtil.getPrivateField(db, "rsCountryColumn"));
        assertEquals("VARIANT", UTUtil.getPrivateField(db, "rsVariantColumn"));
        assertEquals("MESSAGE", UTUtil.getPrivateField(db, "rsMessageColumn"));
        assertTrue(db.isCompiled());
    }

    /**
     * testDBMessageDataSource02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() ds:not null<br>
     *         () sql:"SELECT CODE,MESSAGE FROM MESSAGES"<br>
     *         () codeColumn:""<br>
     *         () languageColumn:""<br>
     *         () countryColumn:""<br>
     *         () variantColumn:""<br>
     *         () messageColumn:""<br>
     *         
     * <br>
     * ҒlF(ԕω) rsCodeColumn:""<br>
     *         (ԕω) rsLanguageColumn:""<br>
     *         (ԕω) rsCountryColumn:""<br>
     *         (ԕω) rsVariantColumn:""<br>
     *         (ԕω) message:""<br>
     *         (ԕω) compile():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * 󕶎ꍇAnꂽlωȂi[邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageDataSource02()
            throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBMessageQuery db = new DBMessageQuery(ds,
                "SELECT CODE,MESSAGE FROM MESSAGES", "", "", "", "", "");

        // eXg{

        // 
        assertEquals("", UTUtil.getPrivateField(db, "rsCodeColumn"));
        assertEquals("", UTUtil.getPrivateField(db, "rsLanguageColumn"));
        assertEquals("", UTUtil.getPrivateField(db, "rsCountryColumn"));
        assertEquals("", UTUtil.getPrivateField(db, "rsVariantColumn"));
        assertEquals("", UTUtil.getPrivateField(db, "rsMessageColumn"));
        assertTrue(db.isCompiled());
    }

    /**
     * testDBMessageDataSource03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() ds:not null<br>
     *         () sql:"SELECT CODE,MESSAGE FROM MESSAGES"<br>
     *         () codeColumn:null<br>
     *         () languageColumn:null<br>
     *         () countryColumn:null<br>
     *         () variantColumn:null<br>
     *         () messageColumn:null<br>
     *         
     * <br>
     * ҒlF(ԕω) rsCodeColumn:null<br>
     *         (ԕω) rsLanguageColumn:null<br>
     *         (ԕω) rsCountryColumn:null<br>
     *         (ԕω) rsVariantColumn:null<br>
     *         (ԕω) message:null<br>
     *         (ԕω) compile():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * nullꍇAnꂽlωȂi[邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDBMessageDataSource03()
            throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBMessageQuery db = new DBMessageQuery(ds,
                "SELECT CODE,MESSAGE FROM MESSAGES", null, null, null, null,
                null);

        // eXg{

        // 
        assertNull(UTUtil.getPrivateField(db, "rsCodeColumn"));
        assertNull(UTUtil.getPrivateField(db, "rsLanguageColumn"));
        assertNull(UTUtil.getPrivateField(db, "rsCountryColumn"));
        assertNull(UTUtil.getPrivateField(db, "rsVariantColumn"));
        assertNull(UTUtil.getPrivateField(db, "rsMessageColumn"));
        assertTrue(db.isCompiled());
    }

    /**
     * testMapRow01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA,E
     * <br><br>
     * ͒lF() rs:|"code"="test01"|"language"="ja"|"country"="JP"
     * |"variant"="kaisai"|"message"="eXgbZ[WOP"|"hoge"="֌WȂJ"|<br>
     *                ƂeResultSet<br>
     *         () rowNum:not null<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessage Bean:code->"test01"<br>
     *                  language->"ja"<br>
     *                  country->"JP"<br>
     *                  variant->"kansai"<br>
     *                  message->"eXgbZ[WOP"<br>
     *         
     * <br>
     * ResultSet̃J̓eStringłꍇAl̎擾o邩̊mFB
     * ܂AvĂȂ"hoge"JꍇAG[ɂȂ炸ɖ邩
     * mFB<br>
     * 擾Strinĝ܂DBMessageBeanɊi[B
     * "hoge"J͖AǂɂeȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapRow01() throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBMessageQuery db = new DBMessageQuery(ds,
                "SELECT CODE,MESSAGE FROM MESSAGES", "CODE", "LANGUAGE",
                "COUNTRY", "VARIANT", "MESSAGE");
        int rowNum = 0;
        db.rsCodeColumn = "code";
        db.rsLanguageColumn = "language"; 
        db.rsCountryColumn = "country";
        db.rsVariantColumn = "variant";
        db.rsMessageColumn = "message";
        
        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("TestResult");
        
        List<String> list1 = new ArrayList<String>();
        list1.add("test01");
        rs.addColumn("code", list1);

        List<String> list2 = new ArrayList<String>();
        list2.add("ja");
        rs.addColumn("language", list2);
        
        List<String> list3 = new ArrayList<String>();
        list3.add("JP");
        rs.addColumn("country", list3);
        
        List<String> list4 = new ArrayList<String>();
        list4.add("kansai");
        rs.addColumn("variant", list4);
        
        List<String> list5 = new ArrayList<String>();
        list5.add("eXgbZ[WOP");
        rs.addColumn("message", list5);
        
        rs.first();
        
        // eXg{
        DBMessage dbmReturn = (DBMessage) db.mapRow(rs, rowNum);

        // 
        assertEquals("test01", dbmReturn.getCode());
        assertEquals("ja", dbmReturn.getLanguage());
        assertEquals("JP", dbmReturn.getCountry());
        assertEquals("kansai", dbmReturn.getVariant());
        assertEquals("eXgbZ[WOP", dbmReturn.getMessage());
    }

    /**
     * testMapRow02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,E
     * <br><br>
     * ͒lF() rs:|"code"=""|"language"=""|"country"=""|"variant"=""|
     * "message"=""|"hoge"=""|<br>
     *                ƂeResultSet<br>
     *         () rowNum:not null<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessage Bean:code->""<br>
     *                  language->""<br>
     *                  country->""<br>
     *                  variant->""<br>
     *                  message->""<br>
     *         
     * <br>
     * ResultSet̃J̓e󕶎łꍇAl̎擾o邩̊mFB
     * ܂AvĂȂ"hoge"JꍇAG[ɂȂ炸ɖ邩
     * mFB<br>
     * 擾󕶎̂܂DBMessageBeanɊi[B"hoge"J͖A
     * ǂɂeȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapRow02() throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBMessageQuery db = new DBMessageQuery(ds,
                "SELECT CODE,MESSAGE FROM MESSAGES", "CODE", "LANGUAGE",
                "COUNTRY", "VARIANT", "MESSAGE");
        int rowNum = 0;
        db.rsCodeColumn = "code";
        db.rsLanguageColumn = "language"; 
        db.rsCountryColumn = "country";
        db.rsVariantColumn = "variant";
        db.rsMessageColumn = "message";
        
        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("TestResult");
        
        List<String> list1 = new ArrayList<String>();
        list1.add("");
        rs.addColumn("code", list1);

        List<String> list2 = new ArrayList<String>();
        list2.add("");
        rs.addColumn("language", list2);
        
        List<String> list3 = new ArrayList<String>();
        list3.add("");
        rs.addColumn("country", list3);
        
        List<String> list4 = new ArrayList<String>();
        list4.add("");
        rs.addColumn("variant", list4);
        
        List<String> list5 = new ArrayList<String>();
        list5.add("");
        rs.addColumn("message", list5);
        
        rs.first();
        
        // eXg{
        DBMessage dbmReturn = (DBMessage) db.mapRow(rs, rowNum);

        // 
        assertEquals("", dbmReturn.getCode());
        assertEquals("", dbmReturn.getLanguage());
        assertEquals("", dbmReturn.getCountry());
        assertEquals("", dbmReturn.getVariant());
        assertEquals("", dbmReturn.getMessage());
    }

    /**
     * testMapRowResultSetint03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,E
     * <br><br>
     * ͒lF() rs:|"code"=null|"language"=null|"country"=null
     * |"variant"=null|"message"=null|"hoge"=null|<br>
     *                ƂeResultSet<br>
     *         () rowNum:not null<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessage Bean:code->""<br>
     *                  language->""<br>
     *                  country->""<br>
     *                  variant->""<br>
     *                  message->""<br>
     *         (ԕω) O:yxOz<br>
     *                    bZ[W<br>
     *                    "MessageCode is null"<br>
     *         
     * <br>
     * ResultSet̃J̓enullłꍇA"hoge"JA󕶎
     * ϊDBMessageBeanɊi[B܂MessageCodeJ̓enull
     * ꍇ́AxOo͂B"hoge"J͖A
     * ǂɂeȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapRowResultSetint03() throws Exception {
        // O
        DataSource ds = new MockDataSource();
        DBMessageQuery db = new DBMessageQuery(ds,
                "SELECT CODE,MESSAGE FROM MESSAGES", "CODE", "LANGUAGE",
                "COUNTRY", "VARIANT", "MESSAGE");
        int rowNum = 0;
        db.rsCodeColumn = "code";
        db.rsLanguageColumn = "language"; 
        db.rsCountryColumn = "country";
        db.rsVariantColumn = "variant";
        db.rsMessageColumn = "message";
        
        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("TestResult");
        
        List<String> list1 = new ArrayList<String>();
        list1.add(null);
        rs.addColumn("code", list1);

        List<String> list2 = new ArrayList<String>();
        list2.add(null);
        rs.addColumn("language", list2);
        
        List<String> list3 = new ArrayList<String>();
        list3.add(null);
        rs.addColumn("country", list3);
        
        List<String> list4 = new ArrayList<String>();
        list4.add(null);
        rs.addColumn("variant", list4);
        
        List<String> list5 = new ArrayList<String>();
        list5.add(null);
        rs.addColumn("message", list5);
        
        rs.first();
        
        // eXg{
        DBMessage dbmReturn = (DBMessage) db.mapRow(rs, rowNum);

        // 
        assertEquals("", dbmReturn.getCode());
        assertEquals("", dbmReturn.getLanguage());
        assertEquals("", dbmReturn.getCountry());
        assertEquals("", dbmReturn.getVariant());
        assertEquals("", dbmReturn.getMessage());
        assertTrue(LogUTUtil.checkWarn("MessageCode is null"));
        
    }
}
