/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.controller;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;
import jp.terasoluna.fw.web.rich.springmvc.Constants;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.ServletRequestDataBinderCreator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;

/**
 * T[rXw̃NXs郊NGXgRg[ۃNXB
 *
 * <p>{Rg[́A<code>DispachServlet</code>NA
 * ȉ̋@\񋟂B
 * </p>
 * <ul>
 * <li>HTTPNGXgJavaBeaniR}hjɃoCh</li>
 * <li>̓`FbNs</li>
 * <li>POJŐƖWbNNXs</li>
 * <li>JavaBan(f)Viewԋp</li>
 * </ul>
 * 
 * <p>
 * {NX́AۃNXłB
 * ƖJ҂ANGXgƂɖ{NX̎NX쐬邱ƁB
 * {NX́A^p[^𗘗pĐ錾ĂB
 * ^p[^ṔAHTTPNGXgoChJavaBeaniR}h)A
 * ^p[^ŔAViewɔfێJavaBean(f)̌^킵ĂB
 * NX錾ɁA^p[^Ɏۂ̌^w肵A
 * ۃ\bȟ^ϐw肵^ɂ킹Ď邱Ƃ
 * NX̌^̈SۏႳĂB
 * ^p[^P,Rɂ́AKȂRXgN^JavaBeanw肷邱ƁB
 * C^tF[XAۃNXAȂRXgN^ȂNX̎w͏oȂB
 * </p>
 * 
 * <p>
 * <u>T[rXw̃NX̎s</u><br>
 * T[rXw̃NX́ADIRei𗘗pĖ{Rg[ɐݒ肳邱ƂOƂ̂ŁA
 * ƖJ҂̓T[rXw̃NX𑮐ƂėpӂAsetter/getter\bh݂邱ƁB
 * ܂AĂяóAۃ\bhłexecuteService\bhɎ邱ƁB
 * </p>
 * 
 * <p> 
 * ƖŗOꍇA
 * Spring MVC̗O@\ŃnhOB
 * </p>
 *
 * <p>
 * <u>oCh</u><br>
 * ServletRequestDataBinderpNXsB
 * ServletRequestDataBinder𐶐邽߂̃NXłDataBinderCreator
 * DIRei𗘗pĖ{Rg[ɐݒ肷邱ƁB
 * DataBinderCreatoŕANGXǧ`(XML or Query)ɂg킯B
 * oChŁAoChG[ꍇABindExceptionX[A
 * Spring MVC̗O@\ŃnhOB
 * </p>
 * 
 * <p>
 * <u>̓`FbN</u><br>
 * ValidatorC^tF[XNXsB
 * ValidatorC^tF[XNX
 * DIRei𗘗pĖ{Rg[ɐݒ肷邱ƁB
 * ̓`FbNŁA̓`FbNG[ꍇA
 * BindExceptionX[A
 * Spring MVC̗O@\ŃnhOB
 * </p>
 * 
 * <p>
 * <u>r[̐ݒ</u><br>
 * <code>DispachServlet</code>ł̃r[Ɏgpr[
 * {@link #handle(HttpServletRequest, HttpServletResponse, Object, BindException)}
 * \bhŐݒ肵ĂB
 * r[́Aȉ̏ԂŌ肳B
 * <ul>
 * <li>{Rg[{@link #viewName}͂Ă΁Ȃl</li>
 * <li>{Rg[{@link #useRequestNameView}trueȂ΁A
 *     h/h{uNGXgv@</li>
 * <li>LɂĂ͂܂ȂꍇA󕶎@</li>
 * </ul>
 * TERASOLUNȀݒł́Ar[ɋ󕶎Ă
 * Castorr[gpdlɂȂĂB
 * </p>
 * 
 * <p>
 * gUNVǗ̐Ӗ́AT[rXw󂯎B
 * iAAOPɂ錾IgUNV𗘗p̂ŁA
 * T[rXw̃NXӎKv͂ȂBj
 * </p>
 *
 * <p>
 * 쐬NX𗘗pɂ́ABean̒`sƁB
 * </p>
 *
 * <p>
 * y<code>xxx-servlet.xml</code>̒`z<br>
 * <code><pre>
 *   &lt;bean name="/secure/blogic/sum.do"
 *       class="jp.terasoluna.sample2.web.controller.SumController"
 *       parent="xmlRequestController" singleton ="false"&gt;
 *     &lt;property name="sumService" ref="sumService"/&gt;
 *     &lt;property name="ctxSupport" ref="ctxSupport"/&gt;  
 *     &lt;property name="dataBinderCreator" ref="xmlDataBinderCreator"/&gt;
 *     &lt;property name="validator" ref="sumValidator"/&gt;
 *   &lt;/bean&gt;
 * </pre></code>
 * </p>
 * 
 * <p>
 * ȉ̃vpeBݒ肷邱ƁB
 *   <table border="1" CELLPADDING="8">
 *     <th></th>
 *     <th>K{</th>
 *     <th></th>
 *  
 *     <tr>
 *       <td align=center><b>ctxSupport</b></td>
 *       <td></td>
 *       <td>T|[gNXB</td>
 *     </tr>
 *     
 *     <tr>
 *       <td align=center><b>dataBinderCreator</b></td>
 *       <td></td>
 *       <td>NGXgf[^oC_NXB</td>
 *     </tr>
 *   
 *     <tr>
 *       <td align=center><b>validator</b></td>
 *       <td>~</td>
 *       <td>̓`FbNNXB</td>
 *     </tr> 
 *     
 *     <tr>
 *       <td align=center><b>viewName</b></td>
 *       <td>~</td>
 *       <td>r[B
 *           ftHgȊOViewZp(Velocity,oCif[^, PDF, Excel)
 *           pꍇɐݒ肷B</td>
 *     </tr>
 *     <tr>
 *       <td align=center><b>useRequestNameView</b></td>
 *       <td>~</td>
 *       <td>r[ɃNGXggp邩ftOB
 *           ftHgfalseBNGXggpꍇAtrueݒ肷B
 *           trueݒ肳ĂĂAviewName͂ĂviewName
 *           Ήr[gpB
 *       </td>
 *     </tr> 
 *  </table>
 *  ̂قɎsT[rXw̃NXvpeBɐݒ肷邱ƁB
 *  R}hNXw肷Acommandclass̎w͕svłB
 *  R}hNX̌^́A{NX̌^p[^AIɔf邽߂łB
 * </p>
 * 
 * 
 * <p>
 * ܂AT|[gNXANGXgf[^oC_NX̐ݒ́A
 * ̃Rg[`œɂȂB
 * āABean`炩ߐݒ肵ĂA
 * NXBean`́ABean`pčs
 * ݒt@C̋LqVvɂȂB
 * </p>
 * 
 * <p>
 * yBean`𗘗p<code>xxx-servlet.xml</code>̒`z<br>
 * <code><pre>
 *   &lt;!-- Rg[̒Bean` --&gt;
 *   &lt;bean id="xmlRequestController" abstract="true"&gt;
 *     &lt;property name="cxtSupport" ref="ctxSupport"/&gt;  
 *     &lt;property name="dataBinderCreator" ref="xmlDataBinderCreator"/&gt;
 *   &lt;/bean&gt;
 *
 *   &lt;!-- Bean`pRg[̒` --&gt;
 *   &lt;bean name="/secure/blogic/sum.do"
 *       class="jp.terasoluna.sample2.web.controller.SumController"
 *       parent="xmlRequestController" scope="singleton"&gt;
 *     &lt;property name="sumService" ref="sumService"/&gt;
 *     &lt;property name="validator" ref="sumValidator"/&gt;
 *   &lt;/bean&gt;
 * </code></pre>
 * </p>
 * 
 * <p>
 * TERASOLUNAł́A
 * 炩߂̒Bean`pӂĂBKvɉėp邱ƁB
 *   <table border="1" CELLPADDING="8">
 *     <th>Bean</th>
 *     <th>MNGXg</th>
 *     <th>NT[rX</th>
 *  
 *     <tr>
 *       <td align=center><b>xmlRequestController</b></td>
 *       <td>XML`</td>
 *       <td>POJO</td>
 *     </tr>
 *     
 *     <tr>
 *       <td align=center><b>queryRequestController</b></td>
 *       <td>NG`</td>
 *       <td>POJO</td>
 *     </tr>
 *   
 *     <tr>
 *       <td align=center><b>xmlRequestBLogicExecuteController</b></td>
 *       <td>XML`</td>
 *       <td>BLogic</td>
 *     </tr> 
 *     
 *     <tr>
 *       <td align=center><b>queryRequestBLogicExecuteController</b></td>
 *       <td>NG`</td>
 *       <td>BLogic</td>
 *     </tr>   
 *  </table>
 * 
 * </p>
 *   
 * </pre></code>
 * </p>
 *
 * <p>
 * KpVXeɓƖOA㏈ǉꍇ
 * iႦ΋Ɩp[^Ɩʂ
 * ZbV̏𔽉fꍇjA
 * preServiceApostService\bhI[o[ChNX쐬A
 * p邱ƁB<br>
 * TuNXŒۃNXgpꍇA{@link #getCommandType()}\bh
 * I[o[ChKvB
 * </p>
 * 
 * <p>
 * NT[rXw̃NXƂPOJOł͂ȂA
 * BLogicC^tF[XNX𗘗p邱Ƃ\łB
 * ڍׂBLogicControllerQƂ̂ƁB
 * </p>
 * 
 * 
 * @param <P> R}hNXBT[rXw̃NX֓nNXB
 * @param <R> fNXBT[rXw̃NXԂNXB
 * @see jp.terasoluna.fw.web.rich.springmvc.controller.BLogicController
 * 
 */
public abstract class TerasolunaController<P, R>
        extends AbstractCommandController implements InitializingBean {
    
    /**
     * ^p[^<P, R>`ĂRg[NXB
     */
    protected Class parameterizedControllerClass = TerasolunaController.class;

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(TerasolunaController.class);
    
    /**
     * T|[gWbNNXB
     */
    protected RequestContextSupport ctxSupport = null;
    
    /**
     * ServletRequestDataBinderpNX𐶐NXB
     */
    protected ServletRequestDataBinderCreator dataBinderCreator = null;
    
    /**
     * ftHgȊÕr[Zp(Velocity,oCif[^, PDF, Excel)
     * pꍇɐݒ肷r[B
     */
    protected String viewName = null;
    
    /**
     * r[ɃNGXggp邩ftOB
     * <p>trueݒ肵ꍇAr[ɃNGXgݒ肷B
     */
    protected boolean useRequestNameView = false;

    /**
     * ReLXgT|[gWbNNXݒ肷B
     *
     * @param ctxSupport T|[gWbNNX
     */
    public void setCtxSupport(RequestContextSupport ctxSupport) {
        this.ctxSupport = ctxSupport;
    }
    
    /**
     * DataBinderNXݒ肷B
     * 
     * @param dataBinderCreator DataBinderNX
     */
    public void setDataBinderCreator(
            ServletRequestDataBinderCreator dataBinderCreator) {
        this.dataBinderCreator = dataBinderCreator;
    }

    /**
     * r[ݒ肷B
     * 
     * @param viewName ftHgȊOViewZp𗘗pꍇ
     * ݒ肷View
     */
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
    
    /**
     * r[ɃNGXggp邩ftOݒ肷B
     *
     * @param useRequestNameView r[ɃNGXggp邩ftOB
     */
    public void setUseRequestNameView(boolean useRequestNameView) {
        this.useRequestNameView = useRequestNameView;
    }
    
    /**
     * DIReiɂăCX^XꂽɌĂ΂郁\bhB
     * K{Null`FbNsB
     */
    public void afterPropertiesSet() {
        if (this.dataBinderCreator == null) {
            log.error("DataBinderCreator is Null.");
            throw new IllegalStateException("DataBinderCreator is Null.");
        }
        
        if (this.ctxSupport == null) {
            log.error("ContextSupport is Null.");
            throw new IllegalStateException("ContextSupport is Null.");
        }
    }

    /**
     * NGXg̏i[邽߂JavaBean(R}h)擾B
     * ^p[^Rg[ɑΉJavaBean(R}h)̌^𔻒肵A
     * CX^XB
     * 
     * @param request HTTPNGXg
     * @return object ̃R}hIuWFNg
     * @throws Exception O
     */
    @Override
    protected Object getCommand(
            HttpServletRequest request) throws Exception {
        // R}hNX̌^p[^擾
        Type commandType = getCommandType();
            
        if (logger.isDebugEnabled()) {
            logger.debug(
                "Creating new command of class ["
                    + ((Class) commandType).getName() + "]");
        }
        
        // ^p[^Object^iw肳ĂȂj
        if (commandType == Object.class) { 
            String message = "Cannot get Command type. "
                + "Controller cannot specify the Object type "
                + "for parameterized type P.";
            log.error(message);
            throw new IllegalStateException(message);
        }
        
        try {
            // R}hNXCX^X
            return ClassUtil.create(((Class) commandType).getName());
        } catch (Exception e) {
            log.error("Invalid Command type.", e);
            throw new IllegalStateException("Invalid Command type.");
        }
    }

    /**
     * {NX̃TuNX`ꂽAR}hNX̎^Cv擾B
     * 
     * @return R}hNX̃^CvB
     */
    protected Type getCommandType() {
        Class childClass = this.getClass();
        
        // Qȏ̌pĂꍇA
        // TerasolunaController̎qɂNX擾
        while (childClass.getSuperclass() != parameterizedControllerClass) {
            childClass = childClass.getSuperclass();
        }
        
        // TerasolunaControlleř^i^p[^̏tj
        Type terasolunaControllerType = childClass.getGenericSuperclass();
        if (!(terasolunaControllerType instanceof ParameterizedType)) {
            log.error("Controller class must be set ParameterizedType");
            throw new IllegalStateException(
                    "Controller class must be set ParameterizedType");
        }
        ParameterizedType pt = (ParameterizedType) terasolunaControllerType;
        
        // ^p[^
        return pt.getActualTypeArguments()[0];
    } 
   
    /**
     *  NGXg̏JavaBean(R}h)Ɋi[邽߂
     *  f[^oC_𐶐B
     *  <code>bindAndValidate</code>\bhĂяoB
     *  
     * @param request HTTPNGXg
     * @param command oChR}hIuWFNg
     * @return ꂽf[^oC_
     * @throws Exception O
     * 
     */
    @Override
    protected ServletRequestDataBinder createBinder(
            HttpServletRequest request, Object command) throws Exception {
        // f[^oC_̐
        ServletRequestDataBinder binder = dataBinderCreator.create(
                      request, command, ctxSupport.getRequestName());
        
        if (binder == null) {
            log.error("DataBinder is Null.");
            throw new IllegalStateException("DataBinder is Null.");
        }
        
        if (this.getMessageCodesResolver() != null) {
            binder.setMessageCodesResolver(this.getMessageCodesResolver());
        }
        if (getBindingErrorProcessor() != null) {
            binder.setBindingErrorProcessor(getBindingErrorProcessor());
        }
        if (getPropertyEditorRegistrars() != null) {
            for (int i = 0; i < getPropertyEditorRegistrars().length; i++) {
                getPropertyEditorRegistrars()[i].registerCustomEditors(binder);
            }
        }
        initBinder(request, binder);
        return binder;
    }
    
    /**
     * NGXg̏JavaBean(R}h)Ɋi[Ɏs鏈B
     * oChA̓`FbNÕ^C~OŌĂяoB
     * 
     * oChŃG[񂪊i[ꂽꍇA
     * BindExceptionX[B
     * 
     * @param request HTTPNGXg
     * @param command oChς݂JavaBeaniR}hj
     * @param errors oChE̓`FbNG[ێNX
     * @throws Exception O
     */
    @Override
    protected void onBind(
            HttpServletRequest request,
            Object command,
            BindException errors) throws Exception {
        if (errors.hasErrors()) {
            throw errors;
        }
    }
    
    /**
     * ̓`FbŇ㏈B
     * ̓`FbNAƖWbNsÕ^C~OŌĂяoB
     * 
     * ̓`FbNŃG[񂪊i[ꂽꍇA
     * BindExceptionX[B
     * 
     * @param request HTTPNGXg
     * @param command oChς݂̃R}hIuWFNg
     * @param errors oChE̓`FbNG[ێNX
     * @throws Exception O
     */
    @Override
    protected void onBindAndValidate(
            HttpServletRequest request,
            Object command,
            BindException errors) throws Exception {
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    /**
     * ƖWbNs\bhĂяoAfƃr[ԋpB
     * 
     * 
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param command R}hIuWFNg
     * @param errors oChE̓`FbNG[ێNX
     * @return fƃr[
     * @throws Exception O
     */
    @SuppressWarnings("unchecked")
    @Override
    protected ModelAndView handle(
            HttpServletRequest request,
            HttpServletResponse response,
            Object command,
            BindException errors) throws Exception {
        R model = executeService(request, response, (P) command);

        if (this.viewName != null) {
            // r[𒼐ڎw肷ꍇ
            return new ModelAndView(viewName, Constants.RESULT_KEY, model);
        } else if (this.useRequestNameView) {
            // Velocityr[𗘗pꍇ
            return new ModelAndView(
                "/" + ctxSupport.getRequestName(), Constants.RESULT_KEY, model);
        } else {
            // r[ȂCastorr[𗘗p
            return new ModelAndView("", Constants.RESULT_KEY, model);
        }
    }
    
    /**
     * ƖWbNsB
     * 
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param command R}hIuWFNg
     * @return fIuWFNg
     * @throws Exception O
     */
    protected R executeService(
            HttpServletRequest request,
            HttpServletResponse response,
            P command) throws Exception {
        // O
        preService(request, response, command);

        // ƖWbNs
        R model = executeService(command);
        
        // ㏈
        postService(request, response, command, model);
        return model;
    }

    /**
     * ƖWbNs㏈B
     * 
     * ZbVXR[ṽNGXgɑΉ邽߂̊g_B
     * TuNXɂĕKvɉăI[o[Ch邱ƁB
     * 
     * ƖWbNɂėOꍇ͎sȂB
     * 
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param command R}hIuWFNg
     * @param modelAndView fƃr[
     * @throws Exception O
     */
    protected void postService(
            HttpServletRequest request,
            HttpServletResponse response,
            P command,
            R modelAndView) throws Exception {
    }

    /**
     * ƖWbNsOB
     * 
     * ZbVXR[ṽNGXgɑΉ邽߂̊g_B
     * TuNXɂĕKvɉăI[o[Ch邱ƁB
     * 
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param command R}hIuWFNg
     * @throws Exception O
     */
    protected void preService(
            HttpServletRequest request,
            HttpServletResponse response,
            P command) throws Exception {
    }

    /**
     * ƖJ҂ׂAƖWbN̎sB
     * @param command R}hiƖp[^j
     * @return f
     * @throws Exception O
     */
    protected abstract R executeService (
            P command) throws Exception;

}
