/*
 * Copyright (c) 2008 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.dao.ibatis;

import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.dao.event.DataRowHandler;
import jp.terasoluna.fw.dao.ibatis.event.RowHandlerWrapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.ibatis.SqlMapClientTemplate;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

/**
 * <p>
 * QueryRowHandleDAOC^tF[XiBATISNXB<br>
 * QƌnSQĽʂ1sB
 * </p>
 * 
 * <p>
 * executeWithRowHandler\bḧDataRowHandlerNXnĎgpB<br>
 * executeWithRowHandler\bĥ́ASQL̎sʂԂȂƂɒӂB<br>
 * SQL̎sʂ1sƂDataRowHandler#handleRow()Ă΂A
 * 1s̃f[^i[IuWFNgnB<br>
 * DataRowHandler#handleRow()ɂ́A1s̃f[^KvB<br>
 * </p>
 * 
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>ӎ</legend>
 * iBATIS}bsO`t@C&lt;statement&gt;vfA&lt;select&gt;vfA
 * &lt;procedure&gt;vfɂđʃf[^Ԃ悤ȃNGLqꍇɂ́A
 * fetchSizeɓK؂Ȓlݒ肵ĂƁB<br>
 * fetchSizeɂJDBChCoƃf[^x[XԂ̒ʐMɂāA
 * x̒ʐMŎ擾f[^̌ݒ肷B<br>
 * fetchSizeȗꍇ͊eJDBChCõftHglpB
 * </fieldset>
 * </p>
 * 
 * @see jp.terasoluna.fw.dao.event.DataRowHandler
 * @see jp.terasoluna.fw.dao.QueryRowHandleDAO
 */
public class QueryRowHandleDAOiBatisImpl extends SqlMapClientDaoSupport
        implements QueryRowHandleDAO {

    /**
     * OCX^X
     */
    private static Log log = LogFactory.
            getLog(QueryRowHandleDAOiBatisImpl.class);

    /**
     * SQL̎sʂDataRowHandler1sB
     *
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param rowHandler 1s擾Ƃɏnh
     */
    public void executeWithRowHandler(final String sqlID,
            final Object bindParams, final DataRowHandler rowHandler) {
        if (log.isDebugEnabled()) {
            log.debug("executeWithRowHandler Start.");
        }

        // SqlMapClientTemplate̎擾
        SqlMapClientTemplate sqlMapTemp = getSqlMapClientTemplate();

        // SQL̎s
        sqlMapTemp.queryWithRowHandler(sqlID, bindParams,
                new RowHandlerWrapper(rowHandler));

        if (log.isDebugEnabled()) {
            log.debug("executeWithRowHandler End.");
        }
    }

}
