/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.CacheFactory;

public final class OsCacheFactory
implements CacheFactory {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$cache$distributed$OsCacheFactory == null ? (class$org$castor$cache$distributed$OsCacheFactory = OsCacheFactory.class$("org.castor.cache.distributed.OsCacheFactory")) : class$org$castor$cache$distributed$OsCacheFactory));
    private Object _cache = null;
    static /* synthetic */ Class class$org$castor$cache$distributed$OsCacheFactory;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$castor$cache$distributed$OsCache;

    public Cache getCache(ClassLoader classLoader) throws CacheAcquireException {
        return this.getCache("com.opensymphony.oscache.general.GeneralCacheAdministrator", classLoader);
    }

    public Cache getCache(String implementation, ClassLoader classLoader) throws CacheAcquireException {
        ClassLoader loader = classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (this._cache == null) {
            try {
                this._cache = loader.loadClass(implementation).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                String msg = "Cannot find class " + implementation + ".";
                LOG.error((Object)msg, (Throwable)cnfe);
                throw new CacheAcquireException(msg, cnfe);
            }
            catch (IllegalAccessException iae) {
                String msg = "Illegal access with class " + implementation + ".";
                LOG.error((Object)msg, (Throwable)iae);
                throw new CacheAcquireException(msg, iae);
            }
            catch (InstantiationException ie) {
                String msg = "Cannot create instance of " + implementation + ".";
                LOG.error((Object)msg, (Throwable)ie);
                throw new CacheAcquireException(msg, ie);
            }
        }
        Cache cache = null;
        try {
            Class<?> cls = loader.loadClass(this.getCacheClassName());
            Constructor<?> cst = cls.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = OsCacheFactory.class$("java.lang.Object")) : class$java$lang$Object);
            cache = (Cache)cst.newInstance(this._cache);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Cannot find class " + this.getCacheClassName() + ".";
            LOG.error((Object)msg, (Throwable)cnfe);
            throw new CacheAcquireException(msg, cnfe);
        }
        catch (NoSuchMethodException nsme) {
            String msg = "NoSuchMethodException";
            LOG.error((Object)msg, (Throwable)nsme);
            throw new CacheAcquireException(msg, nsme);
        }
        catch (IllegalAccessException iae) {
            String msg = "Illegal access with class " + this.getCacheClassName() + ".";
            LOG.error((Object)msg, (Throwable)iae);
            throw new CacheAcquireException(msg, iae);
        }
        catch (InstantiationException ie) {
            String msg = "Cannot create instance of " + this.getCacheClassName() + ".";
            LOG.error((Object)msg, (Throwable)ie);
            throw new CacheAcquireException(msg, ie);
        }
        catch (InvocationTargetException ite) {
            String msg = "InvocationTargetException";
            LOG.error((Object)msg, (Throwable)ite);
            throw new IllegalStateException(ite.getMessage());
        }
        return cache;
    }

    public String getCacheType() {
        return "oscache";
    }

    public String getCacheClassName() {
        return (class$org$castor$cache$distributed$OsCache == null ? (class$org$castor$cache$distributed$OsCache = OsCacheFactory.class$("org.castor.cache.distributed.OsCache")) : class$org$castor$cache$distributed$OsCache).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this._cache;
        synchronized (object) {
            this.invokeMethod(this._cache, "destroy", null, null);
        }
    }

    private Object invokeMethod(Object target, String name, Class[] types, Object[] arguments) {
        try {
            Method method = target.getClass().getMethod(name, types);
            return method.invoke(target, arguments);
        }
        catch (SecurityException e) {
            LOG.error((Object)"SecurityException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"NoSuchMethodException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"IllegalArgumentException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"IllegalAccessException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"InvocationTargetException", (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

