/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.service.controller;


import jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController;
import jp.terasoluna.rich.functionsample.service.bean.ServiceInputData;
import jp.terasoluna.rich.functionsample.service.bean.ServiceResultData;
import jp.terasoluna.rich.functionsample.service.service.ServiceService;

/**
 * T[rXNXsPOJORg[()<br>
 * ̓f[^NX{@link ServiceInputData}w肵Ď
 *
 */
public class ServiceController extends 
TerasolunaController<ServiceInputData, ServiceResultData> {

    /**
     * T[rXNX
     */
    protected ServiceService serviceService;

    /**
     * T[rXNXsC^tF[X()ݒ肷B
     * @param serviceService T[rXNXsC^tF[X()
     */
    public void setServiceService(ServiceService serviceService) {
        this.serviceService = serviceService;
    }

    /**
     * T[rXNXsB
     *
     * @param command T[rXNXs̓NX
     * @return T[rXNXsʃNX
     * @throws Exception O
     */
    @Override
    protected ServiceResultData executeService(ServiceInputData command) 
                                                        throws Exception {
        return serviceService.sum(command);
    }
}
