/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import jp.terasoluna.utlib.exception.Exception_PageContextImpl;
import junit.framework.TestCase;

/**
 * DateFormatterTagBase ubN{bNXeXgB<br>
 *
 */
public class DateFormatterTagBaseTest extends TestCase {

    //eXgΏ
    DateFormatterTagBaseImpl01 tag = null;

    /**
     * Constructor for DateFormatterTagBaseTest.
     * @param arg0
     */
    public DateFormatterTagBaseTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag =
            (DateFormatterTagBaseImpl01) TagUTUtil.create(
                DateFormatterTagBaseImpl01.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * value=Null<br>
     * ignore=true<br>
     * name=Not Null<br>
     * property=*<br>
     * scope=l<br>
     * bean=null<br>
     * valu2=*<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * 擾uBeanvNULL̏ꍇ̃eXgP[X<br>
     */
    public void testDoStartTag01() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "NoBeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        // DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();
        bean.setTestField("2004/11/24 10:31:00");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    } /* testDoStartTag01 End */

    /**
     * testDoStartTag02B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * value=Null<br>
     * ignore=true<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=Not Null<br>
     * valu2=Null<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * 擾uvalue2vNULL̏ꍇ̃eXgP[X<br>
     */
    public void testDoStartTag02() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        //DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();
        bean.setTestField(null);

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    } /* testDoStartTag02 End */

    /**
     * testDoStartTag03B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=Not Null<br>
     * valu2=Not Null(String)<br>
     * id=Not Null<br>
     * filter=*<br>
     * output="<DateFormatterTagBaseTest>"<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContextid="<DateFormatterTagBaseTest>"<br>
     * output=-<br>
     * 
     * 擾lValueStrinĝ߁ADate^֕ϊA
     * NXϐ́uidvL[Ƀy[WReLXgɃtH[}bg̒l
     * Zbgꍇ̃eXgP[X<br>
     */
    public void testDoStartTag03() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        // DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();
        bean.setTestField("2004/11/24 10:31:00");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);
        
        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        assertEquals("<DateFormatterTagBaseTest>", pc.getAttribute("id"));

    } /* testDoStartTag03 End */

    /**
     * testDoStartTag04B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * value=Not Null(Date)<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=Null<br>
     * filter=true<br>
     * output="&lt;DateFormatterTagBaseTest&gt;"<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output="&lt;DateFormatterTagBaseTest&gt;"<br>
     * 
     * 擾lValueDatê߁ADate^փLXgANXϐ́uidvw肳ĂȂ߁AtH[}bg̒ltB^[Ay[WɊ֘AtꂽC^ɏޏꍇ̃eXgP[X<br>
     */
    public void testDoStartTag04() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "dateField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        // DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();
        bean.setTestField("2004/11/24 10:31:00");
        
        Timestamp time = Timestamp.valueOf("2004-11-24 10:31:00.000000000");
        bean.setDateField(new Date(time.getTime()));
        
        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals(Tag.SKIP_BODY, result);
        assertEquals("&lt;DateFormatterTagBaseTest&gt;", reader);

    } /* testDoStartTag04 End */

    /**
     * testDoStartTag05B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * value=Not Null(Not Date& Not String)<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * 擾lValueStringłDatełȂꍇ̃eXgP[X<br>
     */
    public void testDoStartTag05() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "timeField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        //DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();
        bean.setTimeField(new Integer(1));

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals(Tag.SKIP_BODY, result);
        assertNull(pc.getAttribute("id"));
        assertEquals("", reader);

    } /* testDoStartTag05 End */

    /**
     * testDoStartTag06B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * value=Not Null(Date)<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=Null<br>
     * filter=false<br>
     * output="test<test>test"<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContextid=-<br>
     * output="<DateFormatterTagBaseTest>"<br>
     * 
     * 擾lValueDatê߁ADate^փLXgA
     * NXϐ́uidvw肳ĂȂ߁A
     * tH[}bg̒ltB^[ɁA
     * y[WɊ֘AtꂽC^ɏޏꍇ̃eXgP[X<br>
     */
    public void testDoStartTag06() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "dateField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));

        //DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();

        Timestamp time = Timestamp.valueOf("2004-11-24 10:31:00.000000000");
        bean.setDateField(new Date(time.getTime()));

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        String reader = TagUTUtil.getOutputString(tag);
        assertEquals(Tag.SKIP_BODY, result);
        assertEquals("<DateFormatterTagBaseTest>", reader);

    } /* testDoStartTag06 End */

    /**
     * testDoStartTag07B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * value=Null<br>
     * ignore=true<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=ُl<br>
     * bean=*<br>
     * valu2=*<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * 
     * Ғl
     * ߂l:int=JspException<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * uBeanv擾JspExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag07() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "NoBeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "Not Scope");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        //DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();
        UTUtil.setPrivateField(bean, "testField", "testtesttest");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        //eXgs
        try {
            tag.doStartTag();
            // OȂꍇeXg͎sB
            fail();
        } catch (JspException ex) {
            //eXg
            return;
        }

        

    } /* testDoStartTag07 End */

    /**
     * testDoStartTag08B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=z肵镶<br>
     * scope=l<br>
     * bean=*<br>
     * valu2=*<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * 
     * Ғl
     * ߂l:int=JspException<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * uvalue2v擾JspExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag08() throws Exception {

        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "NotestField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        // DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();
        UTUtil.setPrivateField(bean, "testField", "testtesttest");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);

        // eXgs
        try {
            tag.doStartTag();
            // OȂꍇeXg͎sB
            fail();
        } catch (JspException ex) {
            //eXgB
            return;
        }
        

    } /* testDoStartTag08 End */

    /**
     * testDoStartTag09B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * value=Not Null<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=Null<br>
     * filter=true<br>
     * output=" output"<br>
     * 
     * Ғl
     * ߂l:int=JspException<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * tB^[ς݂̒ly[WɊ֘AtꂽC^ɏނƂ
     * JspExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag09() throws Exception {

        //eXgf[^ݒ
        String testValue = "2004/11/24 10:31:00";
        UTUtil.setPrivateField(tag, "value", testValue);
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        PageContext pc = TagUTUtil.getPageContext(tag);
        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);
        UTUtil.setPrivateField(pc, "jspWriter", out);

        //eXgs
        try {
            tag.doStartTag();
            // OȂꍇeXg͎sB
            fail();
        } catch (JspException ex) {
            // IOExceptionbvĂ邱ƂmFB
            assertEquals(IOException.class.getName(),
                    ex.getRootCause().getClass().getName());
            return;
        }

    } /* testDoStartTag09 End */

    /**
     * testDoStartTag10B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * value=Not Null<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=Null<br>
     * filter=false<br>
     * output=" output"<br>
     * 
     * Ғl
     * ߂l:int=JspException<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * ly[WɊ֘AtꂽC^ɏނƂJspExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag10() throws Exception {

        //eXgf[^ݒ
        String testValue = "2004/11/24 10:31:00";
        UTUtil.setPrivateField(tag, "value", testValue);
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));

        PageContext pc = TagUTUtil.getPageContext(tag);
        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);
        UTUtil.setPrivateField(pc, "jspWriter", out);

        //eXgs
        try {
            tag.doStartTag();
            // OȂꍇeXg͎sB
            fail();
        } catch (JspException ex) {
            // IOExceptionbvĂ邱ƂmFB
            assertEquals(IOException.class.getName(),
                    ex.getRootCause().getClass().getName());
            return;
        }

    } /* testDoStartTag10 End */

    /**
     * testDoStartTag11B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=*<br>
     * valu2=Not Null<br>
     * id=Not Null<br>
     * filter=*<br>
     * output="output"<br>
     * 
     * Ғl
     * ߂l:int=NullPointerException<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * y[WReLXgɃZbg鎞NullPointerExceptionꍇ<br>
     */
    public void testDoStartTag11() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", "2004/11/24 10:31:00");
        UTUtil.setPrivateField(tag, "id", "id");

        PageContext pc = TagUTUtil.getPageContext(tag);
        Exception_PageContextImpl pc2 =
            new Exception_PageContextImpl(
                pc.getServletConfig(),
                pc.getRequest(),
                pc.getResponse());
        pc2.setNullPointerEx();
        //pc2.setIllegalArgumentEx();
        pc2.setTiming(1);
        tag.setPageContext(pc2);

        //eXgs
        try {
            tag.doStartTag();
            // OȂꍇeXg͎sB
            fail();
        } catch (NullPointerException ex) {

            //eXgʊmF
            assertEquals(NullPointerException.class.getName(), ex.getClass()
                    .getName());
            return;
        }

    } /* testDoStartTag11 End */

    /**
     * testDoStartTag12B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=*<br>
     * valu2=Not Null<br>
     * id=Not Null<br>
     * filter=*<br>
     * output="output"<br>
     * 
     * Ғl
     * ߂l:int=IllegalArgumentException<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * y[WReLXgɃZbg鎞IllegalArgumentExceptionꍇ<br>
     */
    public void testDoStartTag12() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", "2004/11/24 10:31:00");
        UTUtil.setPrivateField(tag, "id", "id");

        PageContext pc = TagUTUtil.getPageContext(tag);
        Exception_PageContextImpl pc2 =
            new Exception_PageContextImpl(
                pc.getServletConfig(),
                pc.getRequest(),
                pc.getResponse());
        //pc2.setNullPointerEx();
        pc2.setIllegalArgumentEx();
        pc2.setTiming(1);
        tag.setPageContext(pc2);

        //eXgs
        try {
            tag.doStartTag();
            // OȂꍇeXg͎sB
            fail();
        } catch (IllegalArgumentException ex) {

            //eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(),
                    ex.getClass().getName());
            return;
        }

    } /* testDoStartTag12 End */

    /**
     * testDoStartTag13B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * value=Not Null(String)<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * bean=*<br>
     * valu2=*<br>
     * id=*<br>
     * filter=*<br>
     * output=*<br>
     * 
     * Ғl
     * ߂l:int=JspTagException<br>
     * pageContextid=-<br>
     * output=-<br>
     * 
     * 擾lValueStrinĝ߁ADate^ւ̕ϊParseExceptionꍇ̃eXgP[X<br>
     */
    public void testDoStartTag13() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", "go to ParseException");

        //eXgs
        try {
            tag.doStartTag();
            // OȂꍇeXg͎sB
            fail();
        } catch (JspTagException ex) {

            //eXgʊmF
            assertTrue(LogUTUtil.checkError("Date parsing error."));
            assertEquals("Unparseable date: \"go to ParseException\"", ex
                    .getMessage());
            return;
        }

    } /* testDoStartTag13 End */

    /**
     * testDoStartTag14B<br>
     * 
     * (n)<br>
     * ϓ_FF<br>
     * 
     * ͒l
     * format="GGG yyyy.MM.dd HH,mm,ss,SSS"<br>
     * value=Null<br>
     * ignore=false<br>
     * name=Not Null<br>
     * property=Not Null<br>
     * scope=l<br>
     * bean=DateFormatterTagBase_BeanStub01
     *      testField=" 2009.01.08 17,00,00,000"<br>
     * valu2=Not Null(String)<br>
     * id=Not Null<br>
     * filter=*<br>
     * output="<DateFormatterTagBaseTest>"<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContextid="<DateFormatterTagBaseTest>"<br>
     * output=-<br>
     * 
     * formatɓtp^[ݒ肳ĂA擾lValuetp^[
     * }b`String̏ꍇADate^֕ϊParseExceptionȂ
     * ƂmFB<br>
     */
    public void testDoStartTag14() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "format", "GGG yyyy.MM.dd HH,mm,ss,SSS");
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "BeanKey");
        UTUtil.setPrivateField(tag, "property", "testField");
        UTUtil.setPrivateField(tag, "scope", "page");
        UTUtil.setPrivateField(tag, "id", "id");
        UTUtil.setPrivateField(tag, "filter", new Boolean(true));

        // DateFormatterTagBase_BeanStub01CX^X̐
        DateFormatterTagBase_BeanStub01 bean = 
            new DateFormatterTagBase_BeanStub01();
        bean.setTestField(" 2009.01.08 17,00,00,000");

        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("BeanKey", bean);
        
        try {
            // eXgs
            int result = tag.doStartTag();

            // eXgʊmF
            assertEquals(Tag.SKIP_BODY, result);
            assertEquals("<DateFormatterTagBaseTest>", pc.getAttribute("id"));
        } catch (JspTagException ex) {
            //OꍇeXg͎sB
            fail();
        }

    } /* testDoStartTag14 End */
    
    /**
     * testRelease01B<br>
     * 
     * (n)<br>
     * ϓ_FC<br>
     * 
     * ͒l
     * id="id"<br>
     * filter=false<br>
     * ignore=true<br>
     * name="name"<br>
     * property="property"<br>
     * scope="scope"<br>
     * pattern="pattern"<br>
     * value="value"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * id=Null<br>
     * filter=true<br>
     * ignore=false<br>
     * name=Null<br>
     * property=Null<br>
     * scope=Null<br>
     * pattern=Null<br>
     * value=Null<br>
     * 
     * OƂĐݒ肵elAsɊel邱ƂmF<br>
     */
    public void testRelease01() throws Exception {
        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "id", "");
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", "name");
        UTUtil.setPrivateField(tag, "property", "property");
        UTUtil.setPrivateField(tag, "scope", "scope");
        UTUtil.setPrivateField(tag, "pattern", "pattern");
        UTUtil.setPrivateField(tag, "value", "value");

        //eXgs
        tag.release();

        //eXgʊmF
        assertNull(UTUtil.getPrivateField(tag, "id"));
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "filter"));
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "ignore"));
        assertNull(UTUtil.getPrivateField(tag, "name"));
        assertNull(UTUtil.getPrivateField(tag, "property"));
        assertNull(UTUtil.getPrivateField(tag, "scope"));
        assertNull(UTUtil.getPrivateField(tag, "pattern"));
        assertNull(UTUtil.getPrivateField(tag, "value"));

    } /* testRelease1 End */

    /**
     * testSetId01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * id="id"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * id="id"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetId01() throws Exception {
        //eXgs
        tag.setId("id");

        //eXgʊmF
        assertEquals("id", UTUtil.getPrivateField(tag, "id"));

    } /* testSetId01 End */
    /**
     * testSetFilter01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * filter=false<br>
     * 
     * Ғl
     * ߂l:void<br>
     * filter=false<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetFilter01() throws Exception {
        //eXgs
        tag.setFilter(false);

        //eXgʊmF
        assertFalse((Boolean) UTUtil.getPrivateField(tag, "filter"));

    } /* testSetFilter01 End */
    /**
     * testSetIgnore01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * ignore=true<br>
     * 
     * Ғl
     * ߂l:void<br>
     * ignore=true<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetIgnore01() throws Exception {
        //eXgs
        tag.setIgnore(true);

        //eXgʊmF
        assertTrue((Boolean) UTUtil.getPrivateField(tag, "ignore"));

    } /* testSetIgnore01 End */
    /**
     * testSetName01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * name="name"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * name="name"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetName01() throws Exception {
        //eXgs
        tag.setName("name");

        //eXgʊmF
        assertEquals("name", UTUtil.getPrivateField(tag, "name"));

    } /* testSetName01 End */
    /**
     * testSetProperty01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * property="property"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * property="property"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetProperty01() throws Exception {
        //eXgs
        tag.setProperty("property");

        //eXgʊmF
        assertEquals("property", UTUtil.getPrivateField(tag, "property"));

    } /* testSetProperty01 End */
    /**
     * testSetScope01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * scope="scope"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * scope="scope"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetScope01() throws Exception {
        //eXgs
        tag.setScope("scope");

        //eXgʊmF
        assertEquals("scope", UTUtil.getPrivateField(tag, "scope"));

    } /* testSetScope01 End */
    /**
     * testSetPattern01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * pattern="pattern"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * pattern="pattern"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetPattern01() throws Exception {
        //eXgs
        tag.setPattern("pattern");

        //eXgʊmF
        assertEquals("pattern", UTUtil.getPrivateField(tag, "pattern"));

    } /* testSetPattern01 End */
    /**
     * testSetValue01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value="value"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * value="value"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetValue01() throws Exception {
        //eXgs
        tag.setValue("value");

        //eXgʊmF
        assertEquals("value", UTUtil.getPrivateField(tag, "value"));

    } /* testSetValue01 End */

    /**
     * testSetFormat01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * format="format"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * format="format"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testSetFormat01() throws Exception {
        //eXgs
        tag.setFormat("format");
    
        //eXgʊmF
        assertEquals("format", UTUtil.getPrivateField(tag, "format"));
    
    } /* testSetFormat01 End */

    /**
     * testGetFormat01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     *  Ȃ<br>
     * O
     * format="format"<br>
     * 
     * Ғl
     * ߂l: format="format"<br>
     * 
     * ZbglmFeXgP[X<br>
     */
    public void testGetFormat01() throws Exception {
        // eXgf[^ݒ
        UTUtil.setPrivateField(tag, "format", "format");
        
        //eXgs
        String fmt = tag.getFormat();
    
        //eXgʊmF
        assertEquals("format", fmt);
    
    } /* testGetFormat01 End */
    
    /**
     * testGetDefaultDateFormat01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     *  Ȃ<br>
     * O Ȃ<br>
     * 
     * Ғl
     * ߂l: "yyyy/MM/dd HH:mm:ss"<br>
     * 
     * n1̂<br>
     */
    public void testGetDefaultDateFormat01() throws Exception {
        // eXgf[^ݒ
        
        //eXgs
        String defaultDataFormat = tag.getDefaultDateFormat();
    
        //eXgʊmF
        assertEquals("yyyy/MM/dd HH:mm:ss", defaultDataFormat);
    
    } /* testGetDefaultDateFormat01 End */
} /* DateFormatterTagBaseTest Class End */
