/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.authentication.web;

import java.util.List;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.thin.functionsample.common.FunctionUVO;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.UserValueObject;
import jp.terasoluna.fw.web.thin.AuthenticationController;

/**
 * @\ԗTvAP̃OIς݃`FbNRg[
 * 
 */
public class FunctionAuthenticationController
implements AuthenticationController {

    /**
     * ONXB
     */
    private Log log =
        LogFactory.getLog(FunctionAuthenticationController.class);
    
    /**
     * OIς݃`FbNΏۊOpX
     */
    private List<String> listNoCheckRequiredPath = null;
    
    /**
     * F؃`FbNsȂpX̃Xg擾B
     * @return listNoCheckRequiredPath ߂܂B
     */
    public List getListNoCheckRequiredPath() {
        return listNoCheckRequiredPath;
    }

    /**
     * F؃`FbNsȂpX̃Xgݒ肷B
     * @param listNoCheckRequiredPath ݒ肷 listNoCheckRequiredPathB
     */
    public void setListNoCheckRequiredPath(
    		List<String> listNoCheckRequiredPath) {
        this.listNoCheckRequiredPath = listNoCheckRequiredPath;
    }

    /**
     * OIς݃`FbNsB
     * ZbVUVO擾A
     * UserValueObjectZbVɂꍇ̓OIς݂ƂtrueԂB
     * null̏ꍇfalseԂB
     * 
     * @param String pathInfo
     * @param ServletRequest req
     * @return boolean
     */
    public boolean isAuthenticated(String pathInfo, ServletRequest req) {
        
        if (log.isDebugEnabled()) {
            log.debug("isAuthenticated() strated.");
        }
        
        HttpSession session = ((HttpServletRequest) req).getSession();
        FunctionUVO uvo =
            (FunctionUVO) session.getAttribute(
                    UserValueObject.USER_VALUE_OBJECT_KEY);
        
        if (uvo != null) {
            return true;
        }
        
        if (log.isDebugEnabled()) {
            log.debug("isAuthenticated() ended.");
        }
        return false;
    }

    /**
     * OIς݃`FbNKvȂtrueAKvȂȂfalseԂB
     * @param ServletRequest req
     * @return boolean
     */
    public boolean isCheckRequired(ServletRequest req) {
        
        if (log.isDebugEnabled()) {
            log.debug("isCheckRequired() strated.");
        }
        for (String path : listNoCheckRequiredPath) {
            if ((RequestUtil.getPathInfo(req)).equals(path)) {
                return false;
            }
        }
        
        if (log.isDebugEnabled()) {
            log.debug("isCheckRequired() ended.");
        }
        return true;
    }
}