/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.util;

import java.util.Locale;
import jp.terasoluna.fw.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringMessageResources
extends MessageResources {
    private static final long serialVersionUID = 8870342287587564386L;
    private static Log log = LogFactory.getLog(SpringMessageResources.class);
    private static final String ERR_BEAN_EXCEPTION = "errors.message.bean.exception";
    private WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
    private MessageSource messageSource = null;

    public SpringMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        this.initMessageSource();
    }

    public SpringMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        this.initMessageSource();
    }

    private void initMessageSource() {
        if (this.context != null) {
            if (this.config != null && !"".equals(this.config)) {
                try {
                    this.messageSource = (MessageSource)this.context.getBean(this.config, MessageSource.class);
                }
                catch (BeansException e) {
                    if (log.isErrorEnabled()) {
                        StringBuilder mes = new StringBuilder();
                        mes.append(this.config);
                        mes.append(" is not found");
                        mes.append(" or it is not MessageSource instance.");
                        log.error((Object)mes.toString());
                    }
                    throw new SystemException(e, ERR_BEAN_EXCEPTION);
                }
                if (log.isDebugEnabled()) {
                    StringBuilder mes = new StringBuilder();
                    mes.append(this.config);
                    mes.append(" MessageSource is used.");
                    log.debug((Object)mes.toString());
                }
            }
            if (this.messageSource == null) {
                this.messageSource = this.context;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Default MessageSource is used.");
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"ApplicationContext is not found.");
        }
    }

    public String getMessage(Locale locale, String key) {
        if (this.messageSource != null) {
            String retMessage = null;
            try {
                retMessage = this.messageSource.getMessage(key, null, locale);
            }
            catch (NoSuchMessageException e) {
                // empty catch block
            }
            if (retMessage != null) {
                if (log.isDebugEnabled()) {
                    StringBuilder mes = new StringBuilder();
                    mes.append("key:[");
                    mes.append(key);
                    mes.append("] locale:[");
                    mes.append(locale);
                    mes.append("] message:[");
                    mes.append(retMessage);
                    mes.append("]");
                    log.debug((Object)mes.toString());
                }
                return retMessage;
            }
        }
        if (!this.returnNull) {
            StringBuilder mes = new StringBuilder();
            mes.append("???");
            mes.append(this.messageKey(locale, key));
            mes.append("???");
            return mes.toString();
        }
        return null;
    }
}

