/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web;

import java.io.Serializable;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UserValueObject
implements Serializable {
    private static Log log = LogFactory.getLog(UserValueObject.class);
    public static final String USER_VALUE_OBJECT_PROP_KEY = "user.value.object";
    private static final String UVO_CLASS_ERROR = "errors.uvo.class";
    public static final String USER_VALUE_OBJECT_KEY = "USER_VALUE_OBJECT";

    public static UserValueObject createUserValueObject() {
        UserValueObject userValueObject = null;
        String className = PropertyUtil.getProperty(USER_VALUE_OBJECT_PROP_KEY);
        if (className != null) {
            try {
                userValueObject = (UserValueObject)ClassUtil.create(className);
            }
            catch (ClassLoadException e) {
                log.error((Object)("illegal uvo class:" + className), (Throwable)e);
                throw new SystemException((Throwable)e, UVO_CLASS_ERROR, className);
            }
            catch (ClassCastException e) {
                log.error((Object)("illegal uvo class:" + className), (Throwable)e);
                throw new SystemException((Throwable)e, UVO_CLASS_ERROR, className);
            }
        } else {
            log.error((Object)"specify user.value.object.");
            return null;
        }
        return userValueObject;
    }
}

