﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using TERASOLUNA.Fw.Client.Forms;

namespace TutorialClient
{
    /// </summary>
    /// メニュー画面です。
    /// </summary>
    /// <remarks>
    /// 各画面へ画面遷移します。
    /// </remarks>
    public partial class MenuForm : FormBase
    {

        /// <summary>
        /// <see cref="CalcForm"/>クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public MenuForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// フォームロード時に実行されるイベントハンドラです。
        /// </summary>
        /// <remarks>
        /// <para>画面データセットを初期化します。</para>
        /// </remarks>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        private void MenuForm_Load(object sender, EventArgs e)
        {
            string userId = Items["UserId"].ToString();
            userIdLabel.Text = string.Format(
                        Properties.Resources.MENU_MESSAGE, userId);
        }

        /// <summary>
        /// 計算画面ボタン押下時に実行されるイベントハンドラです。
        /// </summary>
        /// <remarks>計算画面へ遷移します。</remarks>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        private void calcButton_Click(object sender, EventArgs e)
        {
            calcFormForwarder.Execute();
        }

        /// <summary>
        /// ファイルアップロード画面ボタン押下時に実行されるイベントハンドラです。
        /// </summary>
        /// <remarks>ファイルアップロード画面へ遷移します。</remarks>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        private void fileUploadButton_Click(object sender, EventArgs e)
        {
            fileUploadFormForwarder.Execute();
        }

        /// <summary>
        /// ファイルダウンロード画面へボタン押下時に実行されるイベントハンドラです。
        /// </summary>
        /// <remarks>ファイルダウンロード画面へ遷移します。</remarks>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        private void fileDownloadButton_Click(object sender, EventArgs e)
        {
            fileDownloadFormForwarder.Execute();
        }
    }
}