﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Common.BLogic;
using TutorialServerWeb.Dto;
using TERASOLUNA.Fw.Web;

namespace TutorialServerWeb.Form
{
    /// <summary>
    /// 計算画面。
    /// </summary>
    public partial class CalcForm : System.Web.UI.Page
    {
        /// <summary>
        /// 初期化イベント。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void Page_Load(object sender, EventArgs e)
        {
            // 何もしない
        }

        /// <summary>
        /// メニュー画面に遷移する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonMenu_Click(object sender, EventArgs e)
        {
            WebUtils.Transit("MenuForm");
        }

        /// <summary>
        /// 掛け算を実行する。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        protected void ButtonCalc_Click(object sender, EventArgs e)
        {
            // ビジネスロジックの生成
            IBLogic blogic = BLogicFactory.CreateBLogic("calc");

            // ビジネスロジック入力クラスの作成
            BLogicParam param = new BLogicParam();

            // ビジネスロジック入力データセットの作成
            CalcParamDataSet paramDataSet = new CalcParamDataSet();
            paramDataSet.CalcParam.AddCalcParamRow(
                Int32.Parse(TextBoxNumberA.Text),
                Int32.Parse(TextBoxNumberB.Text));

            param.ParamData = paramDataSet;

            // ビジネスロジックの実行
            BLogicResult result = blogic.Execute(param);

            // ビジネスロジックの実行に成功した場合
            if (BLogicResult.SUCCESS.Equals(result.ResultString))
            {
                // ビジネスロジック出力データセットの取得
                CalcResultDataSet resultDataSet = (CalcResultDataSet)result.ResultData;

                TextBoxAnswer.Text = resultDataSet.CalcResult[0].Answer.ToString();
            }
        }

    }
}
