using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Web.Controller;
using TERASOLUNA.Fw.Common.BLogic;
using TutorialServerRich.Dto;
using System.IO;
using TERASOLUNA.Fw.Web.BLogic;

namespace TutorialServerRich.BLogic
{
    /// <summary>
    /// _E[hsrWlXWbNłB
    /// </summary>
    [ControllerInfo(RequestType = RequestTypeNames.DOWNLOAD, InputDataSetType = typeof(FileDownloadDs))]
    public class DownloadBLogic : IBLogic
    {
        /// <summary>
        /// t@C_E[h̃fBNgB
        /// </summary>
        private static readonly string DOWNLOAD_FILE_DIRECTORY = "~/File/{0}";

        /// <summary>
        /// t@C_E[hst@CpXԋpB
        /// </summary>
        /// <param name="param">
        /// t@C_E[hst@CێrWlXWbN̓NX
        /// </param>
        /// <returns>
        /// t@C_E[hst@CpXێ<see cref="FileDownloadBLogicResult"/> CX^XB
        /// </returns>
        public BLogicResult Execute(BLogicParam param)
        {
            // t@CpX̐ݒ
            FileDownloadDs fileDownloadDs = param.ParamData as FileDownloadDs;
            string filePath = null;

            if (fileDownloadDs.FileTable.Rows.Count != 0 &&
                !string.IsNullOrEmpty(fileDownloadDs.FileTable[0].FileName))
            {
                filePath = string.Format(DOWNLOAD_FILE_DIRECTORY, fileDownloadDs.FileTable[0].FileName);
                filePath = HttpContext.Current.Server.MapPath(filePath);
            }
            else
            {
                throw new ArgumentException(Properties.Resources.E_NOT_FOUND_BLOGIC_PARAM);
            }

            // t@C݃`FbN
            if (!File.Exists(filePath))
            {
                string message = string.Format(Properties.Resources.E_NOT_FOUND_DOWNLOADFILE, filePath);
                throw new FileNotFoundException(message);
            }

            // _E[ht@C̃pXrWlXWbNʃNXɐݒ
            FileInfo fileInfo = new FileInfo(filePath);
            FileDownloadBLogicResult blogicResult = new FileDownloadBLogicResult(fileInfo);
            return blogicResult;
        }
    }
}
