package download.view;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.web.rich.springmvc.Constants;
import jp.terasoluna.fw.web.rich.springmvc.servlet.view.filedownload.AbstractFileDownloadView;
import sun.misc.BASE64Encoder;
import download.dto.FileDownloadResult;

/**
 * Tv_E[hr[B
 */
public class SampleFileDownloadView extends AbstractFileDownloadView {

    /**
     * X|Xɐݒ肷ARec^CṽL[B
     */
    protected String contentTypeKey = "Content-Disposition";

    /**
     * X|Xɐݒ肷ARec^CṽvtBbNXB
     */
    protected String contentTypePrefix = "attachments;filename=?{0}?B?";

    /**
     * X|Xɐݒ肷ARec^CṽTtBbNXB
     */
    protected String contentTypeSuffix = "?=";
    
    @Override
    protected InputStream getInputStream(Map model, HttpServletRequest request)
            throws IOException {
        FileDownloadResult result = (FileDownloadResult) model
                .get(Constants.RESULT_KEY);
        
        String filePath = result.getDirectoryName() + File.separator
        + result.getFileName();
        
        URL url = Thread.currentThread().getContextClassLoader().getResource(filePath);
        
        return url.openStream();
    }

    /**
     * X|Xwb_ǉB
     * 
     * @param model
     *            ƖWbŇʁB
     * @param request
     *            HTTPNGXgB
     * @param response
     *            HTTPX|XB
     */
    @Override
    protected final void addResponseHeader(Map model,
            HttpServletRequest request, HttpServletResponse response) {
        
        // X|Xwb_ɐݒ肷L[ƒl̃Zbg擾
        Map<String, String> headerMap = createResponseHeaderMap(model, request);

        for (String key : headerMap.keySet()) {
            response.addHeader(key, headerMap.get(key));
        }
    }

    /**
     * X|Xwb_ɒǉL[ƒlAMap`ō쐬B
     * 
     * @param request
     *            HTTPNGXgB
     * @return X|Xwb_ɒǉL[ƒlMapB
     */
    protected Map<String, String> createResponseHeaderMap(Map model, HttpServletRequest request) {

        FileDownloadResult result = (FileDownloadResult) model.get(Constants.RESULT_KEY);
        
        // NCAgɑMt@CprefixservertăX|Xwb_ɐݒ肷B
        String responseHeaderFileName = result.getFileName();
        
        // NGXgŕR[hMꂽꍇ́At@C̃GR[fBOƂĂ̕R[hgpB
        // NGXgŕR[hMȂꍇ́At@C̃GR[fBOƂăT[o̕R[hgpB
        String encoding = null;
        if (request.getCharacterEncoding() != null) {
            encoding = request.getCharacterEncoding();
        } else {
            encoding = System.getProperty("file.encoding");
        }
        
        BASE64Encoder encoder = new BASE64Encoder();
        
        Map<String, String> headerMap = new HashMap<String, String>();
            
        try {
            headerMap.put(contentTypeKey, contentTypePrefix.replace("{0}",
                    encoding)
                    + encoder.encodeBuffer(responseHeaderFileName.getBytes(encoding))
                    + contentTypeSuffix);
        } catch (UnsupportedEncodingException e) {
            String message = "Character encoding is not supported";
            throw new RuntimeException(message, e);
        }
        
        return headerMap;
    }
}