// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.RequestController;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.WebUT.Configuration.RequestController
{
    /// <summary>
    ///TERASOLUNA.Fw.Configuration.RequestControllerConfiguration のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Configuration.RequestControllerConfiguration 単体テストをここに含めます
    ///</summary>
    
    [TestClass()]
    public class RequestControllerConfigurationTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// GetRequestControllerType (string) のテスト
        /// </summary>
        /// <TestTarget>GetRequestControllerType (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイルが正常なこと
        /// 引数に設定ファイルに存在するnameが指定されていること
        /// </TestCondition>
        /// <TestAssertion>引数に対応するtype属性の設定情報が返却されること</TestAssertion>
        [TestMethod()]
        public void TestGetRequestControllerType01()
        {
            string name = "Normal";
            string expected = "TERASOLUNA.Fw.Web.Controller.BLogicRequestController, TERASOLUNA.Fw.Web";
            string actual;

            actual = RequestControllerConfiguration.GetRequestControllerType(name);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetRequestControllerType (string) のテスト
        /// </summary>
        /// <TestTarget>GetRequestControllerType (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイルが正常なこと
        /// 引数に設定ファイルに存在しないnameが指定されていること
        /// </TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestGetRequestControllerType02()
        {
            string name = "Hoge";

            string actual;

            actual = RequestControllerConfiguration.GetRequestControllerType(name);

            Assert.IsNull(actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetRequestControllerType (string) のテスト
        /// </summary>
        /// <TestTarget>GetRequestControllerType (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイルが正常なこと
        /// 引数に設定ファイルに存在しないnameが指定されていること
        /// </TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void TestGetRequestControllerType03()
        {
            string name = "";

            string actual;

            actual = RequestControllerConfiguration.GetRequestControllerType(name);

            Assert.IsNull(actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetRequestControllerType (string) のテスト
        /// </summary>
        /// <TestTarget>GetRequestControllerType (string)</TestTarget>
        /// <TestCondition>
        /// 構成ファイルが正常なこと
        /// 引数にnull指定されていること
        /// </TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestGetRequestControllerType04()
        {
            string name = null;
            string actual;

            try
            {
                actual = RequestControllerConfiguration.GetRequestControllerType(name);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("name", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(RequestControllerConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(RequestControllerConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "name"));
        }
    }
}
