// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.Text;
using System.Web.Configuration;
using TERASOLUNA.Fw.Common.Configuration;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Web.Configuration.ExceptionCode;
using TERASOLUNA.Fw.Web.Configuration.ExceptionTransition;
using TERASOLUNA.Fw.Web.Configuration.Page;
using TERASOLUNA.Fw.Web.Configuration.RequestController;
using TERASOLUNA.Fw.Web.Configuration.Sql;

namespace TERASOLUNA.Fw.Web.Configuration
{
    /// <summary>
    /// Web AvP[V̍\t@CATERASOLUNA񋟂ݒt@C̐ݒ擾܂B
    /// </summary>
    /// <remarks>
    /// ȉ̐ݒt@Cݒ擾܂B
    /// <para>@y[Wݒt@C</para>
    /// <para>AʑJڐݒt@C</para>
    /// <para>BG[ʑJڐݒt@C</para>
    /// <para>CSQLݒt@C</para>
    /// <para>DrWlXWbNݒt@C</para>
    /// <para>ENGXgRg[ݒ</para>
    /// <para>FOR[hݒt@C</para>
    /// </remarks>
    public abstract class TerasolunaWebConfiguration : TerasolunaConfiguration
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(TerasolunaWebConfiguration));

        /// <summary>
        /// sqlConfiguration ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "sqlConfiguration" łB
        /// </remarks>
        private static readonly string SQLCONFIGURAION_SECTION_NAME = "sqlConfiguration";

        /// <summary>
        /// SqlConfigurationSection ێIuWFNgłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private static SqlConfigurationSection _sqlConfigSection = null;

        /// <summary>
        /// pageConfiguration ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "pageConfiguration" łB
        /// </remarks>
        private static readonly string PAGECONFIGURAION_SECTION_NAME = "pageConfiguration";

        /// <summary>
        /// PageConfigurationSection ێIuWFNgłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private static PageConfigurationSection _pageConfigSection = null;

        /// <summary>
        /// ExceptionTransitionConfiguration ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionTransitionConfiguration" łB
        /// </remarks>
        private static readonly string EXCEPTION_TRANSITION_CONFIGURATION_NAME = "exceptionTransitionConfiguration";

        /// <summary>
        /// ExceptionTransitionConfigurationSection ێIuWFNgłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private static ExceptionTransitionConfigurationSection _exceptionTransitConfigSection = null;

        /// <summary>
        /// RequestControllerConfiguration ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "requestControllerConfiguration" łB
        /// </remarks>
        private static readonly string REQUEST_CONTROLLER_CONFIGURATION_NAME = "requestControllerConfiguration";

        /// <summary>
        /// RequestControllerConfigurationSection ێIuWFNgłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private static RequestControllerConfigurationSection _requestControllerConfigSection = null;

        /// <summary>
        /// ExceptionCodeConfiguration ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionCodeConfiguration" łB
        /// </remarks>
        private static readonly string EXCEPTION_CODE_CONFIGURATION_NAME = "exceptionCodeConfiguration";

        /// <summary>
        /// ExceptionTransitionConfigurationSection ێIuWFNgłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private static ExceptionCodeConfigurationSection _exceptionCodeConfigSection = null;

        /// <summary>
        /// bNp̃IuWFNgłB
        /// </summary>
        private static object _syncRoot = new Object();
 
        /// <summary>
        /// <see cref="SqlConfigurationSection"/> IuWFNg擾܂B
        /// </summary>
        /// <remarks>
        /// <seealso cref="WebConfigurationManager.GetSection(string)"/> \bhgpāA<see cref="SqlConfigurationSection"/> IuWFNg擾܂B
        /// </remarks>
        /// <exception cref="ConfigurationErrorsException">
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public static SqlConfigurationSection SqlConfigSection
        {
            get
            {
                if (_sqlConfigSection == null)
                {
                    lock (_syncRoot)
                    {
                        if (_sqlConfigSection == null)
                        {
                            object scsObject = WebConfigurationManager.GetSection(SQLCONFIGURAION_SECTION_NAME);
                            if (scsObject == null)
                            {
                                return null;
                            }

                            SqlConfigurationSection scs = scsObject as SqlConfigurationSection;
                            if(scs == null)
                            {
                                string message = string.Format(
                                    Properties.Resources.E_CONFIGURATION_INVALID_CAST, "SqlConfiguration", scsObject.GetType().FullName);
                                ConfigurationErrorsException exception = new ConfigurationErrorsException(message);
                                if (_log.IsErrorEnabled)
                                {
                                    _log.Error(message, exception);
                                }
                                throw exception;
                            }

                            scs.CreateSqlElements();
                            _sqlConfigSection = scs;
                            if (_log.IsTraceEnabled)
                            {
                                StringBuilder message = new StringBuilder();
                                message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_PARAMETER, "SqlConfiguration", "files"));
                                foreach (FileElement element in scs.Files)
                                {
                                    message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_KEY, "path", element.Path));
                                }
                                _log.Trace(message.ToString().Trim());
                            }
                        }
                    }
                }
                return _sqlConfigSection;
            }
        }

        /// <summary>
        /// PageConfigurationSection IuWFNg擾܂B
        /// </summary>
        /// <remarks>
        /// <seealso cref="WebConfigurationManager.GetSection(string)"/> \bhgpāA<see cref="PageConfigurationSection"/> IuWFNg擾܂B
        /// </remarks>
        /// <exception cref="ConfigurationErrorsException">
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public static PageConfigurationSection PageConfigSection
        {
            get
            {
                if (_pageConfigSection == null)
                {
                    lock (_syncRoot)
                    {
                        if (_pageConfigSection == null)
                        {
                            object pcsObject = WebConfigurationManager.GetSection(PAGECONFIGURAION_SECTION_NAME);
                            if (pcsObject == null)
                            {
                                return null;
                            }

                            PageConfigurationSection pcs = pcsObject as PageConfigurationSection;
                            if(pcs == null)
                            {
                                string message = string.Format(
                                    Properties.Resources.E_CONFIGURATION_INVALID_CAST, "PageConfiguration", pcsObject.GetType().FullName);
                                ConfigurationErrorsException exception = new ConfigurationErrorsException(message);
                                if (_log.IsErrorEnabled)
                                {
                                    _log.Error(message, exception);
                                }
                                throw exception;
                            }

                            pcs.CreatePageElements();
                            _pageConfigSection = pcs;
                            if (_log.IsTraceEnabled)
                            {
                                StringBuilder message = new StringBuilder();
                                message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_PARAMETER, "PageConfiguration", "files"));
                                foreach (FileElement element in pcs.Files)
                                {
                                    message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_KEY, "path", element.Path));
                                }
                                _log.Trace(message.ToString().Trim());
                            }
                        }
                    }
                }
                return _pageConfigSection;
            }
        }

        /// <summary>
        /// ExceptionTransitionConfigurationSection IuWFNg擾܂B
        /// </summary>
        /// <remarks>
        /// <seealso cref="WebConfigurationManager.GetSection(string)"/> \bhgpāA <see cref="ExceptionTransitionConfigurationSection"/> IuWFNg擾܂B
        /// </remarks>
        /// <exception cref="ConfigurationErrorsException">
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public static ExceptionTransitionConfigurationSection ExceptionTransitionConfigSection
        {
            get
            {
                if (_exceptionTransitConfigSection == null)
                {
                    lock (_syncRoot)
                    {
                        if (_exceptionTransitConfigSection == null)
                        {
                            object etcsObject = WebConfigurationManager.GetSection(EXCEPTION_TRANSITION_CONFIGURATION_NAME);
                            if (etcsObject == null)
                            {
                                return null;
                            }

                            ExceptionTransitionConfigurationSection etcs = etcsObject as ExceptionTransitionConfigurationSection;
                            if(etcs == null)
                            {
                                string message = string.Format(
                                    Properties.Resources.E_CONFIGURATION_INVALID_CAST, "ExceptionTransitionConfiguration", etcsObject.GetType().FullName);
                                ConfigurationErrorsException exception = new ConfigurationErrorsException(message);
                                if (_log.IsErrorEnabled)
                                {
                                    _log.Error(message, exception);
                                }
                                throw exception;
                            }

                            etcs.CreateExceptionTransitionElements();
                            _exceptionTransitConfigSection = etcs;
                            if (_log.IsTraceEnabled)
                            {
                                StringBuilder message = new StringBuilder();
                                message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_PARAMETER, "ExceptionCodeConfiguration", "files"));
                                foreach (FileElement element in etcs.Files)
                                {
                                    message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_KEY, "path", element.Path));
                                }
                                _log.Trace(message.ToString().Trim());
                            }
                        }
                    }
                }
                return _exceptionTransitConfigSection;
            }
        }

        /// <summary>
        /// RequestControllerConfigurationSection IuWFNg擾܂B
        /// </summary>
        /// <remarks>
        /// <seealso cref="WebConfigurationManager.GetSection(string)"/> \bhgpāA<see cref="RequestControllerConfigurationSection"/> IuWFNg擾܂B
        /// </remarks>
        /// <exception cref="ConfigurationErrorsException">
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public static RequestControllerConfigurationSection RequestControllerConfigSection
        {
            get
            {
                if (_requestControllerConfigSection == null)
                {
                    lock (_syncRoot)
                    {
                        if (_requestControllerConfigSection == null)
                        {
                            object rccsObject = WebConfigurationManager.GetSection(REQUEST_CONTROLLER_CONFIGURATION_NAME);
                            if (rccsObject == null)
                            {
                                return null;
                            }

                            RequestControllerConfigurationSection rccs = rccsObject as RequestControllerConfigurationSection;
                            if(rccs == null)
                            {
                                string message = string.Format(
                                    Properties.Resources.E_CONFIGURATION_INVALID_CAST, "RequestControllerConfiguration", rccsObject.GetType().FullName);
                                ConfigurationErrorsException exception = new ConfigurationErrorsException(message);
                                if (_log.IsErrorEnabled)
                                {
                                    _log.Error(message, exception);
                                }
                                throw exception;
                            }

                            _requestControllerConfigSection = rccs;
                            if (_log.IsTraceEnabled)
                            {
                                StringBuilder message = new StringBuilder();
                                message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_PARAMETER, "RequestControllerConfiguration", "controllers"));
                                foreach (RequestControllerElement element in rccs.Controllers)
                                {
                                    message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_KEY, element.Name, element.Type));
                                }
                                _log.Trace(message.ToString().Trim());
                            }
                        }
                    }
                }
                return _requestControllerConfigSection;
            }
        }

        /// <summary>
        /// <see cref="ExceptionCodeConfigurationSection"/> IuWFNg擾܂B
        /// </summary>
        /// <remarks>
        /// <seealso cref="WebConfigurationManager.GetSection(string)"/> \bhgpāA<see cref="ExceptionCodeConfigurationSection"/> IuWFNg擾܂B
        /// </remarks>
        /// <exception cref="ConfigurationErrorsException">
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public static ExceptionCodeConfigurationSection ExceptionCodeConfigSection
        {
            get
            {
                if (_exceptionCodeConfigSection == null)
                {
                    lock (_syncRoot)
                    {
                        if (_exceptionCodeConfigSection == null)
                        {
                            object eccsObject = WebConfigurationManager.GetSection(EXCEPTION_CODE_CONFIGURATION_NAME);
                            if (eccsObject == null)
                            {
                                return null;
                            }

                            ExceptionCodeConfigurationSection eccs = eccsObject as ExceptionCodeConfigurationSection;
                            if(eccs == null)
                            {
                                string message = string.Format(
                                    Properties.Resources.E_CONFIGURATION_INVALID_CAST, "ExceptionCodeConfiguration", eccsObject.GetType().FullName);
                                ConfigurationErrorsException exception = new ConfigurationErrorsException(message);
                                if (_log.IsErrorEnabled)
                                {
                                    _log.Error(message, exception);
                                }
                                throw exception;
                            }

                            eccs.CreateExceptionCodeElements();
                            _exceptionCodeConfigSection = eccs;
                            if (_log.IsTraceEnabled)
                            {
                                StringBuilder message = new StringBuilder();
                                message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_PARAMETER, "ExceptionCodeConfiguration", "files"));
                                foreach (FileElement element in eccs.Files)
                                {
                                    message.AppendLine(string.Format(Properties.Resources.T_CONFIGURATION_LOAD_KEY, "path", element.Path));
                                }
                                _log.Trace(message.ToString().Trim());
                            }
                        }
                    }
                }
                return _exceptionCodeConfigSection;
            }
        }

    }
}
