﻿// <著作権>
// Copyright (c) 2007, NTT DATA Corporation.
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Reflection;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    /// NumberValidator のテストクラスです。
    /// </summary>
    [TestClass()]
    public class NumberValidatorTest
    {
        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest()
        {
            int intLength = 2;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = true;

            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);


            Assert.AreEqual<string>(val, accessor.DefaultNegatedMessageTemplate, "プロパティの値が不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest()
        {
            int intLength = 2;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);


            Assert.AreEqual<string>(val, accessor.DefaultNonNegatedMessageTemplate, "プロパティの値が不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// IntegerLengthプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void IntegerLengthTest()
        {

            // 準備
            int intLength = 2;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength , isIntAcc, scale , isScaleAcc,messageTemplate , tag , negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            // 確認
            Assert.AreEqual<int>(2, accessor._integerLength);
            Assert.AreEqual<int>(2, target.IntegerLength);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// IsAccordedIntegerプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void IsAccordedIntegerTest()
        {
            // 準備
            int intLength = 2;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            // 確認
            Assert.IsFalse(accessor._isAccordedInteger);
            Assert.IsFalse(target.IsAccordedInteger);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// IsAccordedScaleプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void IsAccordedScaleTest()
        {
            // 準備
            int intLength = 2;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            // 確認
            Assert.IsFalse(accessor._isAccordedScale);
            Assert.IsFalse(target.IsAccordedScale);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// Scaleプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ScaleTest()
        {
            // 準備
            int intLength = 2;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            // 確認
            Assert.AreEqual<int>(1, accessor._scale);
            Assert.AreEqual<int>(1, target.Scale);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest01()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);
            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = null;

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字の場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest02()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(整数)の場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest03()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)の場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest04()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)の場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest05()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です。");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です。");
            Assert.IsNull(r.Key, "Keyが不正です。");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です。");
            Assert.IsNull(r.Target, "Targetが不正です。");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが非数値形式の場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest06()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1.2.3";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが非文字列の場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest07()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = DateTime.Today;

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// currentTargetが非nullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest08()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = "オブジェクト";
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual<string>(r.Target.ToString(), "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// currentTargetが非nullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest09()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = "オブジェクト";
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// keyが非nullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest10()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = "キー";
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// keyが非nullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest11()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = "キー";
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// ValidationResultsがnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest12()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = null;

            // 確認
            try
            {
                accessor.DoValidate(objectToValidate, currentTarget, key, results);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentNullException));
                ArgumentNullException exception = e.InnerException as ArgumentNullException;
                Assert.AreEqual("validationResults", exception.ParamName);
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));    
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(NumberValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "validationResults"));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// ValidationResultsがnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest13()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = null;
     
            // 確認
            try
            {
                accessor.DoValidate(objectToValidate, currentTarget, key, results);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentNullException));
                ArgumentNullException exception = e.InnerException as ArgumentNullException;
                Assert.AreEqual("validationResults", exception.ParamName);
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(NumberValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "validationResults"));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// ValidationResultsの検証エラーが1つの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest14()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            results.AddResult(new ValidationResult("result01", null, null, null, null));

            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(2, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// ValidationResultsの検証エラーが1つの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest15()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            results.AddResult(new ValidationResult("result01", null, null, null, null));

            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// validationResultsの検証エラーが3つの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest16()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            results.AddResult(new ValidationResult("result01", null, null, null, null));
            results.AddResult(new ValidationResult("result02", null, null, null, null));
            results.AddResult(new ValidationResult("result03", null, null, null, null));

            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(4, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r2 = resultList.FindFromMessage("result02");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r3 = resultList.FindFromMessage("result03");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// validationResultsの検証エラーが3つの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest17()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            results.AddResult(new ValidationResult("result01", null, null, null, null));
            results.AddResult(new ValidationResult("result02", null, null, null, null));
            results.AddResult(new ValidationResult("result03", null, null, null, null));

            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(3, resultList.Count, "エラー数が不正です.");
            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r2 = resultList.FindFromMessage("result02");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r3 = resultList.FindFromMessage("result03");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// プロパティのNegatedがtrueの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest18()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = true;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// プロパティのNegatedがtrueの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest19()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = true;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// プロパティのintegerLengthが正常値1の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest20()
        {
            // 準備
            int intLength = 1;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 1, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// プロパティのintegerLengthが正常値1の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest21()
        {
            // 準備
            int intLength = 1;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 1, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// プロパティのisAccordedIntegerがtrueの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest22()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = true;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(整数)であり、
        /// プロパティのscaleが正常値0の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest23()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 0;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// プロパティのscaleが正常値3の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest24()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 1, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// プロパティのisAccordedScaleがtrueの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest25()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = true;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲内)であり、
        /// プロパティのMessageTemplateが空文字の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest26()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = "";
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// プロパティのMessageTemplateがプレースホルダ0～4の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest27()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = "{0},{1},{2},{3},{4}";
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("1234.5678,,試験対象項目,3,1");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// プロパティのMessageTemplateがプレースホルダ0～5の場合、
        /// FormatExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest28()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 1;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = "{0},{1},{2},{3},{4},{5}";
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";
            ValidationResults results = new ValidationResults();
  
            // 実施
            try
            {
                accessor.DoValidate(objectToValidate, currentTarget, key, results);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(FormatException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));    
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが数値形式(範囲外)であり、
        /// プロパティのTagがnullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest29()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "1234.5678";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", tag, 3, 3, "{5}" };
            string expectedMessage = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが正常値であり、
        /// プロパティのisAccordedIntegerがtrueの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest30()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = true;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "123.34";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが正常値であり、
        /// プロパティのisAccordedScaleがtrueの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest31()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = true;
            string tag = "試験対象項目";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 実施
            string key = null;
            object currentTarget = null;
            object objectToValidate = "12.345";

            ValidationResults results = new ValidationResults();
            accessor.DoValidate(objectToValidate, currentTarget, key, results);
            ValidationResultList resultList = new ValidationResultList(results);

            // 確認
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }


        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のintegerLengthが異常値-3の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest01()
        {
            // 準備
            int intLength = -3;
            bool isIntAcc = false;
            int scale = 0;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = null;
            bool negated = false;
     
            // 生成
            try
            {
                NumberValidator target =
                  new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_ZERO_AND_NEGATIVE_NUMBER", "integerLength"), e.Message);
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(NumberValidator), typeof(ArgumentException), "E_ZERO_AND_NEGATIVE_NUMBER", "integerLength"));
        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のintegerLengthが異常値0の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest02()
        {
            // 準備
            int intLength = 0;
            bool isIntAcc = false;
            int scale = 0;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = null;
            bool negated = false;  

            // 生成
            try
            {
                NumberValidator target =
                  new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_ZERO_AND_NEGATIVE_NUMBER", "integerLength"), e.Message);
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(NumberValidator), typeof(ArgumentException), "E_ZERO_AND_NEGATIVE_NUMBER", "integerLength"));
        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のintegerLengthが正常値の場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest03()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 0;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 確認

            Assert.IsFalse(accessor._isAccordedScale);
            Assert.IsFalse(target.IsAccordedScale);

            Assert.AreEqual<int>(0, accessor._scale);
            Assert.AreEqual<int>(0, target.Scale);

            Assert.IsFalse(accessor._isAccordedInteger);
            Assert.IsFalse(target.IsAccordedInteger);

            Assert.AreEqual<int>(3, accessor._integerLength);
            Assert.AreEqual<int>(3, target.IntegerLength);

            Assert.IsNull(target.Tag);

            Assert.IsFalse(target.Negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, target.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のisAccordedIntegerがtrueの場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest04()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = true;
            int scale = 0;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 確認

            Assert.IsFalse(accessor._isAccordedScale);
            Assert.IsFalse(target.IsAccordedScale);

            Assert.AreEqual<int>(0, accessor._scale);
            Assert.AreEqual<int>(0, target.Scale);

            Assert.IsTrue(accessor._isAccordedInteger);
            Assert.IsTrue(target.IsAccordedInteger);

            Assert.AreEqual<int>(3, accessor._integerLength);
            Assert.AreEqual<int>(3, target.IntegerLength);

            Assert.IsNull(target.Tag);

            Assert.IsFalse(target.Negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, target.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のscaleが異常値-3の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest05()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = -3;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = null;
            bool negated = false;

            // 生成
            try
            {
                NumberValidator target =
                  new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_NEGATIVE_NUMBER", "scale"), e.Message);
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(NumberValidator), typeof(ArgumentException), "E_NEGATIVE_NUMBER", "scale"));   
        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のscaleが正常値の場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest06()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 3;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 確認

            Assert.IsFalse(accessor._isAccordedScale);
            Assert.IsFalse(target.IsAccordedScale);

            Assert.AreEqual<int>(3, accessor._scale);
            Assert.AreEqual<int>(3, target.Scale);

            Assert.IsFalse(accessor._isAccordedInteger);
            Assert.IsFalse(target.IsAccordedInteger);

            Assert.AreEqual<int>(3, accessor._integerLength);
            Assert.AreEqual<int>(3, target.IntegerLength);

            Assert.IsNull(target.Tag);

            Assert.IsFalse(target.Negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, target.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      

        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のisAccordedScaleがtrueの場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest07()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 0;
            bool isScaleAcc = true;
            string tag = null;
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 確認

            Assert.IsTrue(accessor._isAccordedScale);
            Assert.IsTrue(target.IsAccordedScale);

            Assert.AreEqual<int>(0, accessor._scale);
            Assert.AreEqual<int>(0, target.Scale);

            Assert.IsFalse(accessor._isAccordedInteger);
            Assert.IsFalse(target.IsAccordedInteger);

            Assert.AreEqual<int>(3, accessor._integerLength);
            Assert.AreEqual<int>(3, target.IntegerLength);

            Assert.IsNull(target.Tag);

            Assert.IsFalse(target.Negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, target.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      

        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のNegatedがtrueの場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest08()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 0;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = null;
            bool negated = true;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 確認

            Assert.IsFalse(accessor._isAccordedScale);
            Assert.IsFalse(target.IsAccordedScale);

            Assert.AreEqual<int>(0, accessor._scale);
            Assert.AreEqual<int>(0, target.Scale);

            Assert.IsFalse(accessor._isAccordedInteger);
            Assert.IsFalse(target.IsAccordedInteger);

            Assert.AreEqual<int>(3, accessor._integerLength);
            Assert.AreEqual<int>(3, target.IntegerLength);

            Assert.IsNull(target.Tag);

            Assert.IsTrue(target.Negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, target.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      

        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のMessageTemplateが非nullの場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest09()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 0;
            bool isScaleAcc = false;
            string tag = null;
            string messageTemplate = "aaa";
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 確認

            Assert.IsFalse(accessor._isAccordedScale);
            Assert.IsFalse(target.IsAccordedScale);

            Assert.AreEqual<int>(0, accessor._scale);
            Assert.AreEqual<int>(0, target.Scale);

            Assert.IsFalse(accessor._isAccordedInteger);
            Assert.IsFalse(target.IsAccordedInteger);

            Assert.AreEqual<int>(3, accessor._integerLength);
            Assert.AreEqual<int>(3, target.IntegerLength);

            Assert.IsNull(target.Tag);

            Assert.IsFalse(target.Negated);
            Assert.AreEqual<string>("aaa",target.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      

        }

        /// <summary>
        /// NumberValidator (int, bool, int, bool, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のTagが非nullの場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void NumberValidator_ctorTest10()
        {
            // 準備
            int intLength = 3;
            bool isIntAcc = false;
            int scale = 0;
            bool isScaleAcc = false;
            string tag = "aaa";
            string messageTemplate = null;
            bool negated = false;

            // 生成
            NumberValidator target =
              new NumberValidator(intLength, isIntAcc, scale, isScaleAcc, messageTemplate, tag, negated);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_NumberValidatorAccessor(target);

            // 確認

            Assert.IsFalse(accessor._isAccordedScale);
            Assert.IsFalse(target.IsAccordedScale);

            Assert.AreEqual<int>(0, accessor._scale);
            Assert.AreEqual<int>(0, target.Scale);

            Assert.IsFalse(accessor._isAccordedInteger);
            Assert.IsFalse(target.IsAccordedInteger);

            Assert.AreEqual<int>(3, accessor._integerLength);
            Assert.AreEqual<int>(3, target.IntegerLength);

            Assert.AreEqual<string>("aaa",target.Tag);

            Assert.IsFalse(target.Negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(val, target.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NumberValidator), LogLevel.INFO));      

        }
    }
}
