// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Globalization;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Common.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common.Validation.Configuration;

namespace TERASOLUNA.Fw.Common.Validation.Validators
{
    /// <summary>
    /// ؃[" byte 񒷔͈̓`FbN"ɑΉoCg͈̓`FbNs <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> pNXłB
    /// </summary>
    /// <remarks>
    /// <para>
    /// ؑΏۂ̕w肵GR[hŃoCgɕϊAoCgw肵͈
    /// Ɋ܂܂邱Ƃ`FbN錟؋@\񋟂܂B
    /// </para>
    /// <para>
    /// {NXpē͒l؂{ɂ́A͒lؐݒt@CɋLq
    ///  validator vf̑ƂāAȉ̐ݒs܂B
    /// ͒lؐݒt@Ĉ̋L@ɂẮA
    ///  Validation Application Block ̃hLgQƂĂB 
    /// </para>
    /// <para>
    /// <list type="bullet">
    /// <item>
    /// <description>negated</description>
    /// <para>؃[𔽓]tOłB true ݒ肵ꍇA؃[]܂BftHgĺA false łB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplate</description>
    /// <para>؃G[bZ[W̃ev[gƂĎgp镶B
    /// ݒ̏ꍇ́A<see cref="ByteRangeValidator.DefaultNonNegatedMessageTemplate"/> A <see cref="ByteRangeValidator.DefaultNegatedMessageTemplate"/>  
    /// ꂩgp܂B
    /// </para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceName</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̖OB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceType</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̃\[X̌^B</para>
    /// </item>
    /// <item>
    /// <description>tag</description>
    /// <para>bZ[Wev[g̃v[Xz_{2}ɓn镶B
    /// ؑΏۍڂ̘_w肵܂B</para>
    /// </item>
    /// <item>
    /// <description>type</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> NX̌^SC^Ŏw肵܂B</para>
    /// </item>
    /// <item>
    /// <description>name</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ̖OłBt[[Nł͗p܂B
    /// ɕ <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> 𗘗p؂sꍇAdOgp
    /// Ƃ͂ł܂B͕̑K{ڂłB</para>
    /// </item>
    /// <item>
    /// <description>minByteLength</description>
    /// <para>oCg̍ŏl܂B͈͂ɂ͎w肵lg܂܂܂B
    ///  0 ̒lw肵ꍇAsOƂȂ܂B</para>
    /// </item>
    /// <item>
    /// <description>maxByteLength</description>
    /// <para>oCg̍ől܂B͈͂ɂ͎w肵lg܂܂܂B
    ///  2,147,483,647 𒴂lw肵ꍇAsOƂȂ܂B</para>
    /// </item>
    /// <item>
    /// <description>encoding</description>
    /// <para>oCgɕϊۂɗpGR[h`w肵܂B
    /// R[hy[Wł̎w͂ł܂B
    /// płGR[h`̖̂ɂẮA<see cref="System.Text.Encoding"/> 
    /// hLgQƂĂB</para>
    /// </item>
    /// </list>
    /// </para>
    /// <example>
    /// <code>
    /// &lt;validator negated="false" minByteLength="10" maxByteLength="200" encoding="shift_jis"
    /// messageTemplate="" messageTemplateResourceName=""
    /// messageTemplateResourceType="" tag="ؑΏۍږ" name="byte range validator" 
    /// type="TERASOLUNA.Fw.Common.Validation.Validators.ByteRangeValidator,TERASOLUNA.Fw.Common"/&gt;
    /// </code>
    /// </example>
    /// </remarks>
    [ConfigurationElementType(typeof(ByteRangeValidatorData))]
    public class ByteRangeValidator : TypeRangeValidator<int>
    {
        /// <summary>
        /// oCg̍ŏlłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA 0 łB
        /// </remarks>
        private int _minByteLength = 0;

        /// <summary>
        /// oCg̍őlłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA 0 łB
        /// </remarks>
        private int _maxByteLength = 0;

        /// <summary>
        /// GR[fBOB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private Encoding _encoding = null;

        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ByteRangeValidator));

        /// <summary>
        /// RXgN^łBV <see cref="ByteRangeValidator"/> ̃CX^X܂B
        /// </summary>
        /// <param name="messageTemplate"> ؎s̍ہAbZ[W𐶐邽߂ɗpev[gB
        /// ؂ɗpp[^v[Xz_ɓn܂B
        /// p[^Ƃ̃v[Xz_ԍ͈ȉ̒ʂłB
        /// <list type="table">
        /// <listheader>
        /// <term>v[Xz_</term>
        /// <description>e</description>
        /// </listheader>
        /// <item>
        /// <term>{0}</term>
        /// <description>ؑΏە</description>
        /// </item>
        /// <item>
        /// <term>{1}</term>
        /// <description>key(vpeBE\bh)</description>
        /// </item>
        /// <item>
        /// <term>{2}</term>
        /// <description>Tag</description>
        /// </item>
        /// <item>
        /// <term>{3}</term>
        /// <description>̌</description>
        /// </item>
        /// <item>
        /// <term>{4}</term>
        /// <description>̌</description>
        /// </item>
        /// </list>
        /// </param>
        /// <param name="tag">ؑΏۂ̍ږB</param>
        /// <param name="negated">؏̔]tOB</param>
        /// <param name="encodingName">oCgɕϊۗpGR[hB</param>
        /// <param name="minByteLength">oCg̍ŏlB</param>
        /// <param name="maxByteLength">oCg̍őlB</param>
        /// <exception cref="ArgumentException">
        /// <list type="bullet">
        /// <item>
        /// <paramref name="minByteLength"/>  0 ȉłB
        /// </item>
        /// <item>
        /// <paramref name="maxByteLength"/>  <paramref name="minByteLength"/> ȉłB
        /// </item>
        /// <item>
        /// <paramref name="encodingName"/> 󕶎łB
        /// </item>
        /// <item>
        /// <paramref name="encodingName"/> LȃGR[hłȂꍇB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentNullException">
        /// <list type="bullet">
        /// <item>
        /// <paramref name="encodingName"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        public ByteRangeValidator(int minByteLength,
                                  int maxByteLength,
                                  string encodingName,
                                  string messageTemplate,
                                  string tag,
                                  bool negated)
            : base(minByteLength, RangeBoundaryType.Inclusive,
                   maxByteLength, RangeBoundaryType.Inclusive, messageTemplate, negated)
        {
            if (minByteLength < 0)
            {
                string message = string.Format(Properties.Resources.E_NEGATIVE_NUMBER, "minByteLength");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            if (encodingName == null)
            {
                ArgumentNullException exception = new ArgumentNullException("encodingName");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "encodingName"), exception);
                }
                throw exception;
            }

            if (encodingName.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "encodingName");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            try
            {
                _encoding = Encoding.GetEncoding(encodingName);
            }
            catch (ArgumentException e)
            {
                string message = string.Format(Properties.Resources.E_INVALID_ARGUMENT, "encodingName");
                ArgumentException exception = new ArgumentException(message, e);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            if (!string.IsNullOrEmpty(tag))
            {
                this.Tag = tag;
            }
            _minByteLength = minByteLength;
            _maxByteLength = maxByteLength;
        }


        /// <summary>
        /// oCg̍ŏl\ int l擾܂B
        /// </summary>
        /// <value>oCg̍ŏlB</value>
        public int MinByteLength
        {
            get { return _minByteLength; }
        }


        /// <summary>
        /// oCg̍ől\ int l擾܂B
        /// </summary>
        /// <value>oCg̍őlB</value>
        public int MaxByteLength
        {
            get { return _maxByteLength; }
        }

        /// <summary>
        /// oCgzɕϊۗpGR[h擾܂B
        /// </summary>
        /// <value>GR[hB</value>
        public Encoding Encoding
        {
            get { return _encoding; }
        }

        /// <summary>
        /// <seealso cref="ValueValidator.Negated"/>@ true łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>؃[]̃ftHgbZ[Wev[gB</value>
        protected override string DefaultNegatedMessageTemplate
        {
            get
            {
                return Properties.Resources.BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE;
            }
        }

        /// <summary>
        /// <seealso cref="ValueValidator.Negated"/>  false łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>ftHgbZ[Wev[gB</value>
        protected override string DefaultNonNegatedMessageTemplate
        {
            get
            {
                return Properties.Resources.BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE;
            }
        }

        /// <summary>
        /// ؃G[bZ[W𐶐郁\bhłB <seealso cref="Validator.MessageTemplate"/> ev[gƂA
        /// ݂̃J`ɏ]ĕtH[}bg܂B
        /// </summary>
        /// <remarks>
        /// <para>tH[}bgɊ܂܂v[Xz_ɓńAȉ̒ʂłB
        /// <list type="table">
        /// <listheader>
        /// <term>v[Xz_</term>
        /// <description>e</description>
        /// </listheader>
        /// <item>
        /// <term>{0}</term>
        /// <description>ؑΏە</description>
        /// </item>
        /// <item>
        /// <term>{1}</term>
        /// <description>key(vpeBE\bh)</description>
        /// </item>
        /// <item>
        /// <term>{2}</term>
        /// <description>Tag</description>
        /// </item>
        /// <item>
        /// <term>{3}</term>
        /// <description>oCg̍ŏl</description>
        /// </item>
        /// <item>
        /// <term>{4}</term>
        /// <description>oCg̍ől</description>
        /// </item>
        /// <item>
        /// <term>{5}</term>
        /// <description>GR[h</description>
        /// </item>
        /// </list>
        /// </para>
        /// </remarks>
        /// <exception cref="FormatException">
        /// <seealso cref="Validator.MessageTemplate"/> ̃v[Xz_ 6 ȏłB
        /// </exception>
        /// <param name="objectToValidate">ؑΏۂ̃IuWFNgB</param>
        /// <param name="key">IuWFNg擾vpeB܂̓\bhB</param>
        /// <returns>؃G[bZ[WB</returns>
        protected override string GetMessage(object objectToValidate, string key)
        {
            return string.Format(CultureInfo.CurrentUICulture,
                this.MessageTemplate,
                objectToValidate,
                key,
                this.Tag,
                MinByteLength,
                MaxByteLength,
                this.Encoding.WebName);
        }

        /// <summary>
        /// byte 񒷔͈̓`FbNs\bhłBؑΏےl̕\A
        /// oCgz񒷂w͈͓Ɏ܂ĂȂꍇA؎sƂȂ܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="objectToValidate"/>  null ̏ꍇA؏͍s܂B
        /// </para>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <list type="bullet">
        /// <item>
        /// <paramref name="validationResults"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <param name="objectToValidate">ؑΏۂ̒lB</param>
        /// <param name="currentTarget">ؑΏۂ̃IuWFNgB</param>
        /// <param name="key">ؑΏۂ̃vpeB܂̓\bhB</param>
        /// <param name="validationResults">،ʂi[ <see cref="ValidationResults"/> B</param>
        protected override void DoValidate(object objectToValidate,
                                           object currentTarget,
                                           string key,
                                           ValidationResults validationResults)
        {
            if (validationResults == null)
            {
                ArgumentNullException exception = new ArgumentNullException("validationResults");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "validationResults"), exception);
                }
                throw exception;
            }

            if (objectToValidate == null)
            {
                return;
            }

            string objectToValidateString = objectToValidate as string;
            if (objectToValidateString == null)
            {
                LogValidationResult(validationResults, GetMessage(objectToValidate, key), currentTarget, key);
            }
            else
            {
                byte[] bytes = _encoding.GetBytes(objectToValidateString);
                base.DoValidate(bytes.Length, currentTarget, key, validationResults);
            }
        }
    }
}