// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client;
using System.Collections;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Utlib.Logging;
namespace TERASOLUNA.Fw.ClientUT
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.ExecuteProgressChangedEventArgs のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.ExecuteProgressChangedEventArgs 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ExecuteProgressChangedEventArgsTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// ExecuteProgressChangedEventArgs (int) のテスト
        ///</summary>
        /// <remarks>
        /// コンストラクタで値が正常に設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備
            int expectedProgressPercentage = -1;

            // 実施
            ExecuteProgressChangedEventArgs target = new ExecuteProgressChangedEventArgs(expectedProgressPercentage);

            // 確認
            Assert.AreEqual(expectedProgressPercentage, target.ProgressPercentage);

            // ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExecuteProgressChangedEventArgs), LogLevel.INFO));
        }

        /// <summary>
        /// ExecuteProgressChangedEventArgs (int) のテスト
        ///</summary>
        /// <remarks>
        /// コンストラクタで値が正常に設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest02()
        {
            // 準備
            int expectedProgressPercentage = 0;

            // 実施
            ExecuteProgressChangedEventArgs target = new ExecuteProgressChangedEventArgs(expectedProgressPercentage);

            // 確認
            Assert.AreEqual(expectedProgressPercentage, target.ProgressPercentage);

            // ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExecuteProgressChangedEventArgs), LogLevel.INFO));
        }

        /// <summary>
        /// ExecuteProgressChangedEventArgs (int) のテスト
        ///</summary>
        /// <remarks>
        /// コンストラクタで値が正常に設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest03()
        {
            // 準備
            int expectedProgressPercentage = 100;

            // 実施
            ExecuteProgressChangedEventArgs target = new ExecuteProgressChangedEventArgs(expectedProgressPercentage);

            // 確認
            Assert.AreEqual(expectedProgressPercentage, target.ProgressPercentage);

            // ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExecuteProgressChangedEventArgs), LogLevel.INFO));
        }

        /// <summary>
        /// ExecuteProgressChangedEventArgs (int) のテスト
        ///</summary>
        /// <remarks>
        /// コンストラクタで値が正常に設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest04()
        {
            // 準備
            int expectedProgressPercentage = 101;

            // 実施
            ExecuteProgressChangedEventArgs target = new ExecuteProgressChangedEventArgs(expectedProgressPercentage);

            // 確認
            Assert.AreEqual(expectedProgressPercentage, target.ProgressPercentage);

            // ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExecuteProgressChangedEventArgs), LogLevel.INFO));
        }

        /// <summary>
        /// Items のテスト
        ///</summary>
        /// <remarks>
        /// 想定通りの値の取得ができることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ItemsTest()
        {
            // 準備
            IDictionary expectedItems = new Dictionary<string, string>();
            ExecuteProgressChangedEventArgs target = new ExecuteProgressChangedEventArgs(100);
            TERASOLUNA_Fw_Client_ExecuteProgressChangedEventArgsAccessor accessor = new TERASOLUNA_Fw_Client_ExecuteProgressChangedEventArgsAccessor(target);
            accessor._items = expectedItems;

            // 実施
            IDictionary actualItems = target.Items;

            // 確認
            Assert.AreSame(expectedItems, actualItems);

            // ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExecuteProgressChangedEventArgs), LogLevel.INFO));
        }
    }
}
