// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Client.Forms;
using System.ComponentModel;
using System.Data;
using System.Collections;
using TERASOLUNA.Fw.Client.BLogic;
using System.Configuration;
using System.Reflection;
using System.Collections.Specialized;
using System.Windows.Forms;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common.Validation;
namespace TERASOLUNA.Fw.ClientUT
{
    /// <summary>
    /// EventController のテストクラスです。
    /// </summary>
    [TestClass()]
    public class EventControllerTest
    {
        private TestContext testContextInstance;

        #region BLogicFailed
        /// <summary>
        /// target_BLogicFailed03の呼び出しフラグです。
        /// </summary>
        private bool _blogicFailedCalled01 = false;

        /// <summary>
        /// target_BLogicFailed03の引数です。
        /// </summary>
        private BLogicFailedEventArgs _blogicFailedArgs01 = null;

        /// <summary>
        /// target_BLogicFailed04の呼び出しフラグです。
        /// </summary>
        private bool _blogicFailedCalled02 = false;

        /// <summary>
        /// target_BLogicFailed04の引数です。
        /// </summary>
        private BLogicFailedEventArgs _blogicFailedArgs02 = null;

        /// <summary>
        /// target_BLogicFailed03の呼び出しフラグです。
        /// </summary>
        private bool _blogicFailedCalled03 = false;

        /// <summary>
        /// target_BLogicFailed03の引数です。
        /// </summary>
        private BLogicFailedEventArgs _blogicFailedArgs03 = null;

        #endregion

        #region CustomValidating

        /// <summary>
        /// target_CustomValidating03の呼び出しフラグです。
        /// </summary>
        private bool _customValidatingCalled01 = false;

        /// <summary>
        /// target_CustomValidating03の引数です。
        /// </summary>
        private CustomValidatingEventArgs _customValidatingArgs01 = null;

        /// <summary>
        /// target_CustomValidating04の呼び出しフラグです。
        /// </summary>
        private bool _customValidatingCalled02 = false;

        /// <summary>
        /// target_CustomValidating04の引数です。
        /// </summary>
        private CustomValidatingEventArgs _customValidatingArgs02 = null;

        /// <summary>
        /// target_CustomValidating03の呼び出しフラグです。
        /// </summary>
        private bool _customValidatingCalled03 = false;

        /// <summary>
        /// target_CustomValidating03の引数です。
        /// </summary>
        private CustomValidatingEventArgs _customValidatingArgs03 = null;

        #endregion

        #region ExecuteCompleted

        /// <summary>
        /// target_ExecuteCompleted04の呼び出しフラグです。
        /// </summary>
        private bool _eventCompletedCalled01 = false;

        /// <summary>
        /// target_ExecuteCompleted04の引数です。
        /// </summary>
        private ExecuteCompletedEventArgs _eventCompletedArgs01 = null;

        /// <summary>
        /// target_ExecuteCompleted06の呼び出しフラグです。
        /// </summary>
        private bool _eventCompletedCalled02 = false;

        /// <summary>
        /// target_ExecuteCompleted06の引数です。
        /// </summary>
        private ExecuteCompletedEventArgs _eventCompletedArgs02 = null;

        /// <summary>
        /// target_ExecuteCompleted03の呼び出しフラグです。
        /// </summary>
        private bool _eventCompletedCalled03 = false;

        /// <summary>
        /// target_ExecuteCompleted03の引数です。
        /// </summary>
        private ExecuteCompletedEventArgs _eventCompletedArgs03 = null;

        #endregion

        #region ExecuteProgressChanged

        /// <summary>
        /// target_ExecuteProgressChanged01 の呼び出しフラグです。
        /// </summary>
        private bool _eventProgressChangedCalled01 = false;

        /// <summary>
        /// target_ExecuteProgressChanged01 の引数です。
        /// </summary>
        private ExecuteProgressChangedEventArgs _eventProgressChangedArgs01 = null;

        /// <summary>
        /// target_ExecuteProgressChanged02 の呼び出しフラグです。
        /// </summary>
        private bool _eventProgressChangedCalled02 = false;

        /// <summary>
        /// target_ExecuteProgressChanged02 の引数です。
        /// </summary>
        private ExecuteProgressChangedEventArgs _eventProgressChangedArgs02 = null;

        /// <summary>
        /// target_ExecuteProgressChanged03の呼び出しフラグです。
        /// </summary>
        private bool _eventProgressChangedCalled03 = false;

        /// <summary>
        /// target_ExecuteProgressChanged03 の引数です。
        /// </summary>
        private ExecuteProgressChangedEventArgs _eventProgressChangedArgs03 = null;

        /// <summary>
        /// target_ExecuteProgressChanged04の呼び出しフラグです。
        /// </summary>
        private bool _eventProgressChangedCalled04 = false;

        /// <summary>
        /// target_ExecuteProgressChanged05の呼び出しフラグです。
        /// </summary>
        private bool _eventProgressChangedCalled05 = false;

        /// <summary>
        /// target_ExecuteProgressChanged06の呼び出しフラグです。
        /// </summary>
        private bool _eventProgressChangedCalled06 = false;

        /// <summary>
        /// target_ExecuteProgressChanged07の呼び出しフラグです。
        /// </summary>
        private bool _eventProgressChangedCalled07 = false;

        /// <summary>
        /// target_ExecuteProgressChanged08の呼び出しフラグです。
        /// </summary>
        private bool _eventProgressChangedCalled08 = false;

        #endregion

        #region Preprocessed

        /// <summary>
        /// target_Preprocessed04 の呼び出しフラグです。
        /// </summary>
        private bool _preprocessedCalled01 = false;

        /// <summary>
        /// target_Preprocessed04 の引数です。
        /// </summary>
        private PreprocessedEventArgs _preprocessedArgs01 = null;

        /// <summary>
        /// target_Preprocessed05 の呼び出しフラグです。
        /// </summary>
        private bool _preprocessedCalled02 = false;

        /// <summary>
        /// target_Preprocessed05 の引数です。
        /// </summary>
        private PreprocessedEventArgs _preprocessedArgs02 = null;

        /// <summary>
        /// target_Preprocessed03 の呼び出しフラグです。
        /// </summary>
        private bool _preprocessedCalled03 = false;

        /// <summary>
        /// target_Preprocessed03 の引数です。
        /// </summary>
        private PreprocessedEventArgs _preprocessedArgs03 = null;

        #endregion

        #region PreprocessedFailed

        /// <summary>
        /// target_PreprocessedFailed04 の呼び出しフラグです。
        /// </summary>
        private bool _preprocessedFailedCalled01 = false;

        /// <summary>
        /// target_PreprocessedFailed04 の引数です。
        /// </summary>
        private PreprocessedFailedEventArgs _preprocessedFailedArgs01 = null;

        /// <summary>
        /// target_PreprocessedFailed05 の呼び出しフラグです。
        /// </summary>
        private bool _preprocessedFailedCalled02 = false;

        /// <summary>
        /// target_PreprocessedFailed05 の引数です。
        /// </summary>
        private PreprocessedFailedEventArgs _preprocessedFailedArgs02 = null;

        /// <summary>
        /// target_PreprocessedFailed03 の呼び出しフラグです。
        /// </summary>
        private bool _preprocessedFailedCalled03 = false;

        /// <summary>
        /// target_PreprocessedFailed03 の引数です。
        /// </summary>
        private PreprocessedFailedEventArgs _preprocessedFailedArgs03 = null;

        #endregion

        #region ValidationFailed

        /// <summary>
        /// target_ValidationFailed03 の呼び出しフラグです。
        /// </summary>
        private bool _validationFailedCalled01 = false;

        /// <summary>
        /// target_ValidationFailed03 の引数です。
        /// </summary>
        private ValidationFailedEventArgs _validationFailedArgs01 = null;

        /// <summary>
        /// target_ValidationFailed04 の呼び出しフラグです。
        /// </summary>
        private bool _validationFailedCalled02 = false;

        /// <summary>
        /// target_ValidationFailed04 の引数です。
        /// </summary>
        private ValidationFailedEventArgs _validationFailedArgs02 = null;

        /// <summary>
        /// target_ValidationFailed03 の呼び出しフラグです。
        /// </summary>
        private bool _validationFailedCalled03 = false;

        /// <summary>
        /// target_ValidationFailed03 の引数です。
        /// </summary>
        private ValidationFailedEventArgs _validationFailedArgs03 = null;

        #endregion

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
            
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        { 
            LogUTUtil.Clear();
            TERASOLUNA_Fw_Client_CoordinatorAccessor._coordinatorType = null;
            ConfigurationManager.AppSettings["CoordinatorTypeName"] = null;
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        [TestCleanup()]
        public void MyTestCleanup()
        {
            TERASOLUNA_Fw_Client_CoordinatorAccessor._coordinatorType = null;
            ConfigurationManager.AppSettings["CoordinatorTypeName"] = null;
        }
        
        #endregion

        /// <summary>
        /// Constructorのテスト
        /// </summary>
        /// <remarks>
        /// 正常にインスタンス化できることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備
            EventController target = new EventController();

            // 確認
            Assert.IsNotNull(target);
            Assert.IsNull(target.BLogicName);
            Assert.IsNull(target.BLogicParamTypeName);
            Assert.IsNull(target.BLogicResultTypeName);
            Assert.IsNull(target.Container);
            Assert.IsNull(target.ConvertId);
            Assert.IsNull(target.ErrorHandler);
            Assert.AreEqual(0, target.ErrorPaths.Count);
            Assert.IsFalse(target.IsBusy);
            Assert.AreEqual(0, target.Items.Count);
            Assert.IsNull(target.RequestName);
            Assert.IsNull(target.RuleSet);
            Assert.IsNull(target.Site);
            Assert.IsNull(target.ValidationFilePath);
            Assert.IsNull(target.ViewData);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// Constructor(IContainer)のテスト
        /// </summary>
        /// <remarks>
        /// 正常にインスタンス化できることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorIContainerTest01()
        {
            EventController_IContainerStub01 arg = new EventController_IContainerStub01();
            // 準備
            EventController target = new EventController(arg);

            // 確認
            Assert.IsNotNull(target);
            Assert.AreSame(target, arg.Component);
            Assert.IsNull(target.BLogicName);
            Assert.IsNull(target.BLogicParamTypeName);
            Assert.IsNull(target.BLogicResultTypeName);
            Assert.IsNull(target.Container);
            Assert.IsNull(target.ConvertId);
            Assert.IsNull(target.ErrorHandler);
            Assert.AreEqual(0, target.ErrorPaths.Count);
            Assert.IsFalse(target.IsBusy);
            Assert.AreEqual(0, target.Items.Count);
            Assert.IsNull(target.RequestName);
            Assert.IsNull(target.RuleSet);
            Assert.IsNull(target.Site);
            Assert.IsNull(target.ValidationFilePath);
            Assert.IsNull(target.ViewData);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// Constructor(IContainer)のテスト
        /// </summary>
        /// <remarks>
        /// 引数にnullを与えた場合、正常にインスタンス化できることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorIContainerTest02()
        {
            // 準備
            EventController target = new EventController(null);

            // 確認
            Assert.IsNotNull(target);
            Assert.IsNull(target.BLogicName);
            Assert.IsNull(target.BLogicParamTypeName);
            Assert.IsNull(target.BLogicResultTypeName);
            Assert.IsNull(target.Container);
            Assert.IsNull(target.ConvertId);
            Assert.IsNull(target.ErrorHandler);
            Assert.AreEqual(0, target.ErrorPaths.Count);
            Assert.IsFalse(target.IsBusy);
            Assert.AreEqual(0, target.Items.Count);
            Assert.IsNull(target.RequestName);
            Assert.IsNull(target.RuleSet);
            Assert.IsNull(target.Site);
            Assert.IsNull(target.ValidationFilePath);
            Assert.IsNull(target.ViewData);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicName プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void BLogicNameTest01()
        {
            // 準備
            EventController target = new EventController();
            string expected = "TERASOLUNA";

            // 実施
            target.BLogicName = expected;
            string actual = target.BLogicName;

            // 確認
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicParamTypeName プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void BLogicParamTypeNameTest01()
        {
            // 準備
            EventController target = new EventController();
            string expected = "TERASOLUNA";

            // 実施
            target.BLogicParamTypeName = expected;
            string actual = target.BLogicParamTypeName;

            // 確認
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicResultTypeName プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void BLogicResultTypeNameTest01()
        {
            // 準備
            EventController target = new EventController();
            string expected = "TERASOLUNA";

            // 実施
            target.BLogicResultTypeName = expected;
            string actual = target.BLogicResultTypeName;

            // 確認
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ConvertId プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void ConvertIdTest01()
        {
            // 準備
            EventController target = new EventController();
            string expected = "TERASOLUNA";

            // 実施
            target.ConvertId = expected;
            string actual = target.ConvertId;

            // 確認
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ErrorHandler プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void ErrorHandlerTest01()
        {
            // 準備
            EventController target = new EventController();
            IErrorHandler expected = new EventController_IErrorHandlerStub01();

            // 実施
            target.ErrorHandler = expected;
            IErrorHandler actual = target.ErrorHandler;

            // 確認
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ErrorPaths プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void ErrorPathsTest01()
        {
            // 準備
            EventController target = new EventController();

            // 実施
            IList<string> actual = target.ErrorPaths; 

            // 確認
            Assert.AreEqual(0, actual.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// Items プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void ItemsTest01()
        {
            // 準備
            EventController target = new EventController();

            // 実施
            IDictionary<string, object> actual = target.Items;

            // 確認
            Assert.AreEqual(0, actual.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// RequestName プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void RequestNameTest01()
        {
            // 準備
            EventController target = new EventController();
            string expected = "TERASOLUNA";

            // 実施
            target.RequestName = expected;
            string actual = target.RequestName;

            // 確認
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// RuleSet プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void RuleSetTest01()
        {
            // 準備
            EventController target = new EventController();
            string expected = "TERASOLUNA";

            // 実施
            target.RuleSet = expected;
            string actual = target.RuleSet;

            // 確認
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ValidationFilePath プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void ValidationFilePathTest01()
        {
            // 準備
            EventController target = new EventController();
            string expected = "TERASOLUNA";

            // 実施
            target.ValidationFilePath = expected;
            string actual = target.ValidationFilePath;

            // 確認
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ViewData プロパティのテスト
        /// </summary>
        [TestMethod()]
        public void ViewDataTest01()
        {
            // 準備
            EventController target = new EventController();
            DataSet expected = new DataSet();

            // 実施
            target.ViewData = expected;
            DataSet actual = target.ViewData;

            // 確認
            Assert.AreSame(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// Execute のテスト
        /// </summary>
        /// <remarks>
        /// Execute を実行し、オブジェクトの状態と戻り値を確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest01()
        {
            // 準備
            EventController target = new EventController();
            ConfigurationManager.AppSettings["CoordinatorTypeName"] = typeof(EventController_CoordinatorStub01).AssemblyQualifiedName;
            ExecutionResult expected = new ExecutionResult();
            EventController_CoordinatorStub01.Result = expected;

            // 実施
            ExecutionResult actual = target.Execute();

            // 確認
            TERASOLUNA_Fw_Client_EventControllerAccessor accessor =
                new TERASOLUNA_Fw_Client_EventControllerAccessor(target);
            Assert.IsInstanceOfType(accessor._coordinator, typeof(EventController_CoordinatorStub01));
            Assert.AreSame(target, EventController_CoordinatorStub01.Controller);
            Assert.AreSame(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ExecuteAsync のテスト
        /// </summary>
        /// <remarks>
        /// フィールド _coordinator が null の場合に _coordinator が
        /// 正しくインスタンス化されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteAsyncTest01()
        {
            // 準備
            EventController target = new EventController();
            ConfigurationManager.AppSettings["CoordinatorTypeName"] = typeof(EventController_CoordinatorStub02).AssemblyQualifiedName;

            // 実施
            target.ExecuteAsync();

            // 確認
            TERASOLUNA_Fw_Client_EventControllerAccessor accessor =
                new TERASOLUNA_Fw_Client_EventControllerAccessor(target);
            Assert.IsInstanceOfType(accessor._coordinator, typeof(EventController_CoordinatorStub02));
            Assert.AreSame(target, EventController_CoordinatorStub02.Controller);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ExecuteAsync のテスト
        /// </summary>
        /// <remarks>
        /// フィールド _coordinator が Busy 状態の場合に
        /// InvalidOperationException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteAsyncTest02()
        {
            // 準備
            EventController target = new EventController();
            ConfigurationManager.AppSettings["CoordinatorTypeName"] = typeof(EventController_CoordinatorStub03).AssemblyQualifiedName;
            TERASOLUNA_Fw_Client_EventControllerAccessor accessor =
                new TERASOLUNA_Fw_Client_EventControllerAccessor(target);
            accessor._coordinator = new EventController_CoordinatorStub03();

            try
            {
                // 実施
                target.ExecuteAsync();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (InvalidOperationException e)
            {
                // 成功
                Assert.AreEqual(MessageManager.GetMessage("E_BLOGIC_EXECUTEASYNC_OPERATED"), e.Message);

            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                typeof(EventController), typeof(InvalidOperationException), "E_BLOGIC_EXECUTEASYNC_OPERATED"));
        }

        /// <summary>
        /// ExecuteAsyncのテスト
        /// </summary>
        /// <remarks>
        /// フィールド _coordinator が Busy 状態でない場合に _coordinator が
        /// 正しくインスタンス化されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteAsyncTest03()
        {
            // 準備
            EventController target = new EventController();
            ConfigurationManager.AppSettings["CoordinatorTypeName"] = typeof(EventController_CoordinatorStub04).AssemblyQualifiedName;
            
            Coordinator coordinator = new Coordinator();
            TERASOLUNA_Fw_Client_EventControllerAccessor accessor =
                new TERASOLUNA_Fw_Client_EventControllerAccessor(target);
            accessor._coordinator = coordinator;

            // 実施
            target.ExecuteAsync();

            // 確認
            Assert.IsInstanceOfType(accessor._coordinator, typeof(EventController_CoordinatorStub04));
            Assert.AreSame(target, EventController_CoordinatorStub04.Controller);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ExecuteAsyncCancel のテスト
        /// </summary>
        /// <remarks>
        /// BLogic が実行されていない場合に、InvalidOperationException がスローされ
        /// _coordinator.ExecuteAsyncCancel が呼び出されないことを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteAsyncCancelTest01()
        {
            // 準備
            EventController target = new EventController();

            try
            {
                // 実施
                target.ExecuteAsyncCancel();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (InvalidOperationException e)
            {
                // 成功
                Assert.IsFalse(EventController_CoordinatorStub05.IsCalled);
                Assert.AreEqual(MessageManager.GetMessage("E_BLOGIC_NOT_EXECUTEASYNC_OPERATED"), e.Message);

            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                typeof(EventController), typeof(InvalidOperationException), "E_BLOGIC_NOT_EXECUTEASYNC_OPERATED"));
        }

        /// <summary>
        /// ExecuteAsyncCancel のテスト
        /// </summary>
        /// <remarks>
        /// IsBusy が True の場合に、正常に _coordinator.ExecuteAsyncCancel が
        /// 呼び出されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteAsyncCancelTest02()
        {
            // 準備
            EventController target = new EventController();
            ConfigurationManager.AppSettings["CoordinatorTypeName"] = typeof(EventController_CoordinatorStub06).AssemblyQualifiedName;

            TERASOLUNA_Fw_Client_EventControllerAccessor accessor =
                new TERASOLUNA_Fw_Client_EventControllerAccessor(target);
            accessor._coordinator = new EventController_CoordinatorStub06();

            // 実施
            target.ExecuteAsyncCancel();

            // 確認
            Assert.IsTrue(EventController_CoordinatorStub06.IsCalled);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ExecuteAsyncCancel のテスト
        /// </summary>
        /// <remarks>
        /// IsBusy が False の場合に、InvalidOperationException がスローされ、
        /// _coordinator.ExecuteAsyncCancel が呼び出されないことを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteAsyncCancelTest03()
        {
            // 準備
            EventController target = new EventController();
            ConfigurationManager.AppSettings["CoordinatorTypeName"] = typeof(EventController_CoordinatorStub07).AssemblyQualifiedName;

            TERASOLUNA_Fw_Client_EventControllerAccessor accessor =
               new TERASOLUNA_Fw_Client_EventControllerAccessor(target);
            accessor._coordinator = new EventController_CoordinatorStub07();

            try
            {
                // 実施
                target.ExecuteAsyncCancel();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (InvalidOperationException e)
            {
                Assert.IsFalse(EventController_CoordinatorStub07.IsCalled);
                Assert.AreEqual(MessageManager.GetMessage("E_BLOGIC_NOT_EXECUTEASYNC_OPERATED"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                typeof(EventController), typeof(InvalidOperationException), "E_BLOGIC_NOT_EXECUTEASYNC_OPERATED"));
        }

        /// <summary>
        /// ReportBLogicFailed のテスト
        /// </summary>
        /// <remarks>
        /// イベントハンドラの登録が行われていた場合、
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportBLogicFailedTest03()
        {
            // 準備
            EventController target = new EventController();
            target.BLogicFailed += new BLogicFailedEventHandler(target_BLogicFailed01);
            _blogicFailedCalled01 = false;

            ExecutionResult result = new ExecutionResult();

            // 実施
            target.ReportBLogicFailed(result);

            // 確認
            Assert.IsTrue(_blogicFailedCalled01);
            Assert.AreSame(result, _blogicFailedArgs01.ExecutionResult);
            
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportBLogicFailed のテスト
        /// </summary>
        /// <remarks>
        /// 複数のイベントハンドラの登録が行われていた場合、
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportBLogicFailedTest04()
        {
            // 準備
            EventController target = new EventController();
            target.BLogicFailed += new BLogicFailedEventHandler(target_BLogicFailed01);
            target.BLogicFailed += new BLogicFailedEventHandler(target_BLogicFailed02);
            target.BLogicFailed += new BLogicFailedEventHandler(target_BLogicFailed03);

            _blogicFailedCalled01 = false;
            _blogicFailedCalled02 = false;
            _blogicFailedCalled03 = false;

            ExecutionResult result = new ExecutionResult();

            // 実施
            target.ReportBLogicFailed(result);

            // 確認
            Assert.IsTrue(_blogicFailedCalled01);
            Assert.IsTrue(_blogicFailedCalled02);
            Assert.IsTrue(_blogicFailedCalled03);

            Assert.AreSame(result, _blogicFailedArgs01.ExecutionResult);
            Assert.AreSame(result, _blogicFailedArgs02.ExecutionResult);
            Assert.AreSame(result, _blogicFailedArgs03.ExecutionResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportCustomValidating のテスト
        /// </summary>
        /// <remarks>
        /// イベントハンドラの登録が行われていた場合、
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportCustomValidatingTest03()
        {
            // 準備
            EventController target = new EventController();
            target.CustomValidating += new CustomValidatingEventHandler(target_CustomValidating01);
            _customValidatingCalled01 = false;

            ValidationResult result = new ValidationResult();

            // 実施
            target.ReportCustomValidating(result);

            // 確認
            Assert.IsTrue(_customValidatingCalled01);            
            Assert.AreSame(result, _customValidatingArgs01.ValidationResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportCustomValidating のテスト
        /// </summary>
        /// <remarks>
        /// 複数のイベントハンドラの登録が行われていた場合、
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportCustomValidatingTest04()
        {
            // 準備
            EventController target = new EventController();
            target.CustomValidating += new CustomValidatingEventHandler(target_CustomValidating01);
            target.CustomValidating += new CustomValidatingEventHandler(target_CustomValidating02);
            target.CustomValidating += new CustomValidatingEventHandler(target_CustomValidating03);

            _customValidatingCalled01 = false;
            _customValidatingCalled02 = false;
            _customValidatingCalled03 = false;

            ValidationResult result = new ValidationResult();

            // 実施
            target.ReportCustomValidating(result);

            // 確認
            Assert.IsTrue(_customValidatingCalled01);
            Assert.IsTrue(_customValidatingCalled02);
            Assert.IsTrue(_customValidatingCalled03);

            Assert.AreSame(result, _customValidatingArgs01.ValidationResult);
            Assert.AreSame(result, _customValidatingArgs02.ValidationResult);
            Assert.AreSame(result, _customValidatingArgs03.ValidationResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteCompleted のテスト
        /// </summary>
        /// <remarks>
        /// 実行がキャンセルされず、イベントハンドラの登録が行われていた場合、
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportExecuteCompletedTest04()
        {
            // 準備
            EventController target = new EventController();
            target.ExecuteCompleted += new ExecuteCompletedEventHandler(target_ExecuteCompleted01);
            _eventCompletedCalled01 = false;

            ExecutionResult result = new ExecutionResult();
            Exception error = new Exception();
            bool cancelled = false;

            // 実施
            target.ReportExecuteCompleted(result, error, cancelled);

            // 確認
            Assert.IsTrue(_eventCompletedCalled01);
            Assert.AreSame(error, _eventCompletedArgs01.Error);
            Assert.IsFalse(_eventCompletedArgs01.Cancelled);
            try
            {
                ExecutionResult r = _eventCompletedArgs01.ExecutionResult;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TargetInvocationException e)
            {
                Assert.AreSame(error, e.InnerException);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteCompleted のテスト
        /// </summary>
        /// <remarks>
        /// 実行がキャンセルされず、複数のイベントハンドラの登録が行われていた場合
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportExecuteCompletedTest06()
        {
            // 準備
            EventController target = new EventController();
            target.ExecuteCompleted += new ExecuteCompletedEventHandler(target_ExecuteCompleted01);
            target.ExecuteCompleted += new ExecuteCompletedEventHandler(target_ExecuteCompleted02);
            target.ExecuteCompleted += new ExecuteCompletedEventHandler(target_ExecuteCompleted03);

            _eventCompletedCalled01 = false;
            _eventCompletedCalled02 = false;
            _eventCompletedCalled03 = false;

            ExecutionResult result = new ExecutionResult();
            Exception error = new Exception();
            bool cancelled = false;

            // 実施
            target.ReportExecuteCompleted(result, error, cancelled);

            // 確認
            Assert.IsTrue(_eventCompletedCalled01);
            Assert.IsTrue(_eventCompletedCalled02);
            Assert.IsTrue(_eventCompletedCalled03);

            Assert.IsFalse(_eventCompletedArgs01.Cancelled);
            Assert.IsFalse(_eventCompletedArgs02.Cancelled);
            Assert.IsFalse(_eventCompletedArgs03.Cancelled);

            Assert.AreSame(error, _eventCompletedArgs01.Error);
            Assert.AreSame(error, _eventCompletedArgs02.Error);
            Assert.AreSame(error, _eventCompletedArgs03.Error);

            try
            {
                ExecutionResult r = _eventCompletedArgs01.ExecutionResult;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TargetInvocationException e)
            {
                Assert.AreSame(error, e.InnerException);
            }

            try
            {
                ExecutionResult r = _eventCompletedArgs02.ExecutionResult;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TargetInvocationException e)
            {
                Assert.AreSame(error, e.InnerException);
            }

            try
            {
                ExecutionResult r = _eventCompletedArgs03.ExecutionResult;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TargetInvocationException e)
            {
                Assert.AreSame(error, e.InnerException);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteProgressChanged のテスト
        /// </summary>
        /// <remarks>
        /// 引数 items に null を渡した場合、ArgumentNullException が発生することを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void ReportExecuteProgressChangedTest01()
        {
            // 準備
            EventController target = new EventController();

            try
            {
                // 実施
                target.ReportExecuteProgressChanged(10, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("items", e.ParamName);
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                typeof(EventController), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "items"));
        }

        /// <summary>
        /// ReportExecuteProgressChanged のテスト
        /// </summary>
        /// <remarks>
        /// イベントハンドラが登録されていた場合に、正しくイベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void ReportExecuteProgressChangedTest02()
        {
            // 準備
            EventController target = new EventController();
            target.ExecuteProgressChanged += new ExecuteProgressChangedEventHandler(target_ExecuteProgressChanged01);
            _eventProgressChangedCalled01 = false;
            IDictionary items = new HybridDictionary();

            // 実施
            target.ReportExecuteProgressChanged(10, items);

            // 確認
            Assert.IsTrue(_eventProgressChangedCalled01);
            Assert.AreEqual(0, _eventProgressChangedArgs01.Items.Count);
            Assert.AreEqual(10, _eventProgressChangedArgs01.ProgressPercentage);
            Assert.AreEqual(0, items.Count);
            
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteProgressChanged のテスト
        /// </summary>
        /// <remarks>
        /// 引数の items に要素を1つ設定した場合、正しい引数でイベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void ReportExecuteProgressChangedTest03()
        {
            // 準備
            EventController target = new EventController();
            target.ExecuteProgressChanged += new ExecuteProgressChangedEventHandler(target_ExecuteProgressChanged02);
            _eventProgressChangedCalled02 = false;
            IDictionary items = new HybridDictionary();
            items.Add("key1", "value1");

            // 実施
            target.ReportExecuteProgressChanged(10, items);

            // 確認
            Assert.IsTrue(_eventProgressChangedCalled02);
            Assert.AreEqual(1, _eventProgressChangedArgs02.Items.Count);
            Assert.AreEqual("value1", _eventProgressChangedArgs02.Items["key1"]);
            Assert.AreEqual(10, _eventProgressChangedArgs02.ProgressPercentage);          
            Assert.AreEqual(1, items.Count);
            Assert.AreEqual("value1", items["key1"]);
            
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteProgressChanged のテスト
        /// </summary>
        /// <remarks>
        /// 引数のitemsに要素を複数設定した場合、正しい引数でイベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void ReportExecuteProgressChangedTest04()
        {
            // 準備
            EventController target = new EventController();
            target.ExecuteProgressChanged += new ExecuteProgressChangedEventHandler(target_ExecuteProgressChanged03);
            _eventProgressChangedCalled03 = false;
            IDictionary items = new HybridDictionary();
            items.Add("key1", "value1");
            items.Add("key2", "value2");
            items.Add("key3", "value3");

            // 実施
            target.ReportExecuteProgressChanged(10, items);

            // 確認
            Assert.IsTrue(_eventProgressChangedCalled03);
            Assert.AreEqual(10, _eventProgressChangedArgs03.ProgressPercentage);
            Assert.AreEqual(3, _eventProgressChangedArgs03.Items.Count);
            Assert.AreEqual("value1", _eventProgressChangedArgs03.Items["key1"]);
            Assert.AreEqual("value2", _eventProgressChangedArgs03.Items["key2"]);
            Assert.AreEqual("value3", _eventProgressChangedArgs03.Items["key3"]);
            Assert.AreEqual(3, items.Count);
            Assert.AreEqual("value1", items["key1"]);
            Assert.AreEqual("value2", items["key2"]);
            Assert.AreEqual("value3", items["key3"]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteProgressChanged のテスト
        /// </summary>
        /// <remarks>
        /// イベントハンドラで Items を更新した場合、引数の要素が更新されることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void ReportExecuteProgressChangedTest05()
        {
            // 準備
            EventController target = new EventController();
            target.ExecuteProgressChanged += new ExecuteProgressChangedEventHandler(target_ExecuteProgressChanged04);
            _eventProgressChangedCalled04 = false;
            IDictionary items = new HybridDictionary();
            items.Add("key1", "value1");

            // 実施
            target.ReportExecuteProgressChanged(10, items);

            // 確認
            Assert.IsTrue(_eventProgressChangedCalled04);
            Assert.AreEqual(1, items.Count);
            Assert.AreEqual("newValue", items["key1"]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteProgressChanged のテスト
        /// </summary>
        /// <remarks>
        /// イベントハンドラで Items を追加した場合、引数の要素が増えていることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void ReportExecuteProgressChangedTest06()
        {
            // 準備
            EventController target = new EventController();
            target.ExecuteProgressChanged += new ExecuteProgressChangedEventHandler(target_ExecuteProgressChanged05);
            _eventProgressChangedCalled05 = false;
            IDictionary items = new HybridDictionary();
            items.Add("key1", "value1");

            // 実施
            target.ReportExecuteProgressChanged(10, items);

            // 確認
            Assert.IsTrue(_eventProgressChangedCalled05);
            Assert.AreEqual(3, items.Count);
            Assert.AreEqual("value1", items["key1"]);
            Assert.AreEqual("value2", items["key2"]);
            Assert.AreEqual("value3", items["key3"]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteProgressChanged のテスト
        /// </summary>
        /// <remarks>
        /// イベントハンドラを登録しない場合、引数に変更が無いことを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void ReportExecuteProgressChangedTest07()
        {
            // 準備
            EventController target = new EventController();
            IDictionary items = new HybridDictionary();
            items.Add("key1", "value1");

            // 実施
            target.ReportExecuteProgressChanged(10, items);

            // 確認
            Assert.AreEqual(1, items.Count);
            Assert.AreEqual("value1", items["key1"]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportExecuteProgressChanged のテスト
        /// </summary>
        /// <remarks>
        /// 複数のイベントハンドラが登録されている場合
        /// すべてのイベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod]
        public void ReportExecuteProgressChangedTest08()
        {
            // 準備
            EventController target = new EventController();
            target.ExecuteProgressChanged += new ExecuteProgressChangedEventHandler(target_ExecuteProgressChanged06);
            target.ExecuteProgressChanged += new ExecuteProgressChangedEventHandler(target_ExecuteProgressChanged07);
            target.ExecuteProgressChanged += new ExecuteProgressChangedEventHandler(target_ExecuteProgressChanged08);

            _eventProgressChangedCalled06 = false;
            _eventProgressChangedCalled07 = false;
            _eventProgressChangedCalled08 = false;

            IDictionary items = new HybridDictionary();
            items.Add("key1", "value1");

            // 実施
            target.ReportExecuteProgressChanged(10, items);

            // 確認
            Assert.IsTrue(_eventProgressChangedCalled06);
            Assert.IsTrue(_eventProgressChangedCalled07);
            Assert.IsTrue(_eventProgressChangedCalled08);
            Assert.AreEqual(1, items.Count);
            Assert.AreEqual("value1", items["key1"]);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportPreprocessed のテスト
        /// </summary>
        /// <remarks>
        /// 実行がキャンセルされず、イベントハンドラの登録が行われていた場合
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportPreprocessedTest04()
        {
            // 準備
            EventController target = new EventController();
            target.Preprocessed += new PreprocessedEventHandler(target_Preprocessed01);
            _preprocessedCalled01 = false;
            ExecutionResult result = new ExecutionResult();
            DataSet dataSet = new DataSet();

            // 実施
            target.ReportPreprocessed(result, dataSet);

            // 確認
            Assert.IsTrue(_preprocessedCalled01);
            Assert.AreSame(dataSet, _preprocessedArgs01.BLogicParamData);
            Assert.AreSame(result, _preprocessedArgs01.ExecutionResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportPreprocessed のテスト
        /// </summary>
        /// <remarks>
        /// 実行がキャンセルされず、複数のイベントハンドラの登録が行われていた場合
        /// すべてのイベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportPreprocessedTest05()
        {
            // 準備
            EventController target = new EventController();
            target.Preprocessed += new PreprocessedEventHandler(target_Preprocessed01);
            target.Preprocessed += new PreprocessedEventHandler(target_Preprocessed02);
            target.Preprocessed += new PreprocessedEventHandler(target_Preprocessed03);

            _preprocessedCalled01 = false;
            _preprocessedCalled02 = false;
            _preprocessedCalled03 = false;

            ExecutionResult result = new ExecutionResult();
            DataSet dataSet = new DataSet();

            // 実施
            target.ReportPreprocessed(result, dataSet);

            // 確認
            Assert.IsTrue(_preprocessedCalled01);
            Assert.IsTrue(_preprocessedCalled02);
            Assert.IsTrue(_preprocessedCalled03);

            Assert.AreSame(dataSet, _preprocessedArgs01.BLogicParamData);
            Assert.AreSame(dataSet, _preprocessedArgs02.BLogicParamData);
            Assert.AreSame(dataSet, _preprocessedArgs03.BLogicParamData);

            Assert.AreSame(result, _preprocessedArgs01.ExecutionResult);          
            Assert.AreSame(result, _preprocessedArgs02.ExecutionResult);           
            Assert.AreSame(result, _preprocessedArgs03.ExecutionResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportPreprocessedFailed のテスト
        /// </summary>
        /// <remarks>
        /// 実行がキャンセルされず、イベントハンドラの登録が行われていた場合
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportPreprocessedFailedTest04()
        {
            // 準備
            EventController target = new EventController();
            target.PreprocessedFailed += new PreprocessedFailedEventHandler(target_PreprocessedFailed01);
            _preprocessedFailedCalled01 = false;
            ExecutionResult result = new ExecutionResult();
            DataSet dataSet = new DataSet();

            // 実施
            target.ReportPreprocessedFailed(result, dataSet);

            // 確認
            Assert.IsTrue(_preprocessedFailedCalled01);
            Assert.AreSame(dataSet, _preprocessedFailedArgs01.BLogicParamData);
            Assert.AreSame(result, _preprocessedFailedArgs01.ExecutionResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportPreprocessedFailed のテスト
        /// </summary>
        /// <remarks>
        /// 実行がキャンセルされず、複数のイベントハンドラの登録が行われていた場合
        /// すべてのイベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportPreprocessedFailedTest05()
        {
            // 準備
            EventController target = new EventController();
            target.PreprocessedFailed += new PreprocessedFailedEventHandler(target_PreprocessedFailed01);
            target.PreprocessedFailed += new PreprocessedFailedEventHandler(target_PreprocessedFailed02);
            target.PreprocessedFailed += new PreprocessedFailedEventHandler(target_PreprocessedFailed03);

            _preprocessedFailedCalled01 = false;
            _preprocessedFailedCalled02 = false;
            _preprocessedFailedCalled03 = false;

            ExecutionResult result = new ExecutionResult();
            DataSet dataSet = new DataSet();

            // 実施
            target.ReportPreprocessedFailed(result, dataSet);

            // 確認
            Assert.IsTrue(_preprocessedFailedCalled01);
            Assert.IsTrue(_preprocessedFailedCalled02);
            Assert.IsTrue(_preprocessedFailedCalled03);

            Assert.AreSame(dataSet, _preprocessedFailedArgs01.BLogicParamData);
            Assert.AreSame(dataSet, _preprocessedFailedArgs02.BLogicParamData);
            Assert.AreSame(dataSet, _preprocessedFailedArgs03.BLogicParamData);

            Assert.AreSame(result, _preprocessedFailedArgs01.ExecutionResult);
            Assert.AreSame(result, _preprocessedFailedArgs02.ExecutionResult);
            Assert.AreSame(result, _preprocessedFailedArgs03.ExecutionResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportValidationFailed のテスト
        /// </summary>
        /// <remarks>
        /// イベントハンドラの登録が行われていた場合、
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportValidationFailedTest03()
        {
            // 準備
            EventController target = new EventController();
            target.ValidationFailed += new ValidationFailedEventHandler(target_ValidationFailed01);
            _validationFailedCalled01 = false;
            ExecutionResult result = new ExecutionResult();

            // 実施
            target.ReportValidationFailed(result);

            // 確認
            Assert.IsTrue(_validationFailedCalled01);
            Assert.AreSame(result, _validationFailedArgs01.ExecutionResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        /// <summary>
        /// ReportValidationFailed のテスト
        /// </summary>
        /// <remarks>
        /// 複数のイベントハンドラの登録が行われていた場合、
        /// イベントハンドラが呼ばれることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ReportValidationFailedTest04()
        {
            // 準備
            EventController target = new EventController();
            target.ValidationFailed += new ValidationFailedEventHandler(target_ValidationFailed01);
            target.ValidationFailed += new ValidationFailedEventHandler(target_ValidationFailed02);
            target.ValidationFailed += new ValidationFailedEventHandler(target_ValidationFailed03);

            _validationFailedCalled01 = false;
            _validationFailedCalled02 = false;
            _validationFailedCalled03 = false;
            ExecutionResult result = new ExecutionResult();

            // 実施
            target.ReportValidationFailed(result);

            // 確認
            Assert.IsTrue(_validationFailedCalled01);
            Assert.IsTrue(_validationFailedCalled02);
            Assert.IsTrue(_validationFailedCalled03);

            Assert.AreSame(result, _validationFailedArgs01.ExecutionResult);
            Assert.AreSame(result, _validationFailedArgs02.ExecutionResult);
            Assert.AreSame(result, _validationFailedArgs03.ExecutionResult);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(EventController), LogLevel.INFO));
        }

        #region イベントハンドラ

        /// <summary>
        /// ReportBLogicFailedTest03,04 で使用するイベントハンドラです。
        /// </summary>
        void target_BLogicFailed01(object sender, BLogicFailedEventArgs e)
        {
            _blogicFailedArgs01 = e;
            _blogicFailedCalled01 = true;
        }

        /// <summary>
        /// ReportBLogicFailedTest04 で使用するイベントハンドラです。
        /// </summary>
        void target_BLogicFailed02(object sender, BLogicFailedEventArgs e)
        {
            _blogicFailedArgs02 = e;
            _blogicFailedCalled02 = true;
        }

        /// <summary>
        /// ReportBLogicFailedTest04 で使用するイベントハンドラです。
        /// </summary>
        void target_BLogicFailed03(object sender, BLogicFailedEventArgs e)
        {
            _blogicFailedArgs03 = e;
            _blogicFailedCalled03 = true;
        }

        /// <summary>
        /// ReportCustomValidatingTest03,04 で使用するイベントハンドラです。
        /// </summary>
        void target_CustomValidating01(object sender, CustomValidatingEventArgs e)
        {
            _customValidatingArgs01 = e;
            _customValidatingCalled01 = true;
        }

        /// <summary>
        /// ReportCustomValidatingTest04 で使用するイベントハンドラです。
        /// </summary>
        void target_CustomValidating02(object sender, CustomValidatingEventArgs e)
        {
            _customValidatingArgs02 = e;
            _customValidatingCalled02 = true;
        }

        /// <summary>
        /// ReportCustomValidatingTest04 で使用するイベントハンドラです。
        /// </summary>
        void target_CustomValidating03(object sender, CustomValidatingEventArgs e)
        {
            _customValidatingArgs03 = e;
            _customValidatingCalled03 = true;
        }

        /// <summary>
        /// ReportExecuteCompletedTest04,06 で使用するイベントハンドラです。
        /// </summary>
        void target_ExecuteCompleted01(object sender, ExecuteCompletedEventArgs e)
        {
            _eventCompletedArgs01 = e;
            _eventCompletedCalled01 = true;
        }

        /// <summary>
        /// ReportExecuteCompletedTest06 で使用するイベントハンドラです。
        /// </summary>
        void target_ExecuteCompleted02(object sender, ExecuteCompletedEventArgs e)
        {
            _eventCompletedArgs02 = e;
            _eventCompletedCalled02 = true;
        }

        /// <summary>
        /// ReportExecuteCompletedTest06で使用するイベントハンドラです。
        /// </summary>
        void target_ExecuteCompleted03(object sender, ExecuteCompletedEventArgs e)
        {
            _eventCompletedArgs03 = e;
            _eventCompletedCalled03 = true;
        }

        /// <summary>
        /// ReportExecuteProgressChangedTest02 で利用するイベントハンドラです。
        /// </summary>
        void target_ExecuteProgressChanged01(object sender, ExecuteProgressChangedEventArgs e)
        {
            _eventProgressChangedArgs01 = e;
            _eventProgressChangedCalled01 = true;
            
        }

        /// <summary>
        /// ReportExecuteProgressChangedTest03 で利用するイベントハンドラです。
        /// </summary>
        void target_ExecuteProgressChanged02(object sender, ExecuteProgressChangedEventArgs e)
        {
            _eventProgressChangedArgs02 = e;
            _eventProgressChangedCalled02 = true;
        }

        /// <summary>
        /// ReportExecuteProgressChangedTest04 で利用するイベントハンドラです。
        /// </summary>
        void target_ExecuteProgressChanged03(object sender, ExecuteProgressChangedEventArgs e)
        {
            _eventProgressChangedArgs03 = e;
            _eventProgressChangedCalled03 = true;
        }

        /// <summary>
        /// ReportExecuteProgressChangedTest05 で利用するイベントハンドラです。
        /// </summary>
        void target_ExecuteProgressChanged04(object sender, ExecuteProgressChangedEventArgs e)
        {
            _eventProgressChangedCalled04 = true;
            Assert.AreEqual(10, e.ProgressPercentage);
            Assert.AreEqual(1, e.Items.Count);
            Assert.AreEqual("value1", e.Items["key1"]);

            e.Items["key1"] = "newValue";
        }

        /// <summary>
        /// ReportExecuteProgressChangedTest06 で利用するイベントハンドラです。
        /// </summary>
        void target_ExecuteProgressChanged05(object sender, ExecuteProgressChangedEventArgs e)
        {
            _eventProgressChangedCalled05 = true;
            Assert.AreEqual(10, e.ProgressPercentage);
            Assert.AreEqual(1, e.Items.Count);
            Assert.AreEqual("value1", e.Items["key1"]);

            e.Items.Add("key2", "value2");
            e.Items.Add("key3", "value3");
        }

        /// <summary>
        /// ReportExecuteProgressChangedTest08 で利用するイベントハンドラです。
        /// </summary>
        void target_ExecuteProgressChanged06(object sender, ExecuteProgressChangedEventArgs e)
        {
            _eventProgressChangedCalled06 = true;
            Assert.AreEqual(10, e.ProgressPercentage);
            Assert.AreEqual(1, e.Items.Count);
            Assert.AreEqual("value1", e.Items["key1"]);
        }

        /// <summary>
        /// ReportExecuteProgressChangedTest08 で利用するイベントハンドラです。
        /// </summary>
        void target_ExecuteProgressChanged07(object sender, ExecuteProgressChangedEventArgs e)
        {
            _eventProgressChangedCalled07 = true;
            Assert.AreEqual(10, e.ProgressPercentage);
            Assert.AreEqual(1, e.Items.Count);
            Assert.AreEqual("value1", e.Items["key1"]);
        }

        /// <summary>
        /// ReportExecuteProgressChangedTest08 で利用するイベントハンドラです。
        /// </summary>
        void target_ExecuteProgressChanged08(object sender, ExecuteProgressChangedEventArgs e)
        {
            _eventProgressChangedCalled08 = true;
            Assert.AreEqual(10, e.ProgressPercentage);
            Assert.AreEqual(1, e.Items.Count);
            Assert.AreEqual("value1", e.Items["key1"]);
        }

        /// <summary>
        /// ReportPreprocessedTest04,05 で利用するイベントハンドラです。
        /// </summary>
        void target_Preprocessed01(object sender, PreprocessedEventArgs e)
        {
            _preprocessedArgs01 = e;
            _preprocessedCalled01 = true;
        }

        /// <summary>
        /// ReportPreprocessedTest05 で利用するイベントハンドラです。
        /// </summary>
        void target_Preprocessed02(object sender, PreprocessedEventArgs e)
        {
            _preprocessedArgs02 = e;
            _preprocessedCalled02 = true;
        }

        /// <summary>
        /// ReportPreprocessedTest05 で利用するイベントハンドラです。
        /// </summary>
        void target_Preprocessed03(object sender, PreprocessedEventArgs e)
        {
            _preprocessedArgs03 = e;
            _preprocessedCalled03 = true;
        }

        /// <summary>
        /// ReportPreprocessedFailedTest04,05 で利用するイベントハンドラです。
        /// </summary>
        void target_PreprocessedFailed01(object sender, PreprocessedFailedEventArgs e)
        {
            _preprocessedFailedArgs01 = e;
            _preprocessedFailedCalled01 = true;
        }

        /// <summary>
        /// ReportPreprocessedFailedTest05 で利用するイベントハンドラです。
        /// </summary>
        void target_PreprocessedFailed02(object sender, PreprocessedFailedEventArgs e)
        {
            _preprocessedFailedArgs02 = e;
            _preprocessedFailedCalled02 = true;
        }

        /// <summary>
        /// ReportPreprocessedFailedTest05 で利用するイベントハンドラです。
        /// </summary>
        void target_PreprocessedFailed03(object sender, PreprocessedFailedEventArgs e)
        {
            _preprocessedFailedArgs03 = e;
            _preprocessedFailedCalled03 = true;
        }

        /// <summary>
        /// ReportValidationFailedTest03,04 で利用するイベントハンドラです。
        /// </summary>
        void target_ValidationFailed01(object sender, ValidationFailedEventArgs e)
        {
            _validationFailedArgs01 = e;
            _validationFailedCalled01 = true;
        }

        /// <summary>
        /// ReportValidationFailedTest04 で利用するイベントハンドラです。
        /// </summary>
        void target_ValidationFailed02(object sender, ValidationFailedEventArgs e)
        {
            _validationFailedArgs02 = e;
            _validationFailedCalled02 = true;
        }

        /// <summary>
        /// ReportValidationFailedTest04 で利用するイベントハンドラです。
        /// </summary>
        void target_ValidationFailed03(object sender, ValidationFailedEventArgs e)
        {
            _validationFailedArgs03 = e;
            _validationFailedCalled03 = true;
        }

        #endregion
    }
}
