// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.Validation;
using System.Data;

namespace TERASOLUNA.Fw.ClientUT.CoordinatorTestData
{
    /// <summary>
    /// Coordinator 単体試験用の IValidator 実装クラスです。
    /// </summary>
    /// <remarks>
    /// 正常系テスト用。
    /// 入力値検証によるエラー数 3 (ErrorsのMessageInfoがValidationMessageInfo型)。
    /// </remarks>
    public class Coordinator_IValidatorImpl04 : IValidator
    {
        private string _validationFilePath = null;
        private string _ruleSet = null;
        private ValidationMessageInfo _validateValidationMessageInfo01 = null;
        private ValidationMessageInfo _validateValidationMessageInfo02 = null;
        private ValidationMessageInfo _validateValidationMessageInfo03 = null;
        private DataSet _validateDataSet = null;
        private bool _isCalledValidate = false;

        public string ValidationFilePath
        {
            get
            {
                return _validationFilePath;
            }
            set
            {
                _validationFilePath = value;
            }
        }

        public string RuleSet
        {
            get
            {
                return _ruleSet;
            }
            set
            {
                _ruleSet = value;
            }
        }

        public ValidationMessageInfo ValidateValidationMessageInfo01
        {
            get { return _validateValidationMessageInfo01; }
        }

        public ValidationMessageInfo ValidateValidationMessageInfo02
        {
            get { return _validateValidationMessageInfo02; }
        }

        public ValidationMessageInfo ValidateValidationMessageInfo03
        {
            get { return _validateValidationMessageInfo03; }
        }

        public DataSet ValidateDataSet
        {
            get { return _validateDataSet; }
        }

        public bool IsCalledValidate
        {
            get { return _isCalledValidate; }
        }

        public ValidationResult Validate(DataSet dataSet)
        {
            _validateDataSet = dataSet;
            _isCalledValidate = true;

            ValidationResult result = new ValidationResult();
            ValidationMessageInfo messageInfo01 = new ValidationMessageInfo("key01", "message01", "errorPath01");
            ValidationMessageInfo messageInfo02 = new ValidationMessageInfo("key02", "message02", "errorPath02");
            ValidationMessageInfo messageInfo03 = new ValidationMessageInfo("key03", "message03", "errorPath03");
            _validateValidationMessageInfo01 = messageInfo01;
            _validateValidationMessageInfo02 = messageInfo02;
            _validateValidationMessageInfo03 = messageInfo03;
            result.Errors.Add(messageInfo01);
            result.Errors.Add(messageInfo02);
            result.Errors.Add(messageInfo03);

            return result;
        }
    }
}
