// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client;

namespace TERASOLUNA.Fw.ClientUT.CoordinatorTestData
{
    /// <summary>
    /// ExecuteAsync() 単体試験用の Coordinator 継承クラスです。
    /// </summary>
    public class CoordinatorStub01 : Coordinator
    {
        private bool isCalledExecuteAsyncCompletedCallback;

        public bool IsCalledExecuteAsyncCompletedCallback
        {
            get { return isCalledExecuteAsyncCompletedCallback; }
        }

        protected override void ExecuteAsyncCompletedCallback(object obj)
        {
            isCalledExecuteAsyncCompletedCallback = true;
        }
    }
}
