// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.Conversion;
using TERASOLUNA.Fw.Client.Configuration.Conversion;
using TERASOLUNA.Fw.Client.Configuration;
using TERASOLUNA.Fw.ClientUT.Configuration;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.ClientUT.Conversion.DataSetConverterTestData;
using System.Configuration;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.ClientUT.Conversion
{
    /// <summary>
    /// DataSetConverter のテストクラスです。
    /// </summary>

    [TestClass()]
    public class DataSetConverterCoverTest
    {
        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// GetTableName (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の文字列が空文字列の場合、TerasolunaExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetTableNameTest01()
        {
            DataSetConverterImpl target = new DataSetConverterImpl();

            string value = string.Empty;

            try
            {
                string result = target.GetTableName(value);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual(MessageManager.GetMessage("E_CONVERSION_INVALID_EXPRESSION", value), e.Message); 
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(DataSetConverter), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(DataSetConverter), typeof(TerasolunaException), "E_CONVERSION_INVALID_EXPRESSION", value));
        }

        /// <summary>
        /// GetTableName (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の文字列に"."がない場合、TerasolunaExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetTableNameTest02()
        {
            DataSetConverterImpl target = new DataSetConverterImpl();

            string value = "table";

            try
            {
                string result = target.GetTableName(value);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual(MessageManager.GetMessage("E_CONVERSION_INVALID_EXPRESSION", value), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(DataSetConverter), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(DataSetConverter), typeof(TerasolunaException), "E_CONVERSION_INVALID_EXPRESSION", value));
        }

        /// <summary>
        /// GetTableName (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の文字列に"."が１つあり、"."の前に文字がない場合、TerasolunaExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetTableNameTest03()
        {
            DataSetConverterImpl target = new DataSetConverterImpl();

            string value = ".column";

            try
            {
                string result = target.GetTableName(value);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual(MessageManager.GetMessage("E_CONVERSION_INVALID_EXPRESSION", value), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(DataSetConverter), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(DataSetConverter), typeof(TerasolunaException), "E_CONVERSION_INVALID_EXPRESSION", value));
        }

        /// <summary>
        /// GetTableName (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の文字列に"."が１つあり、"."の後ろに文字がない場合、TerasolunaExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetTableNameTest04()
        {
            DataSetConverterImpl target = new DataSetConverterImpl();

            string value = "table.";

            try
            {
                string result = target.GetTableName(value);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual(MessageManager.GetMessage("E_CONVERSION_INVALID_EXPRESSION", value), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(DataSetConverter), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(DataSetConverter), typeof(TerasolunaException), "E_CONVERSION_INVALID_EXPRESSION", value));
        }

        /// <summary>
        /// GetTableName (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の文字列に"."が2つある場合、TerasolunaExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetTableNameTest05()
        {
            DataSetConverterImpl target = new DataSetConverterImpl();

            string value = "table.column.terasoluna";

            try
            {
                string result = target.GetTableName(value);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TerasolunaException e)
            {
                // 確認
                Assert.AreEqual(MessageManager.GetMessage("E_CONVERSION_INVALID_EXPRESSION", value), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            // ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(DataSetConverter), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(DataSetConverter), typeof(TerasolunaException), "E_CONVERSION_INVALID_EXPRESSION", value));
        }

        /// <summary>
        /// GetTableName (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の文字列が正しいフォーマットの場合、テーブル名が取得できることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetTableNameTest06()
        {
            DataSetConverterImpl target = new DataSetConverterImpl();

            string value = "table.column";

            string result = target.GetTableName(value);

            Assert.AreEqual("table", result);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DataSetConverter), LogLevel.INFO));
        }
    }

    ///<summary>
    /// DataSetConverterのprotectedメソッドにアクセスするためのクラスです。
    ///</summary>
    class DataSetConverterImpl : DataSetConverter
    {
        public new string GetTableName(string value)
        {
            return base.GetTableName(value);
        }
    }

}
