﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Collections;
using System.Data;
using System.Windows.Forms;

namespace TERASOLUNA.Fw.Client.Forms
{
    /// <summary>
    /// <see cref="ForwarderBase"/> 派生コンポーネントにより遷移可能な画面のインタフェースです。
    /// </summary>
    public interface IForwardable
    {
        /// <summary>
        /// 各画面が持つコレクションを取得します。
        /// </summary>
        /// <remarks>
        /// <para>画面間でのデータの受け渡しの際に利用されます。</para>
        /// <para>このプロパティの値は <c>null</c> 参照を返すことはありません。</para>
        /// </remarks>
        /// <value>
        /// 画面の持つコレクション。
        /// </value>
        IDictionary Items
        {
            get;
        }
        /// <summary>
        /// 画面 <see cref="DataSet"/> を取得します。
        /// </summary>
        /// <value>画面 <see cref="DataSet"/> 。</value>
        DataSet ViewData
        {
            get;
        }

        /// <summary>
        /// 画面の初期化処理を実行します。
        /// </summary>
        /// <remarks>
        /// <para>
        /// このメソッドは <see cref="ForwarderBase"/> 派生コンポーネントによって、
        /// <see cref="IForwardable.ViewData"/> 、<see cref="IForwardable.Items"/> の値が設定された後に呼び出されます。
        /// </para>
        /// <para>
        /// 必要に応じて、画面実装者はこのメソッドをオーバーライドし、独自の初期化処理を実行します。
        /// </para>
        /// <para>
        /// 通常 <see cref="ForwarderBase"/> 派生コンポーネントは <see cref="IForwardable.Init"/> の例外を
        /// ハンドリングしません。内部で例外が発生する場合は、 <see cref="ForwarderBase.Execute"/> の呼び出し元か、
        /// あるいはこのメソッドの内部で例外をキャッチしてください。
        /// </para>
        /// <para>
        /// このメソッドを実装する場合、遷移先画面が Dispose される処理 (<see cref="Form.Close()"/> 等) 
        /// を行うことは避けてください。
        /// </para>
        /// </remarks>
        /// <param name="forwardableHost">
        /// 遷移元の画面を表します。
        /// 遷移元画面が <see cref="IForwardable"/> 実装クラスでない場合、 <c>null</c> 参照を渡します。
        /// </param>
        /// <returns>
        /// 初期化処理が成功した場合 <c>true</c> 、失敗した場合 <c>false</c> 。
        /// </returns>
        bool Init(IForwardable forwardableHost);

    }
}
