// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Data;
using System.IO;
using System.Net;
using System.Text;
using System.Xml;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// oCit@CM@\񋟂NXłB
    /// </summary>
    public class BinaryFileReceiver : ReceiverBase
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(BinaryFileReceiver));

        /// <summary>
        /// HTTPwb_Content-Dispositionwb_ݒ肷ہAL[Ƃėp镶łB
        /// </summary>
        /// <remarks>
        /// <para>萔̒l "Content-Disposition" łB</para>
        /// </remarks>
        protected static readonly string CONTENT_DISPOSITION = "Content-Disposition";

        /// <summary>
        /// Content-Disposition̒lt@C擾ۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "filename" łB</para></remarks>
        protected static readonly string CONTENT_DISPOSITION_FILENAME = "filename";

        /// <summary>
        /// T[oM_E[ht@CCxgnh֑MۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "ContentFileName" łB</para></remarks>
        protected static readonly string CONTENT_FILENAME = "ContentFileName";

        /// <summary>
        /// _E[ht@C̏o̓pX擾ۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "DownloadFilePath" łB</para></remarks>
        protected static readonly string DOWNLOAD_FILEPATH = "DownloadFilePath";

        /// <summary>
        /// is󋵃Cxgnhփ_E[hʒmsۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "DownloadReady" łB</para></remarks>
        protected static readonly string DOWNLOAD_READY = "DownloadReady";

        /// <summary>
        /// t@C̃GR[h^fR[h̃^Cv\łB
        /// </summary>
        /// <remarks>
        /// <para>̒萔̒l "B" łB"B" ́AB GR[h\܂B</para>
        /// <para>
        /// B GR[hƂ́A7bit US-ASCII ȊÕeLXggp邽߂ 7bit GR[fBOJjY
        /// ̈łBRFC 2047 Œ`Ă܂BGR[fBOASY Base64 ƓłB
        /// </para>
        /// </remarks>
        protected static readonly string ENCODE_TYPE = "B";

        /// <summary>
        /// <see cref="BinaryFileReceiver"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public BinaryFileReceiver()
        {
        }

        /// <summary>
        /// <paramref name="response"/> œnꂽ <see cref="HttpWebResponse"/>p t@C_E[h
        /// s܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="response"/> œnꂽ <see cref="HttpWebResponse"/>  HTTP X|X{fB擾A
        /// oCiXg[Ƃă[Jt@Cɏ݂܂Bۑ邽߂̃t@C擾邽߂ɁA
        /// <paramref name="reporter"/> 𗘗p܂B
        /// </para>
        /// <para>
        /// _E[hJnOɁA <see cref="BinaryFileReceiver"/>  <see cref="IProgressChangeReporter.ReportProgressChanged"/>
        /// Ăяo܂B̂ƂA<see cref="ExecuteProgressChangedEventArgs"/> Items vpeBɁA"DownloadReady" L[
        /// ƂāA <c>true</c> tOݒ肵܂BĂяo <paramref name="reporter"/> ł́A
        /// <see cref="IProgressChangeReporter.ReportProgressChanged"/> \bh "DownloadReady" L[݂̑𒲂ׁA
        /// ݂Ăꍇɂ́A<see cref="ExecuteProgressChangedEventArgs.Items"/>  "DownloadFilePath" L[Ƃ
        /// ۑ̃t@CpX\ǉ܂B <see cref="BinaryFileReceiver"/>  "DownloadFilePath" ɐݒ
        /// Ăt@CpXpă_E[hf[^t@Cɕۑ܂BL[ "DownloadFilePath" ݒ肳
        /// ĂȂꍇA_E[h͍s܂B "DownloadReady" L[ <see cref="ExecuteProgressChangedEventArgs.Items"/>
        /// ɐݒ肵 <see cref="IProgressChangeReporter.ReportProgressChanged"/> ĂяoہAX|X Content-Disposition
        /// wb_Ƀt@Ci[ĂꍇÃt@C "ContentFileName" L[Ƃē
        /// <see cref="ExecuteProgressChangedEventArgs.Items"/> ɐݒ肳܂B
        /// </para>
        /// <para>߂lɂ́A<see cref="CommunicationResult"/>̔hNXł <see cref="DownloadResult"/> 
        /// CX^XԂ܂B</para>
        /// <para>߂lƂȂ <see cref="DownloadResult"/> ̊evpeB͈ȉ̒ʂłB</para>
        /// <para>
        /// <list type="table">
        /// <listheader>
        ///     <term>DownloadResult̃vpeB</term>
        ///     <description>ݒ肳l</description>
        /// </listheader>
        /// <item>
        ///     <term>DownloadFilePath</term>
        ///     <description>_E[hsꂽꍇAۑ̃t@Ci[܂B_E[h
        ///     sȂꍇA <c>null</c> QƂłB</description>
        /// </item>
        /// <item>
        ///     <term>Headers</term>
        ///     <description>HTTP X|Xwb_̃L[/li[܂B</description>
        /// </item>
        /// <item>
        ///     <term>ResultData</term>
        ///     <description>M XML f[^i[f[^ZbgB</description>
        /// </item>
        /// </list>
        /// </para>
        /// <para>
        /// T[o瑗 Cookie Ȃǂ̃wb_ <see cref="CommunicationResult.ResponseHeaders"/>@Ɋi[܂B
        /// p҂͕KvɉĂ̏𗘗p邱Ƃł܂B
        /// </para>
        /// <para>
        /// <paramref name="reporter"/>  <c>null</c> QƂł͂ȂꍇA
        /// <see cref="ReceiverBase.BufferSize"/> vpeBɐݒ肳ꂽobt@TCỸf[^iftHg8 KB jT[oɑM閈ɁA
        /// <see cref="IProgressChangeReporter.ReportProgressChanged"/> Cxg𔭐܂B
        /// </para>
        /// </remarks>
        /// <param name="response">Ms HTTP X|XIuWFNgB</param>
        /// <param name="reporter">is󋵒ʒms<see cref="IProgressChangeReporter"/>CX^XB</param>
        /// <returns>Mʂێ <see cref="CommunicationResult"/>CX^XB</returns>
        /// <exception cref="WebException">
        /// ʐMG[܂B܂́ANGXgLZ܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// T[oŃG[ĂAAMf[^ XML `ł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// T[oŃG[ĂAAM XML f[^Ƀ[gm[h܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Content-Disposition Ɋi[ꂽt@C̃fR[hɎs܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// ʐMɃG[܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ServerException">
        /// T[oŋƖG[܂BT[oł̋ƖG[ HTTP X|Xwb_ "exception" 
        /// wb_邩ǂŔf܂BG[̃nhOɂĂ <see cref="ReceiverBase.HandleErrorResult"/> 
        /// QƂ܂B
        /// </exception>
        protected override CommunicationResult ReceiveResponse(HttpWebResponse response,
                                                                IProgressChangeReporter reporter)
        {
            // M̃Oo
            if (_log.IsTraceEnabled)
            {
                // HTTPwb_
                StringBuilder responseHeader = new StringBuilder();
                responseHeader.AppendLine(Properties.Resources.T_RESPONSE_RECEIVE_HEADER);
                foreach (string key in response.Headers.AllKeys)
                {
                    responseHeader.AppendLine(string.Format(
                    Properties.Resources.T_DICTIONARY_KEY_VALUE,
                    key, response.Headers[key]));
                }
                _log.Trace(responseHeader.ToString().Trim());
            }

            if (reporter == null)
            {
                string message = string.Format(Properties.Resources.E_NULL_ARGUMENT, "reporter");
                ArgumentNullException exception = new ArgumentNullException("reporter");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            string errorType = response.Headers[ERROR_TYPE];
            if (errorType != null)
            {
                // T[õG[M
                XmlDocument receiveXml = GetXmlFromResponseBody(response, reporter);

                // M̃Oo
                if (_log.IsTraceEnabled)
                {
                    // HTTP{fB
                    StringBuilder responseBody = new StringBuilder();
                    responseBody.AppendLine(Properties.Resources.T_RESPONSE_RECEIVE_BODY);
                    using (Stream st = new MemoryStream())
                    {
                        receiveXml.Save(st);
                        st.Position = 0;
                        StreamReader reader = new StreamReader(st);
                        responseBody.Append(reader.ReadToEnd());
                    }
                    _log.Trace(responseBody.ToString());
                }

                ServerException exception = HandleErrorResult(errorType, receiveXml);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            // wb_Ɋi[ꂽt@C擾
            string contentFileName = GetContentFileName(response);

            // ۑt@CpX擾
            string filePath = GetDownloadFilePath(contentFileName, reporter);

            DownloadResult result = null;

            // ۑt@C擾łꍇɂ̓_E[hEۑsB
            if (!string.IsNullOrEmpty(filePath))
            {
                result = ReceiveAndSaveBinaryFile(response, filePath, reporter);

                // M̃Oo
                if (_log.IsTraceEnabled)
                {
                    // Mt@C̕ۑpX
                    _log.Trace(string.Format(Properties.Resources.T_DOWNLOAD_FILE_PATH, filePath));
                }
            }
            else
            {
                result = CreateDownloadResult(response, null);

                // M̃Oo
                if (_log.IsTraceEnabled)
                {
                    // t@CMłȂƂOo͂
                    _log.Trace(string.Format(Properties.Resources.T_DOWNLOAD_FAILED, filePath));
                }
            }

            return result;
        }

        /// <summary>
        /// HTTP X|Xwb_ Content-Disposition tB[hɊi[ꂽt@C擾܂B
        /// </summary>
        /// <remarks>
        /// HTTP X|Xwb_ Content-Disposition tB[h݂ꍇA
        /// filename ̒lt@CƂĐ؂oA <see cref="DecodeFileName"/> \bhp
        /// fR[hĕԋp܂B
        /// </remarks>
        /// <param name="response">HTTP X|XIuWFNgB</param>
        /// <returns>T[oM_E[ht@C\B</returns>
        /// <exception cref="CommunicationException">
        /// Content-Disposition Ɋ܂܂GR[h́AT|[gĂ܂B
        /// </exception>
        protected virtual string GetContentFileName(WebResponse response)
        {
            // wb_Content-Disoposition݂Ȃꍇ͉Ȃ
            string contentDisposition = response.Headers.Get(CONTENT_DISPOSITION);
            if (contentDisposition == null)
            {
                return null;
            }

            // Content-Dispositionwb_";"ŕłȂꍇ͉Ȃ
            string[] strArray = contentDisposition.Split(';');
            if (strArray.Length <= 1)
            {
                return null;
            }

            // filenameȍ~̕擾
            contentDisposition = strArray[1];

            string contentFileName = null;

            // ŏ'='ŕ𕪊
            int substrPos = contentDisposition.IndexOf('=');
            if (substrPos >= 0)
            {
                string keyStr = contentDisposition.Substring(0, substrPos).Trim();
                string valueStr = contentDisposition.Substring(substrPos + 1).Trim();
                // filenameȍ~̕擾
                if (CONTENT_DISPOSITION_FILENAME.Equals(keyStr) && !string.IsNullOrEmpty(valueStr))
                {
                    contentFileName = DecodeFileName(valueStr);
                }
            }

            return contentFileName;
        }

        /// <summary>
        /// Content-Disposition wb_擾t@CfR[h邽߂̃wp[\bhłB
        /// </summary>
        /// <param name="encodeStr">Content-Disposition wb_ filename Ɋi[ĂlB</param>
        /// <returns>fR[ht@CB</returns>
        /// <remarks>
        /// <para>Content-Disposition wb_Ɋ܂܂GR[h "B" ̏ꍇAfR[ht@Cԋp܂B</para>
        /// <para>"B" ȊÕGR[hw肳ꂽꍇ́AOX[܂B</para>
        /// </remarks>
        /// <exception cref="CommunicationException">
        /// Content-Disposition wb_Ɋ܂܂GR[h́AT|[gĂ܂B
        /// </exception>
        protected virtual string DecodeFileName(string encodeStr)
        {
            // vf`ł͂ȂA܂Base64`ł͂ȂꍇȂ
            string[] strArray = encodeStr.Split('?');
            if (strArray.Length < 5 || !ENCODE_TYPE.Equals(strArray[2]))
            {
                return null;
            }

            string fileName = null;
            byte[] byteArray = Convert.FromBase64String(strArray[3]);
            try
            {
                fileName = Encoding.GetEncoding(strArray[1]).GetString(byteArray);
            }
            catch (ArgumentException e)
            {
                CommunicationException exception = new CommunicationException(
                    string.Format(Properties.Resources.E_COMMUNICATION_INVALID_ENCODING, strArray[1]), e);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            return fileName;
        }

        /// <summary>
        /// <paramref name="reporter"/>  <see cref="IProgressChangeReporter.ReportProgressChanged"/> p
        /// ۑt@C擾邽߂̃wp[\bhłB
        /// </summary>
        /// <remarks>
        /// <para> L[ "DownloadReady" pāA<paramref name="reporter"/> Ƀ_E[h`A
        /// t@C擾܂B܂AT[ow肵 <paramref name="contentFileName"/>  L["ContentFileName"
        /// pĎw肵܂B̏ <see cref="IProgressChangeReporter.ReportProgressChanged"/> ֓n
        /// <see cref="ExecuteProgressChangedEventArgs"/>  <see cref="ExecuteProgressChangedEventArgs.Items"/> vpeB
        /// w肵܂B
        /// </para>
        /// <para>
        /// Ăяo <paramref name="reporter"/> ł́A<see cref="IProgressChangeReporter.ReportProgressChanged"/> 
        /// \bh <see cref="ExecuteProgressChangedEventArgs.Items"/> "DownloadReady" L[݂̑𒲂ׁA݂
        /// ꍇɂ́A<see cref="ExecuteProgressChangedEventArgs.Items"/>  "DownloadFilePath" L[Ƃ
        /// Mf[^̕ۑ̃t@CpX\ǉ܂B 
        /// </para>
        /// <para>
        /// <paramref name="reporter"/>  <see cref="ExecuteProgressChangedEventArgs.Items"/> ɃL[ "DownloadFilePath"
        /// Őݒ肵At@CƂĕԋp܂B
        /// </para>
        /// </remarks>
        /// <param name="contentFileName">T[ot@CƂĎw肵B</param>
        /// <param name="reporter">is󋵒ʒms<see cref="IProgressChangeReporter"/>CX^XB</param>
        /// <returns><paramref name="reporter"/> ɂĎw肳ꂽ_E[hf[^̕ۑt@CB</returns>
        protected virtual string GetDownloadFilePath(string contentFileName, IProgressChangeReporter reporter)
        {
            // ProgressChangedCxg(_E[hJnʒm)
            ExecuteProgressChangedEventArgs eventArgs = new ExecuteProgressChangedEventArgs(50);
            eventArgs.Items.Add(DOWNLOAD_READY, true);
            eventArgs.Items.Add(CONTENT_FILENAME, contentFileName);

            // s
            reporter.ReportProgressChanged(eventArgs);

            // _E[ht@CpXԂ
            return eventArgs.Items[DOWNLOAD_FILEPATH] as string;
        }

        /// <summary>
        /// <paramref name="response"/> œnꂽ <see cref="HttpWebResponse"/>pĎMf[^A
        /// <paramref name="saveFilePath"/> ɕۑ܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="response"/> œnꂽ <see cref="HttpWebResponse"/>pĎMf[^A
        /// <paramref name="saveFilePath"/> ɕۑ܂BHTTP X|Xwb_Ɋi[ꂽ́A߂l
        /// <see cref="DownloadResult"/> CX^X <see cref="CommunicationResult.ResponseHeaders"/> 
        /// SĒǉ܂Bt@C𐳏ɕۑꍇA<see cref="DownloadResult.DownloadFilePath"/>
        /// ɕۑt@CpX\i[܂B
        /// </para>
        /// <para>
        /// <see cref="CommunicationResult.ResultData"/>ɂ́A <see cref="DataSet"/> CX^Xi[܂B
        /// </para>
        /// <para>
        /// <paramref name="reporter"/>  <c>null</c> QƂł͂ȂꍇA
        /// <see cref="ReceiverBase.BufferSize"/> vpeBɐݒ肳ꂽobt@TCỸf[^iftHg8 KB jT[oɑM閈ɁA
        /// <see cref="IProgressChangeReporter.ReportProgressChanged"/> Cxg𔭐܂B
        /// </para>
        /// </remarks>
        /// <param name="response">Ms HTTP X|XIuWFNgB</param>
        /// <param name="saveFilePath">_E[ht@Cۑt@CpXB</param>
        /// <param name="reporter">is󋵒ʒms<see cref="IProgressChangeReporter"/>CX^XB</param>
        /// <returns>ʐMʂ\ <see cref="DownloadResult"/> CX^XB</returns>
        protected virtual DownloadResult ReceiveAndSaveBinaryFile(WebResponse response,
                                                             string saveFilePath,
                                                             IProgressChangeReporter reporter)
        {
            string tempFilePath = Path.GetTempFileName();
            try
            {
                // X|XoCif[^̓ǂݍݏ
                using (Stream resStream = response.GetResponseStream())
                {
                    // ꎞt@C̏ݏ
                    using (Stream downFileStream = new FileStream(tempFilePath, FileMode.Create, FileAccess.Write))
                    {
                        int localBufferSize = BufferSize;

                        int percentage = 0;
                        long receiveSize = 0L;
                        long totalSize = response.ContentLength;

                        byte[] buffer = new byte[localBufferSize];
                        int bufferSize = resStream.Read(buffer, 0, localBufferSize);
                        while (bufferSize > 0)
                        {
                            // t@C
                            downFileStream.Write(buffer, 0, bufferSize);

                            // Cxgʒm
                            receiveSize += bufferSize;
                            // |[^[݂Ă
                            if (reporter != null)
                            {
                                if (totalSize > 0)
                                {
                                    percentage = CalcReceivePercentage(receiveSize, totalSize);
                                }
                                reporter.ReportProgressChanged(new ExecuteProgressChangedEventArgs(percentage));

                            }

                            bufferSize = resStream.Read(buffer, 0, localBufferSize);
                        }
                    }
                }

                // ꎞt@C̈ړ
                File.Copy(tempFilePath, saveFilePath, true);
                    
            }
            catch (Exception e)
            {
                TerasolunaException exception = new TerasolunaException(string.Format(Properties.Resources.E_BINARY_DOWNLOAD_ERROR, saveFilePath), e);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            finally
            {
                // ꎞt@C폜it@CȂĂAO̓X[Ȃj
                File.Delete(tempFilePath);
            }

            DownloadResult result = CreateDownloadResult(response, saveFilePath);
            return result;

        }

        /// <summary>
        /// HTTP X|XƎMf[^i[<paramref name="receiveData"/>ɁA
        /// ʐMʂ\ <see cref="CommunicationResult"/> CX^X쐬܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// ʐMʂ\ <see cref="DownloadResult"/> 𐶐܂B<see cref="CommunicationResult.ResultData"/>
        ///  vpeB <paramref name="receiveData"/> i[A<see cref="CommunicationResult.ResponseHeaders"/>vpeB
        /// HTTP X|Xwb_̃L[/lSĒǉ܂B<see cref="DownloadResult.DownloadFilePath"/> vpeB
        /// <paramref name="saveFilePath"/> œnꂽݒ肵܂B
        /// </para>
        /// <para>
        /// <see cref="CommunicationResult.ResultData"/>ɂ́A <see cref="DataSet"/> CX^Xi[܂B
        /// </para>
        /// <para>
        /// ̃\bh <c>null</c> QƂԂ܂B
        /// </para>
        /// </remarks>
        /// <param name="response">Ms HTTP X|XIuWFNgB</param>
        /// <param name="saveFilePath">_E[ht@Cۑt@CpXB</param>
        /// <returns>ʐMʂ\ <see cref="DownloadResult"/> CX^XB</returns>
        protected virtual DownloadResult CreateDownloadResult(WebResponse response, string saveFilePath)
        {
            DownloadResult result = new DownloadResult(saveFilePath);
            result.ResultData = new DataSet();
            foreach (string key in response.Headers.Keys)
            {
                result.ResponseHeaders.Add(key, response.Headers[key]);
            }
            return result;
        }

    }
}
